#include<stdio.h>
#include<stdlib.h>
#include"mytype.h"


/* 
    Make INDEX file from Dictionary File

     programed by Heo, Junhyeok  jhheo@vr.kaist.ac.kr
     1993. 3. 28 
*/
 

int ispumsa(char *buf)
{
    if(buf[strlen(buf)-1]==',')   return 1;
    if(buf[strlen(buf)-1]==';')   return 1;

    if(!strcmp(buf,"n"))          return 1;
    if(!strcmp(buf,"vb"))         return 1;
    if(!strcmp(buf,"indefinite")) return 1;
    if(!strcmp(buf,"adv"))        return 1;
    if(!strcmp(buf,"adj"))        return 1;
    if(!strcmp(buf,"prep"))       return 1;
    if(!strcmp(buf,"pron"))       return 1;
    if(!strcmp(buf,"interj"))     return 1;
    if(!strcmp(buf,"conj"))       return 1;
    return 0;
}

void remove_dot(char *buf)
 {     int i,j;
       for(j=0,i=0;i<strlen(buf);i++)
        if(buf[i]!='.')
           buf[j++]=buf[i];        /* delte '.' */
       buf[j]=buf[i];
  }

int is_word_end(char *word)
   {
       if(word[0]=='\\')  return 1; /* this means word have pronounciation */
       if(word[0]==':') return 1;
       if(word[0]=='-' && word[1]=='-') return 1;
       if((!strcmp(word,"or"))||(!strcmp(word,"also"))) return 1;
                  /* word=="or" || "also" */
       if(ispumsa(word)) return 1;
       return 0;
    }

void filter(char *word)
 {
      char temp[255];
      int  i,j;

      for(i=0,j=0;i<strlen(word);i++)
	  if(word[i]!=' ')
	     temp[j++]=word[i];
      temp[j]='\0';
      strcpy(word,temp);
 }

char line[255];
char line_ptr=-1;

int  get_line_from_file(FILE *fp)
{
    if(fgets(line,255,fp)==NULL)
      return 0;

    while(line[0] == '\n')
    { if(fgets(line,255,fp)==NULL)
       return 0; }

    line_ptr = 0;
    return 1;
  }

void get_word_from_line(char *buf)
{
    int j;
    if(line_ptr<0)
       buf[0]='\0'; 
    else
     {
       while(isspace(line[line_ptr])&&line[line_ptr]!='\n') line_ptr++;
		 /* skip white characters */
       if(line[line_ptr]=='\n')
	 { line_ptr = -1; buf[0]='\0'; return;}
       for(j=0;!isspace(line[line_ptr])&&line[line_ptr]!='\n';line_ptr++,j++)
	  buf[j] = line[line_ptr];
       if(line[line_ptr]=='\n')
	  { line_ptr = -1; } 
       buf[j]='\0';
      }
 }

int main(int argc,char *argv[])
{
    FILE *DF, *out;
    char word[255],buf[255];
    UINT word_num=0;
    LONG pos,dic_size;

    int i;
    int ch;

    if(argc < 2)
    { fprintf(stderr,"Usage:makeidx dictionaryfile idxfile\n");
      exit(-1);
     }

    DF = fopen(argv[1],"r");
    if(DF == NULL)
      {
	fprintf(stderr,"No such %s file\n",argv[1]);
        exit(-1);
      }
    strcpy(word,argv[1]);
    strcat(word,".idx");
    out = fopen(word,"w");
    if(out == NULL)
      {
        fprintf(stderr,"No such %s file\n",word);
        exit(-1);
      } 
    pos=ftell(DF);
    while(get_line_from_file(DF))
     {
       get_word_from_line(word);
       if(word[0]=='@')
	 { word_num++;
           pos = ftell(DF) - strlen(line);
	   if(isdigit(word[1]))
		get_word_from_line(word);
	   else
		strcpy(word,(word+1));
	   }
       else if((word[0]=='-')&&(word[1]=='-')&&(word[2]!=','))
	 { word_num++;
	   get_word_from_line(word);
	   }
       else
	   continue; 

       remove_dot(word);
       get_word_from_line(buf);
       if(buf[0]!='\0')
       { while(!is_word_end(buf)&&word[strlen(word)-1]!=',')
	 {
	   remove_dot(buf);
	   strcat(word," ");
	   strcat(word,buf);
	   get_word_from_line(buf);
	   if(buf[0]=='\0') break;
	   }
	}
       if(word[strlen(word)-1]==',')
            word[strlen(word)-1]='\0';

       filter(word);
       fputs(word,out);
       fprintf(out," %u\n",pos);
       /* printf(" %-30s %u \n",word,pos);  */
      }
     fprintf(out,"%d",word_num);
     fclose(DF);
     fclose(out);
     printf("The number of words : %d \n",word_num);
return 0;
}
