/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstring>
#include<cmath>
#include<cctype>
#include<cstdarg>
#include<ctime>
#include<cerrno>
#include"open_files.h"
#include"makeps.h"

static const char * __prologue = "%%DocumentFonts: (atend)\n"
"%%EndComments\n"
"%%BeginProlog\n"
"/inch { 72 mul } bind def\n"
"/mm { inch 25.4 div } bind def\n"
"/cm { inch 2.54 div } bind def\n"
"/degres { 180.0 mul 3.1415927 div } def\n"
"/POINT { /y exch def /x exch def\n"
"currentlinewidth 0.5 mul /rayon exch def\n"
"newpath x y moveto x y rayon 0 360 arc closepath fill\n"
" } bind def\n"
"/LINE { /y2 exch def /x2 exch def /y1 exch def /x1 exch def\n"
"newpath   x1 y1 moveto x2 y2 lineto\n"
"stroke} bind def\n"
"/SPLINE{ /y4 exch def /x4 exch def /y3 exch def /x3 exch def\n"
"/y2 exch def /x2 exch def /y1 exch def /x1 exch def\n"
"newpath   x1 y1 moveto x2 y2 x3 y3 x4 y4 curveto\n"
"stroke} bind def\n"
"/ARC { /fin exch def /debut exch def /rayon exch def\n"
"/y exch def /x exch def\n"
"newpath  x y rayon debut fin arc stroke\n"
" } bind def\n"
"/PIE { /fin exch def /debut exch def /rayon exch def\n"
"/y exch def /x exch def\n"
"newpath x y moveto x y rayon debut fin arc closepath fill stroke\n"
" } bind def\n"
"/CIRCLE { /rayon exch def /y exch def /x exch def\n"
"newpath  x y rayon 0 360 arc closepath stroke\n"
" } bind def\n"
"/FCIRCLE { /rayon exch def /y exch def /x exch def\n"
"newpath  x y rayon 0 360 arc closepath fill stroke\n"
" } bind def\n"
"/RECT { /dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"  newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/FRECT { /dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"currentlinewidth 0 setlinewidth newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath fill setlinewidth\n"
"} bind def\n"
"/DIAMOND { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 2 sub moveto\n"
"2 2 rlineto\n"
"2 neg 2 rlineto\n"
"2 neg 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/BOX { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x 1 add y 1 sub moveto\n"
"0 2 rlineto\n"
"2 neg 0 rlineto\n"
"0 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/PLUS { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1 sub moveto\n"
"0 2 rlineto\n"
"x 1 sub y moveto\n"
"2 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/CROSS { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x 1 sub y 1 sub moveto\n"
"2 2 rlineto\n"
"x 1 sub y 1 add moveto\n"
"2 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/TRUP{ /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1.732 add moveto\n"
"2 neg 3.464 neg rlineto\n"
"4 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/TRDOWN{ /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1.732 sub moveto\n"
"2 3.464 rlineto\n"
"4 neg 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/MIRROR {\n"
"/angle exch def\n"
"2 angle mul cos /x1 exch def\n"
"2 angle mul sin neg /y1 exch def\n"
"2 angle mul sin neg /x2 exch def\n"
"2 angle mul cos neg /y2 exch def\n"
"[ x1 y1 x2 y2 0 0] concat\n"
"} bind def\n"
"/CLIP {\n"
"/dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"gsave\n"
"newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath\n"
"clip\n"
"} bind def\n"
"/UNCLIP {\n"
"grestore\n"
"} bind def\n"
"/lw 1 def\n"
"/SETSOLID { [] 0 setdash } bind def\n"
"/SETDASH { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[x] 0 setdash} bind def\n"
"/SETDOT { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[lw x] 0 setdash} bind def\n"
"/SETDASHDOT { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[x x lw x] 0 setdash} bind def\n"
"/CURRFONT /Helvetica def\n"
"/SETFONT { /CURRFONT exch def } bind def\n"
"/fsize 12 def\n"
"/SETFS { /fsize exch def fsize CURRFONT findfont exch scalefont setfont }def \n"
"/PRINT { /chaine exch def moveto chaine show }def\n"
"/PRINTROT { /chaine exch def /angle exch def moveto angle rotate chaine show angle neg rotate } bind def\n"
"%%EndProlog\n"
"\n"
"";

static const char * __epsprologue = "%%DocumentFonts: (atend)\n"
"%%EndComments\n"
"%%BeginProlog\n"
"/mppdict 51 dict def\n" //But the definitions are only 50
"mppdict begin\n"
"/x 0 def\n"
"/y 0 def\n"
"/x1 0 def\n"
"/y1 0 def\n"
"/x2 0 def\n"
"/y2 0 def\n"
"/x3 0 def\n"
"/y3 0 def\n"
"/x4 0 def\n"
"/y4 0 def\n"
"/dx 1 def\n"
"/dy 1 def\n"
"/fin 360 def\n"
"/debut 0 def\n"
"/rayon 10 def\n"
"/lw 1 def\n"
"/CURRFONT /Helvetica def\n"
"/fsize 12 def\n"
"/chaine (Hello world !) def\n"
"/angle 90 def\n"
"/inch { 72 mul } bind def\n"
"/mm { inch 25.4 div } bind def\n"
"/cm { inch 2.54 div } bind def\n"
"/degres { 180.0 mul 3.1415927 div } def\n"
"/POINT { /y exch def /x exch def\n"
"currentlinewidth 0.5 mul /rayon exch def\n"
"newpath x y moveto x y rayon 0 360 arc closepath fill\n"
" } bind def\n"
"/LINE { /y2 exch def /x2 exch def /y1 exch def /x1 exch def\n"
"newpath   x1 y1 moveto x2 y2 lineto\n"
"stroke} bind def\n"
"/SPLINE{ /y4 exch def /x4 exch def /y3 exch def /x3 exch def\n"
"/y2 exch def /x2 exch def /y1 exch def /x1 exch def\n"
"newpath   x1 y1 moveto x2 y2 x3 y3 x4 y4 curveto\n"
"stroke} bind def\n"
"/ARC { /fin exch def /debut exch def /rayon exch def\n"
"/y exch def /x exch def\n"
"newpath  x y rayon debut fin arc stroke\n"
" } bind def\n"
"/PIE { /fin exch def /debut exch def /rayon exch def\n"
"/y exch def /x exch def\n"
"newpath x y moveto x y rayon debut fin arc closepath fill stroke\n"
" } bind def\n"
"/CIRCLE { /rayon exch def /y exch def /x exch def\n"
"newpath  x y rayon 0 360 arc closepath stroke\n"
" } bind def\n"
"/FCIRCLE { /rayon exch def /y exch def /x exch def\n"
"newpath  x y rayon 0 360 arc closepath fill stroke\n"
" } bind def\n"
"/RECT { /dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"  newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/FRECT { /dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"currentlinewidth 0 setlinewidth newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath fill setlinewidth\n"
"} bind def\n"
"/DIAMOND { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 2 sub moveto\n"
"2 2 rlineto\n"
"2 neg 2 rlineto\n"
"2 neg 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/BOX { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x 1 add y 1 sub moveto\n"
"0 2 rlineto\n"
"2 neg 0 rlineto\n"
"0 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/PLUS { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1 sub moveto\n"
"0 2 rlineto\n"
"x 1 sub y moveto\n"
"2 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/CROSS { /y exch def\n"
"/x exch def\n"
"newpath\n"
"x 1 sub y 1 sub moveto\n"
"2 2 rlineto\n"
"x 1 sub y 1 add moveto\n"
"2 2 neg rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/TRUP{ /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1.732 add moveto\n"
"2 neg 3.464 neg rlineto\n"
"4 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/TRDOWN{ /y exch def\n"
"/x exch def\n"
"newpath\n"
"x y 1.732 sub moveto\n"
"2 3.464 rlineto\n"
"4 neg 0 rlineto\n"
"closepath stroke\n"
"} bind def\n"
"/MIRROR {\n"
"/angle exch def\n"
"2 angle mul cos /x1 exch def\n"
"2 angle mul sin neg /y1 exch def\n"
"2 angle mul sin neg /x2 exch def\n"
"2 angle mul cos neg /y2 exch def\n"
"[ x1 y1 x2 y2 0 0] concat\n"
"} bind def\n"
"/CLIP {\n"
"/dy exch def\n"
"/dx exch def\n"
"/y exch def\n"
"/x exch def\n"
"gsave\n"
"newpath\n"
"x y moveto\n"
"dx 0 rlineto\n"
"0 dy rlineto\n"
"dx neg 0 rlineto\n"
"closepath\n"
"clip\n"
"} bind def\n"
"/UNCLIP {\n"
"grestore\n"
"} bind def\n"
"/SETSOLID { [] 0 setdash } bind def\n"
"/SETDASH { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[x] 0 setdash} bind def\n"
"/SETDOT { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[lw x] 0 setdash} bind def\n"
"/SETDASHDOT { currentlinewidth /lw exch def\n"
"lw 3 mul /x exch def\n"
"[x x lw x] 0 setdash} bind def\n"
"/SETFONT { /CURRFONT exch def } bind def\n"
"/SETFS { /fsize exch def fsize CURRFONT findfont exch scalefont setfont }def \n"
"/PRINT { /chaine exch def moveto chaine show }def\n"
"/PRINTROT { /chaine exch def /angle exch def moveto angle rotate chaine show angle neg rotate } bind def\n"
"end\n"
"%%EndProlog\n"
"\n"
"";

static const char *__mediaNames[] = {
  "A3 842 1190 0 () ()",
  "A4 595 842 0 () ()",
  "A5 420 595 0 () ()",
  "B4 729 1032 0 () ()",
  "B5 516 729 0 () ()",
  "Letter 612 792 0 () ()",
  "Legal 612 1008 0 () ()"
};

static const char *__fontNames[] = {
  "Helvetica ",
  "Helvetica-Bold ",
  "Courier ",
  "Courier-Bold ",
  "Courier-Oblique ",
  "Times ",
  "Times-Bold ",
  "Times-Italic ",
  "Times-Roman ",
  "Symbol "
};

/* Max possible size (:= lenght+1) for a font name (at the moment) */
#define MAX_SIZE_FN 25 

/* Max possible value for a sheet-size */
#define MAX_SHEET_SIZE 1440 /* = 50.8 cm */

/* A useful macro */
#define MIN(a,b) ((a) < (b) ? (a) : (b) )

static struct infoPS ps;

static int ps_putc(int c)
{
  if( (ps.state) )
    {
      fputs("\n*** Warning: PostScript Device is out of order\n",stderr);
      return -2;
    }
  else
    {
      if( fputc(c,ps.file)==EOF )
	{
	  ps.state= OUT_OF_ORDER;
	  return -1;
	}
      else
	return 0;
    }
}

static int ps_printf(const char* fmt,...)
{
  va_list ap;

  if( (ps.state) )
    {
      fputs("\n*** Warning: PostScript Device is out of order\n",stderr);
      return -2;
    }
  else
    {
      va_start(ap,fmt);
      vfprintf(ps.file,fmt,ap);
      va_end(ap);
      if( ferror(ps.file) || feof(ps.file) )
	{
	  ps.state= OUT_OF_ORDER;
	  return -1;
	}
    }
  return 0;
}

int ps_init(const char* path, int mode, const char* t,const struct prmPS p)
{
  int i,errcode;
  time_t tt;

  if( (!t) || (!*t) )
    ps.title[0]='\0';
  else
    {
      strncpy(ps.title,t,MAX_TITLE_SIZE);
      ps.title[MAX_TITLE_SIZE-1]='\0';
    }
  if( (p.medium < PS_AUTOMATIC) || (p.medium >= PS_NSUPPM) )
    {
      fputs("\n*** Warning: Invalid sheet format, so Automatic has been set\n",stderr);
      ps.medium=PS_AUTOMATIC;
    }
  else
    ps.medium=p.medium;
  ps.npage= (p.manypages != 0) ? 0 : -1;
  ps.orientation= p.orient;
  ps.llx=MIN(p.llx,MAX_SHEET_SIZE);
  ps.lly=MIN(p.lly,MAX_SHEET_SIZE);
  ps.urx=MIN(p.urx,MAX_SHEET_SIZE);
  ps.ury=MIN(p.ury,MAX_SHEET_SIZE);
  for( i = 0; i < PS_NFONTS; ps.fontslist[i++] = PS_NULL )
    ;
  if( !(ps.file=open_file(path,mode,&errcode)) )
    {
      ps.state= OUT_OF_ORDER;
      return errcode;
    }
  else
    {
      errcode=0;
      ps.state= IS_WORKING;
      // you have to write the prologue
      if( (ps_printf("%%!PS-Adobe-3.0\n")) )
	return WRITE_ERROR;
      else
	{
	  if( (ps_printf(CREATOR)) )
	    return WRITE_ERROR;
	  time(&tt);
	  if( (ps_printf("%%%%CreationDate: %s",ctime(&tt))) )
	    return WRITE_ERROR;
	}
      /* *** */
      if( (ps.title[0]) )
	{
	  if( (ps_printf("%%%%Title: %s\n",ps.title)) )
	    return WRITE_ERROR;
	}
      /* *** */
      /* Now the Bounding Box */
      if( (ps.urx > ps.llx) && (ps.ury > ps.lly) )
	{
	  if( (ps_printf("%%%%BoundingBox: %hu %hu %hu %hu\n",ps.llx,ps.lly,ps.urx,ps.ury)) )
	    return WRITE_ERROR;
	}
      /* *** */
      if( ps.orientation == PS_PORTRAIT )
	errcode=ps_printf("%%%%Orientation: Portrait\n");
      else
	errcode=ps_printf("%%%%Orientation: Landscape\n");
      if( (errcode) )
	return WRITE_ERROR;
      /* *** */
      if(ps.npage==-1)
	errcode=ps_printf("%%%%Pages: 1\n");
      else
	errcode=ps_printf("%%%%Pages: (atend)\n");
      /* *** */
      if( (errcode) )
	return WRITE_ERROR;
      else
	{
	  if( ps.medium != PS_AUTOMATIC )
	    errcode=ps_printf("%%%%DocumentMedia: %s\n",__mediaNames[ps.medium]);
	}
      /* *** */
      if( (errcode) )
	return WRITE_ERROR;
      else
	errcode=ps_printf("%s",__prologue);
      if( (errcode) )
	return WRITE_ERROR;
      else
	return 0;
    }
}

int eps_init(const char* path, int mode, const char* t,const struct prmPS p)
{
  int i,errcode;
  time_t tt;

  if( (!t) || (!*t) )
    {
      fputs("\n*** Error: Cannot create an EPS document without a title\n",stderr);
      return INVALID_EPSF;
    }
  else
    {
      strncpy(ps.title,t,MAX_TITLE_SIZE);
      ps.title[MAX_TITLE_SIZE-1]='\0';
    }
  /* An eps file can be only single-page */
  if( (p.manypages) )
    fputs("\n*** Warning: An EPS document must be single-page, ignored multi-page option\n",stderr);
  ps.npage= -1;
  /* For an eps file sheet format is always Automatic */
  if( (p.medium != PS_AUTOMATIC) )
    fputs("\n*** Warning: For an EPS document specifying medium is meaningless\n",stderr);
  ps.medium= PS_AUTOMATIC;
  /* An EPS file does not have a precise orientation, so p.orient is ignored */
  /* ps.orientation= p.orient; */
  ps.llx=MIN(p.llx,MAX_SHEET_SIZE);
  ps.lly=MIN(p.lly,MAX_SHEET_SIZE);
  ps.urx=MIN(p.urx,MAX_SHEET_SIZE);
  ps.ury=MIN(p.ury,MAX_SHEET_SIZE);
  if( (ps.urx <= ps.llx) || (ps.ury <= ps.lly) )
    {
      fputs("\n*** Error: Invalid Bounding Box, EPS document can not be created\n",stderr);
      return INVALID_EPSF;
    }
  for( i = 0; i < PS_NFONTS; ps.fontslist[i++] = PS_NULL )
    ;
  if( !(ps.file=open_file(path,mode,&errcode)) )
    {
      ps.state= OUT_OF_ORDER;
      return errcode;
    }
  else
    {
      errcode=0;
      ps.state= IS_WORKING;
      // you have to write the prologue
      if( (ps_printf("%%!PS-Adobe-3.0 EPSF-3.0\n")) )
	return WRITE_ERROR;
      else
	{
	  if( (ps_printf(CREATOR)) )
	    return WRITE_ERROR;
	  time(&tt);
	  if( (ps_printf("%%%%CreationDate: %s",ctime(&tt))) )
	    return WRITE_ERROR;
	}
      /* *** */
      if( (ps.title[0]) )
	{
	  if( (ps_printf("%%%%Title: %s\n",ps.title)) )
	    return WRITE_ERROR;
	}
      /* *** */
      /* Now the Bounding Box */
      if( (ps_printf("%%%%BoundingBox: %hu %hu %hu %hu\n",ps.llx,ps.lly,ps.urx,ps.ury)) )
	return WRITE_ERROR;
//        if( ps.orientation == PS_PORTRAIT )
//  	errcode=ps_printf("%%%%Orientation: Portrait\n");
//        else
//  	errcode=ps_printf("%%%%Orientation: Landscape\n");
//        if( (errcode) )
//  	return WRITE_ERROR;
      /* *** */
      if( (ps_printf("%%%%Pages: 1\n")) )
	return WRITE_ERROR;
      else
	errcode=ps_printf("%s",__epsprologue);
      if( (errcode) )
	return WRITE_ERROR;
      else
	errcode=ps_printf("mppdict begin\n");
      if( (errcode) )
	return WRITE_ERROR;
      else
	return 0;
    }
}

int ps_done(void)
{
  int i,errcode=0;
  char Fontslist[PS_NFONTS*MAX_SIZE_FN]=" ";

  if(ps.npage==-1)
    errcode=ps_printf("showpage\n");
  errcode=ps_printf("%%%%Trailer\n");
  if( (errcode) )
    return WRITE_ERROR;
  /* *** */
  for(i=0 ; (i < PS_NFONTS) && (ps.fontslist[i] != PS_NULL) ; i++)
    strcat(Fontslist,__fontNames[ps.fontslist[i]]);
  errcode=ps_printf("%%%%DocumentFonts:%s\n",Fontslist);
  /* *** */
  if( (errcode) )
    return WRITE_ERROR;
  else
    {
      if( ps.npage!=-1 )
	errcode=ps_printf("%%%%Pages: %d\n",ps.npage);
    }
  /* *** */
  if( (errcode) )
    return WRITE_ERROR;
  else
    errcode=ps_printf("%%%%EOF\n");
  /* *** */
  if( (fclose(ps.file)) )
    return errno;
  else
    return 0;
}

int eps_done(int showpage)
{
  int i,errcode=0;
  char Fontslist[PS_NFONTS*MAX_SIZE_FN]=" ";

  if( (ps_printf("end\n")) )
    return WRITE_ERROR;
  else
    {
      if( (showpage) )
	errcode=ps_printf("showpage\n");
    }
  if( (errcode) )
    return WRITE_ERROR;
  else
    errcode=ps_printf("%%%%Trailer\n");
  if( (errcode) )
    return WRITE_ERROR;
  /* *** */
  for(i=0 ; (i < PS_NFONTS) && (ps.fontslist[i] != PS_NULL) ; i++)
    strcat(Fontslist,__fontNames[ps.fontslist[i]]);
  errcode=ps_printf("%%%%DocumentFonts:%s\n",Fontslist);
  /* *** */
  if( (errcode) )
    return WRITE_ERROR;
  else
    errcode=ps_printf("%%%%EOF\n");
  /* *** */
  if( (fclose(ps.file)) )
    return errno;
  else
    return 0;
}

int ps_close(void)
{
  if( (fclose(ps.file)) )
    return errno;
  else
    return 0;
}

int working_device(void)
{
  return (!ps.state);
}

void clearerr_device(void)
{
  ps.state= IS_WORKING;
}

void ps_newpage(void)
{
  if(ps.npage==-1)
    fputs("\n*** Illegal Operation: You are making a single-page document\n",stderr);
  else
    {
      ++ps.npage;
      ps_printf("%%%%Page: %d %d\n",ps.npage,ps.npage);
      ps_printf("gsave\n");
      //      ps_printf("0 0 translate\n");
      //      ps_printf("1 1 scale\n");
    }
}

void ps_endpage(void)
{
  if(ps.npage==-1)
    fputs("\n*** Illegal Operation: You are making a single-page document\n",stderr);
  else
    {
      ps_printf("grestore\nshowpage\n");
      ps_printf("%%%%PageTrailer\n");
      if( !working_device() )
	fputs("\n*** Warning: PostScript Device is out of order\n",stderr);
      else
	{
	  if( fflush(ps.file) == EOF )
	    ps.state= OUT_OF_ORDER;
	}
    }
}

void ps_save(void)
{
  ps_printf("gsave\n");
}

void ps_restore(void)
{
  ps_printf("grestore\n");
}

void ps_translate(double xt, double yt)
{
  ps_printf("%f %f translate\n",xt,yt);
}

void ps_rotate(double angle)
{
  double ipart;
  double alpha;

  if( fabs(angle) <= 360.0 )
    alpha=angle;
  else
    alpha=360.0*modf(angle/360.0,&ipart);
  ps_printf("%f rotate\n",alpha);
}

void ps_scale(double sx, double sy)
{
  ps_printf("%f %f scale\n",sx,sy);
}

void ps_mirror(double th)
{
  ps_printf("%f MIRROR\n",th);
}

void ps_push_clip(double x, double y, double w, double h)
{
  if( (w <= PS_EPS) || (h <= PS_EPS) )
    {
      fprintf(stderr,"\n\n+++ Inside %s at line %u",__FILE__,__LINE__);
      fprintf(stderr,"\n*** Error: width and height must be greater than %f\n", PS_EPS);
      return;
    }
  ps_printf("%.2f %.2f %.2f %.2f CLIP\n",x,y,w,h);
}

void ps_pop_clip(void)
{
  ps_printf("UNCLIP\n");
}

void ps_graylevel(double zerotoone)
{
  if( zerotoone < 0 )
    zerotoone= 0;
  if( zerotoone > 1 )
    zerotoone= 1;
  ps_printf("%f setgray\n",zerotoone); 
}

void ps_rgbcolor(unsigned char r, unsigned char g, unsigned char b)
{
  ps_printf("%f %f %f setrgbcolor\n",r/255.0,g/255.0,b/255.0);
}

void ps_hsbcolor(double h, double s, double b)
{
  h= (h < 0) ? 0 : h;
  h= (h > 1) ? 1 : h;
  s= (s < 0) ? 0 : s;
  s= (s > 1) ? 1 : s;
  b= (b < 0) ? 0 : b;
  b= (b > 1) ? 1 : b;   
  ps_printf("%f %f %f sethsbcolor\n",h,s,b);
}

void ps_linewidth(double size)
{
  if( size < 0 )
    size= 0;
  if( size > 144 )
    size= 144;
  ps_printf("%.2f setlinewidth\n",size);
}

void ps_linecap(unsigned type)
{
  if( type >= PS_NCAPTYPES )
    fputs("\n*** Warning: Unagreable cap type\n",stderr);
  else
    ps_printf("%u setlinecap\n",type);
}

void ps_linejoin(unsigned type)
{
  if( type >= PS_NJOINTYPES )
    fputs("\n*** Warning: Unagreable join type\n",stderr);
  else
    ps_printf("%u setlinejoin\n",type);
}

void ps_linedash(unsigned type)
{
  switch(type)
    {
    case PS_SOLID:
      ps_printf("SETSOLID\n");
      break;
    case PS_DASH:
      ps_printf("SETDASH\n");
      break;
    case PS_DOT:
      ps_printf("SETDOT\n");
      break;
    case PS_DASHDOT:
      ps_printf("SETDASHDOT\n");
      break;
    default:
      fputs("\n*** Warning: Unagreable dash type\n",stderr);
    }
}

void ps_font(int type, double size)
{
  int i;

  if(size < 1)
    size=1;
  if(size > 360)
    size=360;
  if( (type >= PS_NFONTS) || (type < 0) )
    {
      fputs("\n*** Warning: Unagreable fonttype\n",stderr);
    }
  else
    {
      ps_printf("/%s SETFONT\n",__fontNames[type]);
      ps_printf("%.2f SETFS\n",size);
      for(i= 0 ; (ps.fontslist[i] != PS_NULL) && (ps.fontslist[i] != type);\
	    i++) ;
      if(ps.fontslist[i]==PS_NULL)
	/* The font "type" has not been loaded yet */
	ps.fontslist[i]=type;
    }
}

void ps_write(const char* str, int n)
{
  if (!str)
    return;
  ps_printf(" (");
  for( ; (*str) && n-- ; str++)
    {
      if( !isprint(*str) )
	ps_putc(' ');
      else
	{
	  switch (*str)
	    {
	    case '\n':
	      ps_printf("\\n");
	      break;
	    case '\t':
	      ps_printf("\\t");
	      break;
	    case '\f':
	      ps_printf("\\f");
	      break;
	    case '\r':
	      ps_printf("\\r");
	      break;
	    case '\v':
	      ps_printf("\\v");
	      break;
	    case '(': case ')':
	      ps_printf("\\%c",(*str));
	      break;
	    default:
	      ps_putc(*str);
	    }
	}
    }// end for(...)
  ps_printf(") ");
}

void ps_diamond(double x, double y)
{
  ps_printf("%.2f %.2f DIAMOND\n",x,y);
}
 
void ps_box(double x, double y)
{
  ps_printf("%.2f %.2f BOX\n",x,y);
}

void ps_plus(double x, double y)
{
  ps_printf("%.2f %.2f PLUS\n",x,y);
}

void ps_cross(double x, double y)
{
  ps_printf("%.2f %.2f CROSS\n",x,y);
}

void ps_trup(double x, double y)
{
  ps_printf("%.2f %.2f TRUP\n",x,y);
}

void ps_trdown(double x, double y)
{
  ps_printf("%.2f %.2f TRDOWN\n",x,y);
}

void ps_point(double x, double y)
{
  ps_printf("%.2f %.2f POINT\n",x,y);
}

void ps_line(double x1, double y1, double x2, double y2)
{
  ps_printf("%.2f %.2f %.2f %.2f LINE\n",x1,y1,x2,y2);
}

void ps_curve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4)
{
  ps_printf("%.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f SPLINE\n",x1,y1,x2,y2,x3,y3,x4,y4);
}

void ps_polyline(double x[], double y[], unsigned nvert)
{
  unsigned i;

  ps_printf("newpath %.2f %.2f moveto\n",x[0],y[0]);
  for(i=1 ; i< nvert ; i++)
    ps_printf("%.2f %.2f lineto\n",x[i],y[i]);
  ps_printf(" stroke\n");
}

void ps_rect(double x, double y, double w, double h)
{
  if( (w <= PS_EPS) || (h <= PS_EPS) )
    {
      fprintf(stderr,"\n\n+++ Inside %s at line %u",__FILE__,__LINE__);
      fprintf(stderr,"\n*** Error: width and height must be greater than %f\n", PS_EPS);
      return;
    }
  ps_printf("%.2f %.2f %.2f %.2f RECT\n",x,y,w,h);
}

void ps_loop(double x[], double y[], unsigned nvert)
{
  unsigned i;

  if(nvert < 3)
    return;
  else
    {
      ps_printf("newpath %.2f %.2f moveto\n",x[0],y[0]);
      for(i=1 ; i< nvert ; i++)
	ps_printf("%.2f %.2f lineto\n",x[i],y[i]);
      ps_printf(" closepath stroke\n");
    }
}

void ps_arc(double x, double y, double w, double h, double a1, double a2)
{
  if( (w <= PS_EPS) || (h <= PS_EPS) )
   {
     fprintf(stderr,"\n\n+++ Inside %s at line %u",__FILE__,__LINE__);
     fprintf(stderr,"\n*** Error: width and height must be greater than %f\n", PS_EPS);
     return;
   } 
  ps_printf("gsave\n");
  ps_printf("%f %f translate\n",x+w/2.0,y+h/2.0);
  ps_printf("%f %f scale\n",w/2.0,h/2.0);
  ps_printf(" 0 setlinewidth\n");
  if (a2-a1 >= 360)
    ps_printf("0 0 1 CIRCLE\n");
  else
    ps_printf("0 0 1 %.2f %.2f ARC\n",a1,a2);
  ps_printf("grestore\n");
}

void ps_rectf(double x, double y, double w, double h)
{
  if( (w <= PS_EPS) || (h <= PS_EPS) )
    {
      fprintf(stderr,"\n\n+++ Inside %s at line %u",__FILE__,__LINE__);
      fprintf(stderr,"\n*** Error: width and height must be greater than %f\n", PS_EPS);
      return;
    }
  ps_printf("%.2f %.2f %.2f %.2f FRECT\n",x,y,w,h);
}

void ps_polygon(double x[], double y[], unsigned nvert)
{
  unsigned i;

  if(nvert < 3)
    return;
  else
    {
      ps_printf("gsave\n");
      ps_printf(" 0 setlinewidth\n");
      ps_printf("newpath %.2f %.2f moveto\n",x[0],y[0]);
      for(i=1 ; i< nvert ; i++)
	ps_printf("%.2f %.2f lineto\n",x[i],y[i]);
      ps_printf(" closepath fill stroke\n");
      ps_printf("grestore\n");
    }
}

void ps_pie(double x, double y, double w, double h, double a1, double a2)
{
  if( (w <= PS_EPS) || (h <= PS_EPS) )
    {
      fprintf(stderr,"\n\n+++ Inside %s at line %u",__FILE__,__LINE__);
      fprintf(stderr,"\n*** Error: width and height must be greater than %f\n", PS_EPS);
      return;
    }
  ps_printf("gsave\n");
  ps_printf("%f %f translate\n",x+w/2.0,y+h/2.0);
  ps_printf("%f %f scale\n",w/2.0,h/2.0);
  ps_printf(" 0 setlinewidth\n");
  if (a2-a1 >= 360)
    ps_printf("0 0 1 FCIRCLE\n");
  else
    ps_printf("0 0 1 %.2f %.2f PIE\n",a1,a2);
  ps_printf("grestore\n");
}

void ps_text(const char * t, double x, double y)
{
  ps_printf("%.2f %.2f ",x,y);
  ps_write(t,strlen(t)+1);
  ps_printf(" PRINT\n");
}

void ps_text(const char * t, int n, double x, double y)
{
  ps_printf("%.2f %.2f ",x,y);
  ps_write(t,n);
  ps_printf(" PRINT\n");
}

