/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#ifndef _Graphutils_
#define _Graphutils_

#include"mplot.h"

struct sline {
  float x0,y0; // origin
  float l,m; // direction
};

struct Rect{
  float x0,y0; // coordinates of the intersection point of the diagonals
  float a,b;   // width and height of the rectangle
};

const float epsilon=0.00001;

// This function returns the absolute value of x
float absv(float x);


// The 2 following functions return the x-coordinate (y-coordinate)
// of the intersection of the line (0,0)----(x,y)--->   with the square
// whose side is equal to s

float xsq(float x,float y,float s);
float ysq(float x,float y,float s);

struct point Assonometria(const struct Param3d* par, const struct point p);
float norm(float x,float y);
int   colorcmp(const void* p1, const void* p2);


// The function below returns
//  0 when (x,y) belongs to rectangle R
//  1 when (x,y) is outside R

int isout(float x, float y, struct Rect R);


// Trova l'intersezione del segmento di estremi P1,P2 con il rettangolo R
// (un segmento o un punto, se non vuota) e ne restituisce in *Q1 e in *Q2
// i vertici.
// Ritorna 0 se [P1,P2] non interseca R, 1 in caso contrario.

int intersect(struct point P1,struct point P2, struct Rect R, struct point* Q1, struct point* Q2);

#endif
