/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cmath>
#include"mplot.h"
#define CM 10000000000.0

extern int angle_m;
extern double number;

/*
  La routine Call_function memorizza nella variabile double "number" il
  valore ottenuto applicando al valore contenuto in argument la
  funzione rappresentata da nome_fun.
  Ritorna il valore 0 in caso di successo e valori maggiori di 0
  per la segnalazione di eventuali errori.Per il significato di tali
  valori vedi il file mpmain.c.
  La variabile angle_m viene utilizzata per sapere se le funzioni
  trigonometriche e le loro inverse devono lavorare in gradi e decimali
  oppure in radianti.
*/

short
Call_function(short nome_fun,double arg)
{
  unsigned short i;

  switch(nome_fun)
    {
      double fp,ip,g,p,s;
      /* g=gradi,p=primi,s=secondi */

    case 0:
      number=exp(arg);
      break;
    case 1:
      if(arg<=0)
	return 6;
      number=log(arg);
      break;
    case 2:
      if(arg<=0)
	return 6;
      number=log10(arg);
      break;
    case 3:
      if(angle_m == 0)
	{
	  number=sin(arg*PI/180);
	}
      else
	number=sin(arg);
      break;
    case 4:
      if(angle_m == 0)
	number=cos(arg*PI/180);
      else
	number=cos(arg);
      break;
    case 5:
      if(angle_m == 0)
	{
	  arg=360*frac(arg/360);
	  arg= (arg<0) ? arg+360:arg;
	  if(fabs(arg-90)*CM<1)
	    return 8;
	  if(fabs(arg-270)*CM<1)
	    return 8;
	  number=tan(arg*PI/180);
	}
      if(angle_m == 1)
	{
	  arg=2*PI*frac(arg/(2*PI));
	  arg= (arg<0) ? arg+2*PI:arg;
	  if(fabs(arg-0.5*PI)*CM<0.02)
	    return 8;
	  if(fabs(arg-1.5*PI)*CM<0.02)
	    return 8;
	  number=tan(arg);
	}
      break;
    case 6:
      if(arg<-1 || arg>1)
	return 6;
      number=asin(arg);
      if(angle_m == 0)
	number*=(180/PI);
      break;
    case 7:
      if(arg<-1 || arg>1)
	return 6;
      number=acos(arg);
      if(angle_m == 0)
	number*=(180/PI);
      break;
    case 8:
      number=atan(arg);
      if(angle_m == 0)
	number*=(180/PI);
      break;
    case 9:
      number=sinh(arg);
      break;
    case 10:
      number=cosh(arg);
      break;
    case 11:
      number=tanh(arg);
      break;
    case 12:
      number=log(arg+sqrt(arg*arg+1));
      break;
    case 13:
      if(arg<1)
	return 6;
      number=log(arg+sqrt(arg*arg-1));
      break;
    case 14:
      if(arg<=-1 || arg>=1)
	return 6;
      number=0.5*log((1+arg)/(1-arg));
      break;
    case 15:
      if(arg<0)
	return 6;
      number=sqrt(arg);
      break;
    case 16:
      if(arg>0)
	number=exp(log(arg)/3);
      if(arg<0)
	number=-exp(log(fabs(arg))/3);
      if(arg==0)
	number=0;
      break;
    case 17:
      number=arg*arg;
      break;
    case 18:
      number=arg*arg*arg;
      break;
    case 19:
      fp=modf(arg,&number);
      break;
    case 20:
      number=floor(arg);
      break;
    case 21:
      number=modf(arg,&ip);
      break;
    case 22:
      g=360*(frac(arg/360));
      if(g<0)
	g+=360;
      p=intp(60*frac(g));
      s=3600*frac(g-p/60);
      g=intp(g);
      number=g+p/100+s/10000;
      break;
    case 23:
      g=intp(arg);
      p=intp(round(100*(arg-g)));
      s=10000*(arg-g-p/100);
      number=g+p/60+s/3600;
      break;
    case 24:
      if(arg==0)
	return 6;
      number=1/arg;
      break;
    case 25:
      if(arg<0 || arg>170)
	return 6;
      if(frac(arg)>0)
	return 6;
      number=1;
      if(arg>1)
	{
	  for(i=2;i<=trunc(arg);i++)
	    number*=i;
	}
      break;
    case 26:
      number=fabs(arg);
      break;
    case 27:
      number=-arg;
      break;
    default: /* L'azione di default viene eseguita quando j=-1,ossia quando */
      return 7; /* nome_fun non rientra fra quelli previsti.                */
    }  /* Fine switch(nome_fun) */
  return 0;
}
