/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstring>
#include<cctype>
#include<new>
#include "mplot.h"

int isnumbercomponent (char c)
{
  return (isdigit (c) + (c == '.') + (c=='\'') + (c=='\"') +(c=='E'));
}

/* Per l'uso di Find_end_block() vedere implementazione a fine file */

static int Find_end_block(char* s,int begin_block);

/* La funz.Expander espande opportunamente le occorrenze del carattere '_'*/
/* presenti in s restituendo 0 o un numero positivo in caso di errore.    */
/* Per ogni occorrenza di '_' sono possibili le seguenti alternative:     */
/*0)'_' non e` seguito da nessun carattere: nella stringa espansa,al posto*/
/* di "_",viene inserita la sequenza "N()";                               */
/*1)'_' e` seguito da una cifra [0...9] o dal punto decimale '.': in que- */
/* sto caso la funzione individua il numero che segue '_' e,indicato que- */
/* sto numero con x,scrive nella stringa espansa N(x) al posto di _x;     */
/*2)'_' e` seguito da $(che sta a simboleggiare il pi greco): la funzione */
/* scrive nella stringa espansa N($) al posto di _$;                      */
/*3)'_' e` seguito da '?': in questo caso la funzione scrive nella strin- */
/* ga espansa N(?) al posto di _?;                                        */
/*4)se '_' e` seguito  da '!' allora  la  funzione  scrive nella  stringa */
/* ga espansa N(!) al posto di _!;                                        */
/*5)'_' e` seguito da un segno operazionale: in questo caso nella stringa */
/* espansa compare N(#) al posto di _#,dove # e` il segno operazionale in */
/* questione;                                                             */
/*6)'_' e` seguito da ')': in questo caso la funzione scrive nella strin- */
/* ga espansa "N()" al posto della sequenza _);                           */
/*7)'_' e` seguito da '(': in  tale  eventualita` la funzione  scorre  la */
/* stringa s e per ogni parentesi aperta incontrata (inclusa  quella  che */
/* segue '_') incrementa l'indice j di 1 mentre lo decrementa di 1 per o- */
/* gni parentesi chiusa trovata;la lettura termina nel momento in cui  e` */
/* letta la parentesi chiusa che porta j ad assumere il valore zero;indi- */
/* cata con xxyy...zz la stringa compresa fra le parentesi estreme,la f.  */
/* trascrive in (*strexp) "N(xxyy...zz)" al posto di _(xxyy...zz);        */
/* (Se il contatore j,dopo aver assunto il valore 1,non riesce piu` a tor-*/
/* nare a 0 la funzione Expander termina restituendo il valore 11="Errore */
/* nella chiusura di parentesi")                                          */
/*8)'_' e` seguito da un carattere alfabetico: la routine  presuppone che */
/* quello che segue sia il nome di una funzione matematica e comincia per-*/
/* tanto col leggere tutti i caratteri  alfabetici che seguono '_'; fatto */
/* questo attende di dover leggere una parentesi aperta e se questa non e`*/
/* presente segnala un errore.Letta  la parentesi aperta  e  impostato il */
/* contatore j a 1,continua a scorrere la stringa s incrementando j di  1 */
/* per ogni parentesi aperta trovata e decrementandolo della stessa quan- */
/* tita` all'individuazione di una parentesi chiusa; lo scorrimento di  s */
/* va avanti finche' non viene trovata la parentesi chiusa che porta j ad */
/* assumere il valore 0.Indicato con fun il nome della funzione matemati- */
/* ca e con xxyy...zz la stringa compresa fra le parentesi estreme,si va  */
/* avanti con la sostituzione di _fun(xxyy...zz) con N(fun(xxyy...zz)).   */
/* In merito al caso (7) va osservato che:                                */
/* se dopo i caratteri alfabetici non segue parentesi aperta la funzione  */
/* termina restituendo il valore 24= "Segno operazionale o parentesi man- */
/* cante";                                                                */
/* se,dopo aver assunto il valore 1,il contatore j non riesce piu` a tor- */
/* nare a 0 la funzione Expander si interrompe restituendo il valore  11= */
/* "Errore nella chiusura di parentesi.                                   */
/* Se, mentre la funzione Expander viene eseguita, ha luogo una mancata   */
/* allocazione della memoria la funzione termina restituendo FATAL_ERROR. */

short Expander(char* s,char** strexp)
{
  int l=strlen(s);
  int lse=3*strlen(s);
  char* straux; /* stringa ausiliaria   */
  int h,i,j,k;  /* variabili contatore  */

  //: straux=(char*)malloc((lse+1)*sizeof(char));
  straux= new(nothrow) char[lse+1];
  if(!straux)
    return FATAL_ERROR;
  else
    strcpy(straux,s);
  //: *strexp=(char*)malloc((lse+1)*sizeof(char));
  *strexp= new(nothrow) char[lse+1];
  if(!(*strexp))
    return FATAL_ERROR;
  else
    strcpy(*strexp,s);
  while( strchr(straux,'_') )
    {
      for(h=0,i=0 ; h<l ; h++)
	{
	  if(straux[h]!='_')
	    (*strexp)[i++]=straux[h];
	  else
	    {
	      switch(straux[h+1])
		{
		case '\0':
		case ')':
		  (*strexp)[i]='N';
		  (*strexp)[i+1]='(';
		  (*strexp)[i+2]=')';
		  i+=3;
		  /* In questo modo il caratt. che segue l'underscore nella */ 
		  /* stringa straux al ciclo successivo viene saltato.      */
		  h++;
		  break; 
		case '1': case '2': case '3': case '4': case '5':
		case '6': case '7': case '8': case '9': case '0':
		case '.':
		  (*strexp)[i] = 'N';
		  (*strexp)[i+1]='(';
		  for(j=h+1 ; isnumbercomponent(straux[j]) ; j++) 
		    {
		      (*strexp)[i+j-h+1]=straux[j];
                  /* Nel momento in cui il ciclo cessa di essere iterato */  
		  /* j fa riferimento alla posizione del primo carattere */
                  /* di straux non trascritto nella stringa espansa      */
		    }
		  (*strexp)[i+j-h+1]=')';
		  i+=(j-h+2);
		  /* In questo modo al riavvio del ciclo h ha il valore j */
		  /* e la lettura riprende dal primo carattere di  straux */
		  /* non trascritto.                                      */
		  h=j-1;
		  break;
		case '$': case '!': case '\?': case '+': case '-': 
		case '*': case '/': case '\\': case '&': case '%': case '^':
		  (*strexp)[i]='N';
		  (*strexp)[i+1]='(';
		  (*strexp)[i+2]=straux[h+1];
		  (*strexp)[i+3]=')';
		  i+=4;
		  /* In questo modo il carattere che segue l'underscore nel-*/ 
		  /* la stringa straux al ciclo successivo viene saltato.   */
		  h++;   
		  break; 
		case '(':
		  j=Find_end_block(straux,h+1);
		  if(j==-1)
		    return 11;
		  else
		    {
		      (*strexp)[i]='N';
		      for(k=h+1 ; k<=j ; k++)
			(*strexp)[i+k-h]=straux[k];
		      i+=(j-h+1);
		      h=j;
		    }
		  break;
		case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
		case 'G': case 'H': case 'I': case 'J': case 'K': case 'L':
		case 'M': case 'N': case 'O': case 'P': case 'Q': case 'R':
		case 'S': case 'T': case 'U': case 'V': case 'W': case 'X':
		case 'Y': case 'Z':
		  (*strexp)[i] = 'N';
		  (*strexp)[i+1]='(';
		  for(j=h+1 ; isalpha(straux[j]) ; j++)
		    {
		      (*strexp)[i+j-h+1]=straux[j];
		    }
		  /* straux[j] dovrebbe essere una parentesi aperta */
		  if( straux[j]!='(' )
		    return 24;
		  k=Find_end_block(straux,j);
		  if(k==-1)
		    return 11;
		  else /* Leggera differenza rispetto al caso precedente */
		    {
		      for( ; j<=k ; j++)
			(*strexp)[i+j-h+1]=straux[j];
		      (*strexp)[i+k-h+2]=')';
		      i+=(k-h+3); 
		      h=k;
		    }
		  break;
		} /* Fine switch() */
	    } /* Fine else */
	} /* Fine for(h=0,i=0 ; h<l ; i++) */
      (*strexp)[i]='\0';
      strcpy(straux,*strexp);
      l=strlen(straux);
    } /* Fine while( strchr(straux,'_') ) */
  //: free((void*)straux);
  delete[] straux;
  return 0;
} /* Fine Expander() */ 	      

/* La funzione seguente accetta in input due parametri: un puntatore ad una */
/* espressione matematica  e un intero che sta ad indicare la  posizione al */
/* suo interno di una parentesi aperta.                                     */
/* La funzione restituisce la posizione della parentesi chiusa successiva a */
/* begin_block che risulta associata alla parentesi aperta localizzata  in  */
/* begin_block;questo vuol dire che le due parentesi delimitano il medesimo */
/* "livello algebrico".In caso di espr. errata la funzione restituisce -1.  */

int Find_end_block(char* s,int begin_block)
{
  int j=1;
  int count; /* Variabile contatore */
  int l=strlen(s);

  for(count=begin_block+1 ; (count<l) && (j>0) ; count++)
    {
      if( s[count]=='(' )
	j++;
      else if( s[count]==')' )
	j--;
    }
  return ( j==0 ? count-1 : -1); /* N.B.: count-1 >= 0 */
}
