/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstdlib> // For clean()
#include"mplot.h"

#define LSTR 56

extern struct __prm prm[]; // prm has MAX_NC size
// extern char expr1[],expr2[],expr3[];
extern struct item lista1[],lista2[],lista3[];
extern struct coppia *v1,*v2,*v3;

/* Elenco codici di errore

a) Codici relativi ad errori di tipo matematico e di sintassi

   (1) Mancata immissione o immissione errata di dati (numerici)
   (2) Immissione consecutiva di 2 o piu' operazioni
   (3) Elevamento a potenza di un numero negativo con esponente non intero
   (4) Elevamento a potenza di 0 con esponente minore o uguale di 0
   (5) Divisione per 0
   (6) Passaggio a funzione di argomento non valido
   (7) Chiamata a funzione inesistente
   (8) Overflow
   (9) Espressione vuota o argomento mancante
  (10) Eccesso di dati immessi o errore nell'apertura di parentesi
  (11) Errore nella chiusura di parentesi
  (23) Errore nell'impartizione di un comando
  (24) Segno operazionale mancante
  (27) Parentesi chiusa seguita subito da parentesi aperta
*/

char* Evaluate(int which, short* nel,int ic=0)
{
  char* expr;
  struct item* lista;
  struct coppia** v;
  static char str[LSTR];

  switch(which)
    {
    case 1:
      expr=prm[ic].x;
      lista=lista1;
      v=&v1;
      break;
    case 2:
      expr=prm[ic].y;
      lista=lista2;
      v=&v2;
      break;
    case 3:
      expr=prm[ic].z;
      lista=lista3;
      v=&v3;
    }
  if( (Delete_spaces(expr)) )
    {
      snprintf(str,LSTR,"Fatal error happened during execution\n");
      return str;
    }
  /* Vengono eseguite delle azioni sulla base del valore */
  /* di ritorno della funzione Check_Move()     */
  switch (Check_Move(expr,lista,nel))
    {
    case 1:
      snprintf(str,LSTR,"Insufficient data or wrong data");
      return str;
    case 2:
      snprintf(str,LSTR,"Consecutive immission of two or more operators");
      return str;
    case 7:
      snprintf(str,LSTR,"Inexistent function called");
      return str;
    case 9:
      snprintf(str,LSTR,"Empty expression or missing argument");
      return str;
    case 10:
      snprintf(str,LSTR,"Excess of data or error in opening parenthesis");
      return str;
    case 11:
      snprintf(str,LSTR,"Error in closing parenthesis");
      return str;
    case 24:
      snprintf(str,LSTR,"Missing operator or parenthesis");
      return str;
    case 27:
      snprintf(str,LSTR,"Unexpected open parenthesis after close parenthesis");
      return str;
    case FATAL_ERROR:
      snprintf(str,LSTR,"Fatal error happened during execution\n");
      return str;
    case 0:;
      /* Nihil */
    }
  switch(CommInt(lista,v,*nel))
    {
    case 1:
      snprintf(str,LSTR,"Insufficient data or wrong data");
      return str;
    case 7:
      snprintf(str,LSTR,"Inexistent function called");
      return str;
    case 8:
      snprintf(str,LSTR,"Overflow occurred");
      return str;
    case FATAL_ERROR:
      snprintf(str,LSTR,"Fatal error happened during execution\n");
      return str;
    case 0:
      /*Nihil*/;
    }
  return NULL;
}

void clean(int which)
{
  short i;

  switch(which)
    {
    case 3:
      for (i = 0 ; i < MAX_LUN ; i++)
	{
	  if(lista3[i].psz != NULL)
	    delete[] lista3[i].psz;
	}
      if( (v3) )
	{
	  delete[] v3;
	  v3=NULL;
	}
    case 2:
      for (i = 0 ; i < MAX_LUN ; i++)
	{
	  if(lista2[i].psz != NULL)
	    delete[] lista2[i].psz;
	}
      if( (v2) )
	{
	  delete[] v2;
	  v2=NULL;
	}
    case 1:
      for (i = 0 ; i < MAX_LUN ; i++)
	{
	  if(lista1[i].psz != NULL)
	    delete[] lista1[i].psz;
	}
      if( (v1) )
	{
	  delete[] v1;
	  v1=NULL;
	}
    }
}
