/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstring>
#include<new>
#include"mplot.h"

extern double number;
extern struct item lista1[],lista2[],lista3[]; // for CommExec()
extern struct coppia *v1,*v2,*v3;

/*
  La procedura CommInt ha il compito di interpretare e valutare le operazioni
  e funzioni che compaiono in expr; essa viene chiamata dopo la funzione Con-
  trolla_Traduci() in modo tale da poter agire sugli elementi  di lista[],os-
  sia sugli item gia` spezzati dell'espressione.
*/

short CommInt(struct item lista[],struct coppia **v,short nel)
{
  /* Ordine di priorita' delle operazioni:
     1) ^  (massimo)
     2) \
     3) &
     4) %
     5) /
     6) *
     7) -
     8) +  (minimo)
  */

  /* Il vettore v verra` utilizzato per memorizzare,in ordine decrescente,*/
  /* gli indici degli elementi di lista per cui prec>-1.                  */
  /* La struttura coppia e' cosi' dichiarata in mplot.h:                  */
  /* { short prec,index }                                                 */

  short i,j,k;

  /* k= numero elementi di lista per cui prec>=0             */
  for(i=0,k=0 ; i<nel ; i++)
    {
      if(lista[i].prec>=0)
	k++;
    }
  /* Viene riservata memoria per il vettore v sulla base del */
  /* numero k degli elementi di lista[] per cui prec>=0;     */
  /* In v si trovano memorizzate delle coppie precedenza/in- */
  /* dice,ciascuna delle quali in relazione con un un elemen-*/
  /* to di lista[] di cui indice da` l'offset all'interno di */
  /* questo array.                                           */
  *v = new(nothrow) coppia[k];
  if(!*v)
    return FATAL_ERROR;
  for(i=0,j=0;i<nel;i++)
    {
      if(lista[i].prec>-1)
	{
	  (*v)[j].prec=lista[i].prec;
	  (*v)[j].index=i;
	  j++;
	}
    }
  /* Facendo uso dell'algoritmo Bubble Sort gli elementi di v */
  /* vengono ordinati sulla base dei valori di prec; a  ciclo */
  /* compiuto,in v e'possibile leggere la sequenza con cui le */
  /* varie operaz. e funz. di expr vanno eseguite.Queste ven- */
  /* gono individuate sulla base dell'indice con cui compaio- */
  /* no in lista[].                                           */
  for(i=1;i<k;i++)
    {
      for(j=k-1;j>=i;j--)
	{
	  if((*v)[j-1].prec<(*v)[j].prec)
	    {
	      short h;

	      h=(*v)[j].prec;
	      (*v)[j].prec=(*v)[j-1].prec;
	      (*v)[j-1].prec=h;
	      h=(*v)[j].index;
	      (*v)[j].index=(*v)[j-1].index;
	      (*v)[j-1].index=h;
	    }
	}
    }
  for(i=0;i<nel;i++)
    {
      /* Se lista[i].psz e' una costante numerica...*/
      if(lista[i].prec==-1)
	{
	  int coderr;

	  /* La memorizza in lista[i].valore */
	  lista[i].valore=vald(lista[i].psz,&coderr);
	  if (coderr == FATAL_ERROR)
	    return FATAL_ERROR;
	  else if (coderr == 2)
	    return 8;
	  else if (coderr == 1)
	    return 1;
	}
      /* Se e' il simbolo di un parametro */
      else if(lista[i].prec<-1)
	{
	  /* Assegna un valore arbitrario a lista[i].type */
	  lista[i].type=-2;
	}
      /* Se invece e' un operatore */
      else if( isoperation(lista[i].psz[0]) )
	{
	  /* inserisce in lista[i].type */
	  /* il codice dell'operatore.  */
	  switch(lista[i].psz[0])
	    {
	    case '+':
	      lista[i].type=31;
	      break;
	    case '-':
	      lista[i].type=32;
	      break;
	    case '*':
	      lista[i].type=33;
	      break;
	    case '/':
	      lista[i].type=34;
	      break;
	    case '%':
	      lista[i].type=35;
	      break;
	    case '&':
	      lista[i].type=36;
	      break;
	    case '\\':
	      lista[i].type=37;
	      break;
	    case '^':
	      lista[i].type=38;
	      break;
	    }
	}
      /* Se poi e' un nome di funzione...*/
      else
	{
	  char *elenco[28] = { "EXP", "LN", "LOG", "SIN", "COS", "TAN",
			       "ASIN", "ACOS", "ATAN", "SINH", "COSH", "TANH",
			       "SSINH","SCOSH", "STANH", "SQRT", "CBRT", "SQR",
			       "CB","INT", "IP", "FRAC", "DMS", "DEG", "INV",
			       "FATT","ABS","N"
	  };

	  /* assegna a lista[i].type il codice di funzione */
	  /* relativo.                                     */
	  for(j=0;j<28;j++)
	    {
	      if(!strcmp(lista[i].psz,elenco[j]))
		{
		  lista[i].type=j;
		  break;
		}
	    }
	  /* Se il nome non rientra fra quelli elencati */
	  /* segnala un errore.                         */
	  if(lista[i].type==-1)
	    return 7;
	}
      /* A questo punto lista[i].psz non serve piu' */
      delete[] lista[i].psz;
      lista[i].psz=NULL;
    }   /* fine for */
  return 0;
}

/* s e t rappresentano i valori correnti dei parametri "?" e "!" */
/* ordinatamente.                                                */

short
CommExec(double s,double t,int which,short nel)
{
  /* Variabili ausiliarie*/
  struct item *lista;
  struct coppia* v;
  short i,k,h;
  double op1,op2,arg;

  switch(which)
    {
    case 1:
      lista=lista1;
      v=v1;
      break;
    case 2:
      lista=lista2;
      v=v2;
      break;
    case 3:
      lista=lista3;
      v=v3;
    }
  /* k= numero elementi di lista per cui prec>=0             */
  for(i=0,k=0;i<nel;i++)
    {
      lista[i].prec2=lista[i].prec;
      if(lista[i].prec>=0) k++;
    }
  for(i=0;i<nel;i++)
    {
      if(lista[i].prec2==-2)
	{
	  lista[i].valore=s;
	  lista[i].prec2=-1;
	}
      else if(lista[i].prec2==-3)
	{
	  lista[i].valore=t;
	  lista[i].prec2=-1;
	}
    }
  /* Inizia la procedura di valutazione delle varie operazioni e funzioni */
  /* In v[0].index si trova l'indice dell'elemento di lista[] in cui com- */
  /* pare la 1a operaz./funzione da eseguire,in v[1].index l'indice della */
  /* 2a e cosi' via   */
  for(i=0;i<k;i++)
    {
      /* Stabilisce se ha a che fare con una operazione o funzione */
      if( lista[v[i].index].type >=31) 
	/* Se ha a che fare con una operazione... */
	{
	  /* cerca il numero che la precede e lo copia in op1...*/
	  for(h=v[i].index-1;h>=0;h--)
	    {
	      if(lista[h].prec2==-1) /* Lista[h].psz e' un numero */
		{
		  op1=lista[h].valore;
		  lista[h].prec2=-10; /* Il numero e' stato utilizzato */
		  break;
		}
	    }
	  /* cerca il numero che la segue e lo copia in op2...*/
	  for(h=v[i].index+1;h<nel;h++)
	    {
	      if(lista[h].prec2==-1) /* Lista[h].psz e' un numero */
		{
		  op2=lista[h].valore;
		  lista[h].prec2=-10; /* Il numero e' stato utilizzato */
		  break;
		}
	    }
	  /* passa op1,op2,.type alla funzione Call_oper. perche' */
	  /* l'operazione venga eseguita e memorizza  il  valore  */
	  /* ritornato dalla funzione per sapere   di  eventuali  */
	  /* errori.                                              */
	  h=Call_operation(op1,op2,lista[v[i].index].type);
	}
      else    /* Se invece ha a che fare con una funzione...*/
	{
	  /* cerca l'argomento della funzione e lo copia in arg...*/
	  for(h=v[i].index+1;h<nel;h++)
	    {
	      if(lista[h].prec2==-1) /* Lista[h].psz e' un numero */
		{
		  arg=lista[h].valore;
		  lista[h].prec2=-10; /* Il numero e' stato utilizzato */
		  break;
		}
	    }
	  /* passa arg e .type a Call_fun. perche'la funzione venga */
	  /* calcolata e memorizza  il valore ritornato per sapere  */
	  /* di eventuali errori.                                   */
	  h=Call_function(lista[v[i].index].type,arg);
	}       /*fine if-else*/
      /* In caso di errore la procedura di valutazione termina restituen- */
      /* do il codice dell'errore;                                        */
      if(h>0)
	return h;
      /* altrimenti copia il risultato ottenuto,contenuto nella variabile */
      /* le globale number,in lista[v[i].index] al  posto  dell'operazione*/
      /* o funz. gia' valutata.                                           */
      lista[v[i].index].valore=number;
      lista[v[i].index].prec2=-1;
    }           /* fine for(i=0;i<k;i++) */
  /*...*/
  if( k==0 && nel==1)
    number=lista[0].valore;
  /*...*/
  /* lista[] viene scandagliata alla ricerca di elementi non nulli */
  for(i=0,h=0;i<nel;i++)
    h+=( lista[i].prec2 != -10  ? 1:0);
  /* se sono piu' di 1 vuol dire che in lista[] sono contenuti 2 o piu' */
  /* numeri,il che e' possibile solo supponendo che l'utente abbia di-  */
  /* menticato almeno un segno di operazione;viene pertanto  segnalato  */
  /* tale errore.                                                       */
  if(h>1)
    return 24;
  /* Se la valutazione di expr e' stata portata a termine */
  /* con successo ritorna il valore zero                  */
  return 0;
}
