
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include "dic.hh"

/*
     Revised By Heo, Junhyeok   jhheo@vr.kaist.ac.kr
     For Fast initializing and Not using up memory 
     1993.3.28
*/

#define WORD_MAXSIZE 50
#define ANS_MAXSIZE  10

UINT DicSize;
LONG EODic;

void set_DicSize_and_EODic(char *index)
{
     FILE *IF;
     LONG  pos;
     if((IF=fopen(index,"rb"))==NULL)
       { fprintf(stderr,"No %s index\n",index);
	 exit(-1);
	}
     fseek(IF,0L,SEEK_END);
     EODic=ftell(IF);
     fseek(IF,-sizeof(UINT),SEEK_END);
     fread(&DicSize,sizeof(UINT),1,IF);
     fclose(IF); 
}

void filter(char *buf)
{
     int i,j;
     for(i=0,j=0;i<strlen(buf);i++)
	 if(buf[i]!=' ')
	    buf[j++] = buf[i];
     buf[j]='\0';
 }

#define SET_DEFAULT_DICT(dict) strcpy(dict,_DICT);

main (void)
{
	int     pos;
	char	word[WORD_MAXSIZE];
	char	ans[ANS_MAXSIZE];
	char	dict[256];
	char	dict_index[256];
	char	*dict_name;

	if( (dict_name = getenv("DICTIONARY")) != NULL)
	    strcpy(dict,dict_name);
    else 
        SET_DEFAULT_DICT(dict);

	strcpy(dict_index,dict);
	strcat(dict_index,".bdx");

	set_DicSize_and_EODic(dict_index);
        cDic dictionary((int)DicSize,dict_index,dict);

	printf("---------------------------------------------\n");
	printf("===> Enter word : "); 
	fgets(word,WORD_MAXSIZE,stdin);word[strlen(word)-1]='\0';
	while (word[0]!='\0') 
	{
		filter(word);
		pos = dictionary.Search(word);
		if(pos<0) {
		  printf("No such word! Inexact search(y/n)? "); 
		  fgets(ans,ANS_MAXSIZE,stdin);
                  if(ans[0]=='y')
                  	{ printf("Are you sure the first character(y/n)? ");
			  fgets(ans,ANS_MAXSIZE,stdin);
                          if(ans[0]=='y')
                  	        dictionary.SimilarWords(word,*word);
			  else
                  	        dictionary.SimilarWords(word,0);
                         }
                }
		else
		    dictionary.PrintItem(pos);
		printf("===> Enter word : "); fgets(word,WORD_MAXSIZE,stdin);
		word[strlen(word)-1]='\0';
	}
}
