#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "mytype.h"

/* 
    Convert Text Index File into Binary Index File!!

    programmed by Heo, Junhyeok   jhheo@vr.kaist.ac.kr
    1993.3.28
*/

UINT get_word_num(FILE *IF)
{
     LONG pre_pos,pos;
     UINT word_num;
     char temp[255];
     int  temp_idx=254;
     int  ch;

	 temp_idx = 254; 
	 temp[temp_idx--] = '\0';

     pre_pos=ftell(IF);

     fseek(IF,-1L,SEEK_END);
     pos=ftell(IF);
     for(;;) {
     	if(pos<0L) return 0;
     	ch = fgetc(IF);
     	if(isdigit((char)ch))  {
     		temp[temp_idx--] = (char)ch;
     		break;
     	}
     	pos--; fseek(IF,pos,SEEK_SET);
     }
     pos--; fseek(IF,pos,SEEK_SET);
     for(;;) {
     	if(pos<0L) break;
     	ch = fgetc(IF);
     	if(!isdigit((char)ch)) break;
     	temp[temp_idx--] = (char)ch;
        pos--; fseek(IF,pos,SEEK_SET);
	 }

	fseek(IF,pre_pos,SEEK_SET);
	 word_num =  atoi(&(temp[temp_idx+1]));
     return word_num;
}

#define CHAR_NUM 20
typedef struct {
     char word[CHAR_NUM];
     LONG  pos;
    } INDEX;

INDEX temp;

int main(int argc,char *argv[])
{
    FILE *IF,*BF;
    UINT word_num=0;

    UINT i;

    if(argc < 2)
    { fprintf(stderr,"Usage:idx2bin indexfile\n");
      exit(-1);
     }

    IF = fopen(argv[1],"r");
    if(IF == NULL)
      {
	fprintf(stderr,"No such %s file\n",argv[1]);
        exit(-1);
      }
    word_num = get_word_num(IF);
    /* word_num = 31449;*/
    printf("total words = %d\n",word_num);
    strcpy( strchr(argv[1],'.'), ".bdx");
    BF = fopen(argv[1],"w");
    for(i=0;i<word_num;i++)
    {
	 fscanf(IF,"%s %d",temp.word,&temp.pos);
         temp.word[CHAR_NUM-1] = '\0';
	 fwrite(&temp,sizeof(INDEX),1,BF);
	}
    fwrite(&word_num,sizeof(UINT),1,BF);
    fclose(IF);
    fclose(BF);

return 0;
}
