#include	<stdio.h>
#include	<stdlib.h>
#include	<malloc.h>
#include	<unistd.h>
#include	"dic.hh"

/*
    Revised by Heo, Junhyeok jhheo@vr.kaist.ac.kr
    For Fast Initializing and Not using up memory
    1993.3.28
    I don't know who creates the original source for eedic
      and eedic default dictionary .
*/

cDic::cDic (int dic_size, char *indexF, char *dicF)
{
	register int i;

	num = dic_size;

	IF = fopen(indexF,"r");
        if(IF == NULL)
              { fprintf(stderr,"Can't Open %s File!\n",indexF);
                exit(255);
                }

	DF = fopen(dicF,"r");
        if(DF == NULL)
              { fprintf(stderr,"Can't Open %s File!\n",dicF);
                exit(255);
                }

	for(i=0;i<30;i++) {
		swords_head[i] = NULL;
		swords_tail[i] = NULL;
	}
}

cDic::~cDic()
 {
    	fclose(IF);
    	fclose(DF);

     }

char * cDic::Word(unsigned i)
{
     fseek(IF,sizeof(INDEX) * (long)i,SEEK_SET);
     fread(&index,sizeof(INDEX),1,IF);
     return(index.word);
     }

int  cDic::Search (char *word)
{
	return(cDic::BSearch(word,0,num-1));
}

int   cDic::BSearch (char *word, int l, int  r)
{
	int	m = (l+r)/2;

	if (l > r)
		return(-1);
	else if (l == r)
	{
		if (strcmp(word,Word(m)) == 0)
			return(m);
		else
			return(-1);
	}
	else
	{
		if (strcmp(word,Word(m)) < 0)
			return(cDic::BSearch(word,l,m-1));
		else if (strcmp(word,Word(m)) > 0)
			return(cDic::BSearch(word,m+1,r));
		else
			return(m);
	}
}

int  cDic::BSearch1 (char *word, int  l, int  r)
{
	int	m = (l+r)/2;

	if (l > r)
		return(-1);
	else if (l == r)
	{
		if (strncmp(word,Word(m),strlen(word)) == 0)
			return(m);
		else
			return(-1);
	}
	else
	{
		if (strncmp(word,Word(m),strlen(word)) < 0)
			return(cDic::BSearch(word,l,m-1));
		else if (strncmp(word,Word(m),strlen(word)) > 0)
			return(cDic::BSearch(word,m+1,r));
		else
			return(m);
	}
}

void cDic::PrintItem(int  i)
{
	LONG pos;
	int ch;

	if (DF == NULL) return;
	if (i<0 && i>=num)
	     return;

	fseek(IF,sizeof(INDEX) * i,SEEK_SET);
	fread(&index,sizeof(INDEX),1,IF);
	pos = index.pos;

	for(;;)
	   { fseek(DF,pos,0);
	     ch = fgetc(DF);
	     if((char)ch=='@' || ch==EOF)
		break;
	     pos --; }
	
	printf("\n");
        ch = fgetc(DF);
	while ((char)ch != '@' )
	{
	    if(ch == EOF) break;
	    printf("%c",ch);
	    ch = fgetc(DF);
	}
	printf("---------------------------------------------\n");
}

void cDic::PrintIndex(int i)
{
	fseek(IF,sizeof(INDEX) * i,SEEK_SET);
	fread(&index,sizeof(INDEX),1,IF);
	printf("[%s]\t%d\n",index.word,index.pos);
}

extern editdistance(char *,char *);

void cDic::SimilarWords(char *w,char c)
{
	register unsigned i,dist_bound,temp;
	char *sw,notdone;

 	dist_bound = strlen(w) >> 1;
 	notdone=2;
	for(i=1; i<num; i++) {
	 	sw = Word(i);
	 	if (c)
	 	  { if (c!=*sw) 
	 	        { if(notdone==1) break; 
	 	          else continue; }
	 	    else if(notdone==2) 
	 	        notdone--;
	 	    }
		temp = editdistance(w,sw);
		if(temp <= dist_bound) {
			if(swords_tail[temp])
			  swords_tail[temp] = (*swords_tail[temp]).append(sw);
			else
			{ swords_head[temp]=new wList(sw);
			  swords_tail[temp]=swords_head[temp];
			  }
		  }
	}

	for(i=dist_bound; i>0; i--) 
	{ if(swords_head[i]) 
	  	(*swords_head[i]).printwords();
           
        }

	for(i=1;i<=dist_bound;i++) 
	 { if(swords_head[i])
	 	{ delete swords_head[i];
	 	  swords_head[i] = NULL;
	 	  swords_tail[i] = NULL;
	 	  }
          }
 }
