; Copyright (C) Andrew H. Nelson, 1989. May not be copied, 
; reproduced, or used in any manner without the express
; written consent of the author.

(defun say (x) (terpri) (princ x) (terpri))

(say "DEMO THE HELP FEATURE -- (HELP 'HELP)")

(HELP 'HELP)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

; Define features and dimensions that the augmented network transition 
; parser needs.
; Syntactic features enforce agreement among subjects and verbs.  

(say "PARSE SENTENCES USING THE BUILT IN ATN PARSER !!!")
(say "The definitive reference for this atn parser is ")
(say "chapter 4, Introduction to Artificial Intelligence,")
(say "by Eugene Charniak and Drew McDermott, Addison Wesley publ.")
(terpri)  
; 		Dimension	default		other values

(deffeature	n-number	(3s)		1s 2s 1p 2p 3p)
(deffeature	v-number	(1s 2s 1p 2p 3p)	3s)
(deffeature	tense		(tenseless)	present past progressive pastp)
(deffeature	mood		(statement)	question command)
(deffeature	dative		(no)		yes)
(deffeature	sense		(nil)		anything)
(deffeature	referent	(nil)		anything)

; Morphology -  the dictionary will specify for each word of the language
; its part of speech, any nondefault values for its features, and
; something about its meaning.  A dictionary entry has the form:
; (word root-form part-of-speech *feature-assignments*)
 

(defword story nil noun)
(defword book nil noun)
(defword ball nil noun)
(defword you nil pronoun)
(defword will nil aux)
(defword give nil verb)

;; explicitly assign a feature to a dictionary word 
(defword give nil verb)
(:= tense of give 'tenseless)
(:= dative of give 'yes)

;; explicitly assign a feature to a dictionary word 
(defword gave nil verb)
(:= dative of gave 'yes)

;; explicitly assign a feature to a dictionary word 
(defword threw nil verb)
(:= dative of threw 'yes)

;; explicitly assign a feature to a dictionary word 
(defword told nil verb)
(:= dative of told 'yes)

(defword the  nil det)
(defword a    nil det)
(defword to   nil prep)
(defword jack nil proper-noun)
(defword Mary nil proper-noun)

;;; define nets using defnet 
;;; (defnet name <net>)

(defnet s-para 				; A paragraph is one or
  (seq  (parse s-maj)				; more sentences
	(optional* (parse s-maj))))

(defnet s-maj					; A sentence is
  (seq 	(either					; either
	 (:= mood of $s-maj 'statement)		; a statement

	 (seq (peek verb)			; or a command
	      (== (the tense of $last)
		  'tenseless)
	      (insert (the word you))		; you insertion rule
	      (:=  mood of $s-maj 'command))

	 (seq (:=  mood of $s-maj		; or a question
		  'question)
	      (optional (seq (category wh)
			     (save-last)))	; wh-movement rule

	      (optional (seq (category aux)
			     (parse np)
			     (drop (the aux of $s-maj :name)) ;Aux-inversion rule
			     (drop (the np of $s-maj :name))))))
	(parse s)				; s-maj -> s ...
	(optional (parse fp))))



(defnet s (seq  (parse np)
		(parse vp)
		))

(defnet fp (optional (either (category exclamation) (category question))))

(defnet np  
 (either
	(seq 	(optional  (category det)) 
		(optional* (category adj))
		(either    (category noun)
			   (category proper-noun)
			   (category pronoun)))
	(either (category proper-noun)
		(category pronoun)
		(seq	(optional (category det))
			(optional* (category adj))
			(category noun)
			(optional* (parse pp)))
		(use))))

(defnet vp
 (seq
  (optional (category aux))
  (category verb)
  (optional
	(seq	(== (the dative of $last) 'yes)
		(parse np)
		(parse np)
		(drop (the-first np of $vp :name))
		(insert (the word to))
		(drop (the np of $vp :name))
	))
  (parse np)
  (optional* (parse pp))))

(defnet pp
  (seq (category prep) (parse np)))

(setq s1 '(jack gave mary the book))
(setq s2 '(will jack give mary the book))
(setq s3 '(give mary the book))

(say "Some sample sentences to play with:")
(say "(1)  s1:")  (print s1)
(say "(2)  s2:")  (print s2)
(say "(3)  s3:")  (print s3)
(say "The demo will parse s2 using \"(atn s2 '(parse s-maj))\" ")
(atn s2 '(parse s-maj))
(print s2)
(prttree *ParseTree*)
(print (analyze 's-maj))

(BREAK "TRY s1 or s3, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "DEFINE RULES AND FACTS AND FORWARD-CHAIN! ")
; Rules have the form:
; (defrule  'rulename'  f1 f2 ... fn  ->  c1 c2 ... cn)
; where f1 ... fn are facts that must be true if
;       c1 ... c2 facts are to be inferred
;
; f1 ... fn / c1 ... cn facts have identical forms.

; f/c facts have the form:
; (term1 term2 ... termn)

; where term1 ... termn are either:
;    atoms -- That are at least one alpha followed by any other
;             printable character except ' or ; or : or . or , .
;    !atom -- This means "not this atom".
;    variables --  As in $x, $X, $this*&^%123!ZX?s-long, $varname.
;                  Variables must start with a '$'.
;    a wildcard -- Place holder for 1 atom is '?'.
;    a wildcard -- Place holder for 1 or more atoms is '*'.
;    a computable function -- This has the form:
;                             (eval (lisp expression))

; This is a rule that will always fire since it has
; no conditions

 (defrule always      -> (it always fires because it has no conditions))


; This is an example of a simple rule named "a" and a fact that will fire it.
; If the wind is blowing, the flag waves.

  (defrule a (wind blowing) -> (flag waves))

  (assert (wind blowing))

; this rule always fires - another way to assert a fact

  (defrule b   -> (flag color red))

; Next is an example of a simple rule named "or" that will fire if a fact does
; not (I say again), not contain a certain atom/term.
; Also, you can see we can format the rule for readability.
; And this is how we program for OR.  We define the same rule and
; conclusion twice but with different firing conditions.

  (defrule or_rule
     (flag color !red)
  ->
     (bull happy))

  (defrule or_rule
     (bull !sees flag)
  ->
     (bull happy))


;; make a fact known to be true

   (assert (bull sees flag))

;; So, if the flag is red and waves and the bull sees it, then
;; the bull is angry.
 
  (defrule c
    (flag color red)
    (flag waves)
    (bull sees flag)
  ->
    (bull angry))

;; if the bull is angry, then the bull will run

  (defrule d
    (bull angry)	
  ->
    (bull running))

; Now to use a variable.
; The variable is only known in the context of the rule.
; It is not known outside of the rule.
; Also a variable will only be bound once and will
; take the value of the term of the current fact
; it is matching.

; Eval is used only in the actions part of the rule.  It
; passes the next statement to lisp for evaluation, after it
; binds the variables.

  (defrule e
    (bull running)
    (bull weighs $x pounds)
    (bull runs $y fps)
  ->
    (bull mass (eval (* $x  $y))))

 (assert (bull weighs 5000 pounds) (bull runs 3 fps))

  (defrule f
   (bull mass $x)
   ->
   (eval (if (> $x 10000)
         '(fence will smash)
         '(fence will not smash))))

  (defrule g
; Now lets use a wild card.
   (* bull * angry)
   (fence will smash)
 ->
   (farmer in trouble))

; We can list all the facts (or short term memory)
; by evaluating:

(say "PRINT SHORT TERM MEMORY using \"(pstm)\"")
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

; If you want to see all our rules so far, evaluate:
(say "PRINT LONG TERM MEMORY using \"(pltm)\"")
(pltm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

; Now let's go over the functions again.

(say "START THE INFERENCE ENGINE AND GENERATE ALL FACTS! ")
(say "Go get a cup of coffee, cause this is slow in xlisp")

(forward-chain)

(say "SHORT TERM MEMORY AGAIN") 
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "HOW DID YOU ARRIVE AT THE THIRD FACT (HOW 3)")
(how 3)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "WHY DO YOU NEED THE THIRD FACT (WHY 3)") 
(why 3)

(say "RETRACT THE THIRD FACT USING (DENY 3)")
(deny 3)
(PSTM)
(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "DENY THIS PARTICULAR FACT -- (DENY '(FARMER RUNNING))")
(deny '(Farmer running))
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "DENY (non-monotonically) PARTICULAR FACT -- (nmDENY '(wind blowing))")
(nmdeny '(wind blowing))

(say "DENIES ALL FACTS THAT ALSO DEPEND UPON THE DENIED FACT")
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "this is text you can write to explain a rule, using putexpl")
(putexpl a "this is text you can write to explain a rule")

(say "PRINT RULES A B USING PRULES")
(prules a b)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "DELETE RULES A B C D USING DELETERULES")
(deleterules a b c d)
(pltm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(erase-world)

(say "SHOW A schema / frame / slot representation ABOUT PLANES!")

 (defschema plane             ;schema name
            (schema)          ;superclass schema belongs to
    wing tail engine pilot)   ;slot (or frame) name

 ;;; now give it methods to answer messages

  (defmessage (:before-before-fly plane) (x)
    (for i = 1 to x (print "before demon for :before-fly")))

  (defmessage (:before-fly plane) (x)
    (for i = 1 to x (print "before demon for :fly")))

  (defmessage (:fly plane) (x) 
    (for i = 1 to x (print "vvvvvrrrroooooooommmmmmm")))

  (defmessage (:after-fly plane) (x)
    (for i = 1 to x (print "after demon for :fly")))

  (defmessage (:after-after-fly plane) (x)
    (for i = 1 to x (print "after demon for :after-fly")))

  ;;; demons are processes that are invoked either after or
  ;;; before a certain method/message is sent to an object.

  ;;; A demon message must have the same amount of args as
  ;;; the message that invokes it.  
  ;;; syntax:  (defdemon demon-name :keyword invoking-message)
  ;;; and :keyword is either :before (before invoking message)
  ;;;                 or     :after  (after  invoking message)

  (defdemon :before-fly :before :fly)
  (defdemon :before-before-fly :before :before-fly)

  (defdemon :after-fly  :after  :fly)
  (defdemon :after-after-fly :after :after-fly)

 (defmessage (:shoot plane) (x)
   (for i = 1 to x (print "rat-ta-tat-tat")))

  (defmessage (:shoot-and-fly plane) (x)
    (progn (send-message self :shoot x)
           (send-message self :fly x)))

 ;;; now define the jet class

 (defschema jet (plane) 
                (pilot 2))

 ;;; now define the fa/18 class

 (defschema fa/18 (jet)                                     ;superclass
                  (mission (fighter attack))                ;multi  value slot
                  (pilot 1)                                 ;single value slot
                  (service (:phrase United States Marines)));single value slot

;;; now instantiate a fa/18  i.e. bring it into existence

  (setq BlueMax (make-object 'fa/18                    ;schema name
			     '(serial_number 123456))) ;new slot and value

  (setq RedMax  (make-object 'fa/18                    ;schema name
			     '(serial_number 654321))) ;new slot and value

;;; RedMax is BlueMax's Wingman
;;; BlueMax is RedMax's flightleader

  (defrelation BlueMax 'Wingman RedMax)
  (defrelation RedMax  'FlightLeader BlueMax)

(say "START THE ACTION !!!")
 (send-message RedMax :shoot-and-fly 1)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

;;; now create the facts
;;; *objects* holds list of all objects "created"

(say "NOW THE SCHEMA ARE BUILT -- ERASE THE WORLD TO DEMO SLOTS -> FACTS!") 

(say "THESE ARE THE FACTS ABOUT BLUEMAX CREATED USING FACTS<-SLOTS!")

(facts<-slots Bluemax)
(PSTM)

;;; now look inside a schema
 (terpri)
 (princ "The number of pilots in the BlueMax is ") 
 (princ (get-slot-value BlueMax 'pilot))  ;this value should be *no_value*
 (terpri)
 (princ "The number of pilots in an fa/18 is ") 
 (princ (get-slot-value 'fa/18 'pilot))  ;this value should be one
 (terpri)
;;; fa/18's are a subclass of jet
 (princ "However, the number of pilots in a jet is usually ") 
 (princ (get-slot-value 'jet 'pilot))    ;this value is masked above
 (terpri)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "SHOW METHODS AND SLOTS OF THE OBJECT BLUEMAX INCLUDING THOSE")
(SAY "INHERITED")

(send-message Bluemax :show-slots)

(say "NOW DEMO ALTERNATE WORLDS!")
  (erase-world)
  (load "animal")

;;;; trim it down a little
  (deleterules animal_3 animal_5 animal_6 animal_7 )

  (deleterules animal_11 animal_31 animal_51 animal_61 animal_71)

(say "THE KNOWN WORLD:")
  (pstm)
  (pltm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "CREATE A VIEWPOINT CALLED BIRD-WORLD!")

 (defviewpoint 'bird-world)


 (defhypothesis bird_1 'bird-world
   ($animal has feathers)
  ->
   ($animal is bird))


 (defhypothesis bird_2 'bird-world
  ($animal is carnivore)
  ($animal has beak)
  -> 
  ($animal is bird))


 (defhypothesis bird_3 'bird-world
   ($animal warm-blooded)
    ($animal has wings)
    ($animal has beak)
   ->
   ($animal is bird))


  (hypothesize 'bird-world (stu has beak) (stu is carnivore)
   (stu warm-blooded))


  (hypothesize 'bird-world (stu has feathers))
  (pstm)
  (say "BRAINSTORM IN THIS ALTERNATE WORLD!")
  (say "use \"(pstm)\" and \"(pltm)\" after the demo does")
  (say "\"(whatif 'bird-world)\"")
  (whatif 'bird-world)

  (say "NOW DEMO MULTIPLE KNOWLEDGE SYSTEM (MKS) PARIDIGM")
  (say "BY CONSULTING THE \"EXPERT\" VIEWPOINT \"BIRD-WORLD\" TO")
  (say "DETERMINE ANIMAL CLASSIFICATION OF STU.")
  (say "using \"(ask-nosharing 'bird-world '(stu is $x)\"" )
  (say "and   \"(ask-sharing   'bird-world '($x  is $y)\"")
  (print (ask-nosharing 'bird-world '(stu is $x)))
  (print (ask-sharing   'bird-world '($x  is $y)))
(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "USE EVAL AND AGENDA BASED FORWARD CHAINING:")

(erase-world)

(setq x 0)

 (assert (demo))

 (say "THE WORLD:")

 (pstm)

 (defrule the_only_one 
  (demo)
    ->
  (eval	(progn
		(terpri)
		(setq x (1+ x))
        	(princ "We are now in the loop for the   ")
        	(princ x) (princ " time!")  
          	(if (equal x 5) (deny '(demo)))
          	(fc-with-agenda))) )

 (pltm)

;; Do agenda based forward chaining --- faster than forward-chain, but
;; since it makes a guess at what rules will match facts and puts those
;; rules oN the agenda, it can err.  Use forward-chain when you have to
;; be sure to get every valid inference.

 (fc-with-agenda)

; Copyright (C) Andrew H. Nelson 1989.  May not be copied,
; reproduced, or used in any manner without the expressed
; written permission of the author.

(say "TEST THE LEARNING CAPABILITY OF IMPLICATOR")

(print "The environment is being cleared of all facts and rules of the")
(print "previous demonstration.  A fresh set of facts are being loaded,")
(print "pruned, and set up for a simple demonstration of SITUATION ")
(print "CONDITIONING.  SITUATION CONDITIONING is the technique of allowing")
(print "Implicator to infer general rules from a set of facts and a set")
(print "of conclusions.  This is similar to unsupervised learning in")
(print "neural nets.  The function used is (learn DomainSet ConclusionSet).")
(print "Learn incorporates the conditioning permanently. Learnfrom(D C)")
(print "does not.")
(terpri)
(print "The rules that are learned can then be applied to a larger problem")
(print "domain.")
  
(erase-world)

(load "animal")

(flush '(* is female))
(flush '(* gives milk))

(setq DomainSet *assertions*)
(pstm)
(print "initial condition set")

(setq ConclusionSet '((toto is a cheetah)))
(setq *assertions* ConclusionSet answer ConclusionSet)
(pstm)
(print "desired conclusion set")

(erase-world)

(print "LEARN discovers the rules in the general case that  ")
(print "map this particular set of initial conditions across")
(print "the conclusion set.  ")
(learn DomainSet ConclusionSet)
(print "The Rule that was 'learned'.  CONDITIONING.")
(pltm)

(say "Implicator generates rules of depth 1 in a 'search tree'.")
(say "It will generate a rule for each fact in the conclusion set.")
(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(print "now test it")

(assert	(toto has claws)
	(toto has hair)
	(toto has spots)
	(toto has pointed teeth)
	(toto has forward eyes))

(assert	(gigi has claws)
	(gigi has hair)
	(gigi has spots)
	(gigi has pointed teeth)
	(gigi has forward eyes))
(say "the facts")
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")
(say  "the rule")
(pltm)
(say  "Go get some more coffee, we're forward chaining again!")
(forward-chain)

(say "Now do some Abduction, (If p -> q, and q, then show all p' in p)")
(say "we will do this two ways:")
(say "   1st -  (bchain '(rex is a cheetah))")
(bchain '(rex is a cheetah))

(say "   2nd -  now we want to look for just certain facts so")
(say "         (pprint (abduce '(mike is a cheetah) '(mike has *)))")
(pprint (abduce '(mike is a cheetah) '(mike has *)))

(say "   Show if facts are present   (progn (allpresent '(toto has *)) ")
(say "                                      (print them)")

(progn (allpresent '(toto has *)) (pprint them))



(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "Now run through some more pop-11 like stuff")
(say "flush all stuff having to do with gigi (flush '(* gigi *))")
(say "Coffee time again.")
(flush '(* gigi *))
(pstm)

(say "Now do all facts pertain to toto?  (print (forall '(* toto *)))")
(if (print (forall '(* toto *)))
    (print "yes they do!")
    (print "no they don't!"))
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(SAY "NOW LET'S DEMO BACKWARD CHAINING ON THIS RULE WITH SAME FACT SET")
(SAY "1.  Let's deny toto is a cheetah so Implicator doesn't explicitly")
(say "    know it as a fact.  (deny '(toto is a cheetah))")

(deny '(toto is a cheetah))

(pstm)

(say "2.  Now we FIND it out (print(find '($x is a cheetah)))")
(print (find '($x is a cheetah)))

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "This is what the back chaining database looks like (prologlist)")
(prologlist)
(say "It is developed automatically, so you never need to see it")
(say "unless you want to do some debuggin of your programs.")
(say "Implicator is capable of manipulating 1st and 2nd order")
(say "predicate calculus.")

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "Now test the rule generalization capability of Implicator")
(say "We will now erase the world and define two rules: ")

(erase-world)

(defrule first-rule  ($x has hair)
                     ($x has spots)
                     ($x is a carnivore)
         ->
                     ($x is a mammal)
                     ($x is a cheetah))

(defrule second-rule ($x has hair)
                     ($x has horns)
                     ($x is a herbivore)
         ->
                     ($x is a deer)
                     ($x is a mammal))

(pltm)

(defrule third-rule  ($x is a herbivore)
                     ($x has hoofs)
                     ($x has horns)
         ->
                     ($x is a mammal)
                     ($x is a cattle))



(defrule fourth-rule  ($x is a herbivore)
                      ($x has paws)
                      ($x has incisor teeth)
         ->
                      ($x is a mammal)
                      ($x is a rodent))


(say "Now using (abstract-rule first-rule second-rule), we will observe that")
(say "Implicator can infer new rules by comparing rules: ")

(abstract-rule first-rule second-rule)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "Demo the use of (generalize),  it will infer new rules by")
(say "comparing all known rules.  ")

(say "First load up the animal rules again: ")
(load "animal")
(pltm)

(say "Now (generalize).  The shell will infer all rules it can")
(say "from the available rules.  Now remember, this is a ")
(say "closed world.  All that Implicator 'knows' is these rules.")
(say "Go get some more coffee, this is thorough and time consuming!")

(generalize)

(say "Now, it is possible to invoke (generalize) again, and again, ")
(say "until there are no more rules that can be inferred.  We can do")
(say "this with the function (generalize-all).  Generalize makes one")
(say "pass over the rules, generalize-all generalizes until no more")
(say "rules can be found.")
(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "Demo the use of $$var in a rule")

(erase-world)

(defrule a (a $$x) ->   (the rest variable contains:  $$x)
                        (graft  - $$x - in the middle)
                        ($$x - goes in the front too))

(assert (a lots of stuff like 1 2 3 4 and lists (a b c)(d e) )
        (a one_thing) (a 12345678))

(say "THE RULE USING THE LIST VARIABLE $$X")
(pltm)
(say "THE FACTS TO USE AGAINST THE LIST VARIABLE $$X")
(pstm)

(BREAK "TRY IT, AND/OR ENTER \"(CONTINUE)\" TO CONTINUE DEMO ")

(say "FORWARD CHAIN")
(forward-chain)
(say "THE RESULTS")
(pstm)

(if (y-or-n-p "End of demo, Should I (exit) ?") (exit))

