/*     binpatch: creates and applies binary patches 		             */
/*     Copyright (C) 2001 Jaap Korthals Altes <jkaltes@cyberbrain.com>       */
/*                                                                           */
/*     This program is free software; you can redistribute it and/or modify  */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     This program is distributed in the hope that it will be useful,       */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with this program; if not, write to the Free Software           */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/* Tue Jan 16 20:13:40 2001                                                  */

/* #define COUNTREPEAT*/ /*Normal smaller, Gzipped larger, no patch jet*/ 
/* #define NOCOMPRE */
/* #define NONOPT */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define __USE_GNUC__
#endif
#define FASTNEXTALL
#define FIRSTDATA
/* #define LARGEOFFS */
#define BOTHMEM 1
/* #define TRYBOTH */
/* #define TESTTABLE */
#define BESTMATCH
/* #define SAMELABELS */
#define POSARRAY
/* #define UPDATE */
#define CRC32

#ifdef	TRYBOTH
int dotryboth=0;
#endif

#ifdef TRYBOTH
/* #define INMEM */
/* #undef BOTHMEM */
#endif

#ifdef UPDATE
#undef CRC32
#endif
#include <stdio.h>
#include <stdlib.h>
#define __USE_GNU
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <limits.h>
#if defined(unix) && !defined(GO32)
 #define LSTAT lstat
 #define HAS_MMAP
	#ifdef HAS_MMAP
	#include <unistd.h>
	#include <sys/mman.h>
	 #ifndef MAP_FAILED
	 #define MAP_FAILED -1
	 #endif
	#endif
#else
 #define LSTAT stat
#endif
#define BINPATCHVERSION "0.0.1"

#ifdef  __BORLANDC__
  #include <mem.h>
#endif
#ifdef LARGEOFFS
int datasize=sizeof(Offmatch);
#else
/* datasize=sizeof(unsigned short)*2+sizeof(Offtype); */
int datasize=9;
#endif
#ifndef LARGEOFFS
const unsigned int maxshort=USHRT_MAX;
#endif
#ifdef BOTHMEM
#undef INMEM
#endif
#define POINTER void *
/* #define POINTER unsigned long */
#define LONG long
#define Offtype LONG
#ifdef __USE_GNUC__
typedef long long Longlong;
#else
typedef long double Longlong;
#endif
/*#define DEBUG printf*/
#define DEBUG
#define NOVERBOSE 0xFFFFFFFF
unsigned long verbose=NOVERBOSE;
#define errormessage(mes) {if(errno) perror(mes); else fprintf(stderr,mes);exit(5);}
/* one-two */
/*  */






#ifdef IFLOOKBACK
int lookback=1;
#endif
#define TRYNALIGN
#ifdef TRYNALIGN

int noalign=0;
#endif
#ifdef BESTMATCH
int bestmatch=0;
#endif
#ifdef BOTHMEM
int ondisk=0;
#endif

#ifdef CRCSHORT
#define hashfunctie(X,gegs)  block_crc((unsigned char*)X, gegs->take) 
#include "crc16.c"
#else
#define hashfunctie(X,gegs)  crc32((unsigned char*)X, gegs->take) 
#ifdef CRC32
/* #ifndef BOTHMEM */
#include "crc32.c"
#else
#ifdef __i386__NotNeeded
#define rol(x)  asm("roll $1,%1":"=r"(x):"r"(x))
#define rolnr(get,x,nr)  get=x;asm("roll %%cl,%2":"=r"(get):"c"(nr),"r"(get))
#define ror(x)  asm("rorl $1,%1":"=m"(x):"m"(x))
#else
#define rol(x) x=(((x)<<1)|((x)>>31))
#define ror(x) x=(((x)>>1)|((x)<<31))
#define rolnr(get,x,nr) get=(((x)<<(nr))|((x)>>(32-(nr))))
#endif

#define ZEROSTART
#ifdef ZEROSTART
static const unsigned long startvalcrc=0;
#else
static const unsigned long startvalcrc=12345678;
#endif
#define  crc32(s, len)  crc32ex(startvalcrc,s, len)
#define shift 7
unsigned long crc32ex(unsigned long crc32val,const unsigned char *s, unsigned int len)
{
  unsigned int i;
  for (i = 0;  i < len;  i ++)
    {
      rolnr(crc32val,crc32val,shift);
/*       rol(crc32val); */
      crc32val = s[i] ^ crc32val;
    }
  return crc32val;
}
unsigned long crc32sub(unsigned long crc32val,const unsigned char *s,unsigned int len,unsigned int didlen)
{
  unsigned int i;
char nr;
#ifdef ZEROSTART
unsigned long get;
didlen--;
  for (i = 0;  i < len;  i ++)
    {
/* 	nr= ((didlen-i))%32; */
	nr= ((didlen-i)*shift)%32;
	rolnr(get,s[i],nr);
      crc32val = get ^ crc32val;
    }
  return crc32val;
#else
unsigned long get,roledstart=startvalcrc;
didlen--;
/* rol(roledstart); */
rolnr(roledstart,roledstart,shift);
/* nr= didlen%32; */
nr= (didlen*shift)%32;
rolnr(get,s[0]^roledstart,nr);
crc32val = get ^ crc32val;
  for (i = 1;  i < len;  i ++)
    {
	nr=((didlen-i)*shift)%32;
	rolnr(get,s[i],nr);
      crc32val = get ^ crc32val;
    }
nr= ((didlen-len)*shift)%32;
rolnr(roledstart,roledstart,nr);
  return crc32val^roledstart;
#endif
}
#if defined(__USE_GNUC__) && !defined(__STRICT_ANSI__)
inline
#endif
unsigned long crcshift(unsigned long crc32val,const unsigned char sub,
		const unsigned char add, unsigned int didlen) {
	crc32val=crc32sub(crc32val,&sub,1,didlen);
	return crc32ex(crc32val,&add,1);
	}
/*
unsigned long crc32shift(unsigned long crc32val,const unsigned char *sub,unsigned int sublen,const unsigned char *add, unsigned int addlen)
{
  unsigned int i;

 crc32val

  for (i = 0;  i < len;  i ++)
    {
      rol(crc32val);
      crc32val = s[i] ^ crc32val;
    }
  return crc32val;
}
*/
#endif
#endif

#define compfunctie(X,Y,gegs) memcmp(X,Y,gegs->take)
typedef struct offmatch {
	Offtype tooff;
	Offtype fromoff;
	Offtype size;
	} Offmatch;
struct list {
/* 	unsigned long plaats; */
	POINTER plaats;
	struct list *next;
	};
typedef struct deel {
/*   char *label; */
	  POINTER plaats;
	  struct deel *next;
	  } Deel;
typedef Deel * Hashtable;
typedef struct hashgegs {
#ifndef INMMEM
	FILE *fromfp;
#else
	char *fromfp;
#endif
	Offtype fromsize,tablesize,take;
	Hashtable *tab;
	} Hashgegs;


/*
Needed only for freehash 
#define ishashaddr(ptr) (0x80000000&((unsigned long)(ptr)))
#define gethashaddr(ptr) (Deel *)((ishashaddr(ptr))?(0x7FFFFFFF&((unsigned long)(ptr))):0)
#define setishashaddr(ptr) (Deel *)(0x80000000|((unsigned long)(ptr)))
*/


/*
#define ishashaddr(ptr) ptr
#define gethashaddr(ptr) ptr
#define setishashaddr(ptr) ptr
*/
#ifdef HASHMEM
struct hashmem {
	size_t len;
/* 	struct hashmem *next; */
	size_t *next;
	} ;

size_t memhead=0x10000000;
unsigned long *htable;
#define hmem(iter) ((struct hashmem *)(htable+(iter)))
unsigned long hmemused=0,mallocated=0;
void *halloc(size_t len) {

	struct hashmem *mems;
	int *iter;
	for(iter=&memhead;!((*iter)&0x10000000);iter=&(mems->next))	{
/* Becomes slow because it has to to through all small pieces for 
a larger one */ 
		mems=hmem(*iter);
		if(mems->len>=len) {
		 	char *tmp;
			mems->len-=len;
			tmp=(((char *)(mems))+mems->len);
			if(mems->len<sizeof(struct hashmem)) {
				*iter=mems->next;
				}
			hmemused+=len;
			return tmp;
			}
		}

	mallocated+=len;
	return malloc(len);
	}
#else
unsigned long hmemused=0;
char *hposmem;
#define halloc(len) (hmemused+=len,hposmem+(hmemused-len))
#define ADDRTYPE char *
unsigned long ishashaddr(ADDRTYPE ptr)  {
	return (0x80000000&((unsigned long)(ptr)));
	}
#define gethashaddr(ptr) ((void*)((ishashaddr((ADDRTYPE)ptr))?(hposmem+(0x7FFFFFFF&(unsigned long)ptr)):NULL))
#define setishashaddr(ptr) (unsigned long)(0x80000000|((unsigned long)(((char *)(ptr))-hposmem)))
#endif

#define NOHASHEL NULL
#ifndef INMEM
Hashgegs *gethash(Offtype len,FILE *tofp,Offtype tosize,FILE *fromfp,Offtype fromsize, Offtype take) {
#else
Hashgegs *gethash(Offtype len,char *tofp,Offtype tosize,char *fromfp,Offtype fromsize, Offtype take) {
#endif
	Hashgegs *gegs=(Hashgegs *)malloc(sizeof(Hashgegs));
	gegs->tablesize=len;
	gegs->tab=(Hashtable *) calloc(len,sizeof(Hashtable));
	gegs->fromfp=fromfp;
	gegs->fromsize=fromsize;
	gegs->take=take;
	return gegs;
	}

char *hashelsmem=NULL;
unsigned long hashelslen=0;
void freehash(Hashgegs *hash) {
	Hashtable *table=hash->tab;
#ifdef ONETABLE
	for(i=0;i<hash->tablesize;i++) {
		if(ishashaddr(table[i])) {
#ifdef POSARRAY
	{
		     unsigned long *ar=(unsigned long *)gethashaddr(table[i]);

#ifdef HASHMEM
	char *hashelsend=hashelsmem+hashelslen;
		if((((char *)ar)<(char *)table||(char *)ar>=((char *)(table+hash->tablesize))) &&(((char *)ar)<hashelsmem|| (char *)ar>hashelsend)) 
#endif
			free(ar);

	}

#else
	Deel *iter;
	int i;
			for(iter=gethashaddr(table[i]);iter;) {
				Deel *dee;
		#ifdef SAMELABELS
				struct list *poslist;
				for(poslist=(struct list *)(iter->plaats);poslist;) {
					struct list *tmp=poslist;	
					poslist=poslist->next;
					if(((char *)tmp)<(char *)table||(char *)tmp>=((char *)(table+hash->tablesize)))
						free(tmp);
					}
		#endif
				dee=iter;
				iter=iter->next;
				if(((char *)dee)<(char *)table||((char *)dee)>=((char *)(table+hash->tablesize)))
					free(dee);
				}
	
#endif

			}
		}
#else
	free(hposmem);
	hmemused=0;
#endif
	free(table);free(hash);
	}
unsigned LONG hash(char *str, Hashgegs *gegs) {
	return ((hashfunctie(str,gegs)) % gegs->tablesize);
	}
const char readerror[]= "Read error";
const char writeerror[]= "Write error";
const char fseekerror[]= "Fseek error";

#define tfread(str,len,nr,fp) {if(fread(str,len,nr,fp)!=nr) errormessage(readerror);}
#define tfwrite(str,len,nr,fp) {if(fwrite(str,len,nr,fp)!=nr) errormessage(writeerror);}
#define tfseek(fp,pos,whence) {if(fseek(fp,pos,whence)!=0) errormessage(fseekerror);}
#define readat(fp,pos,str,len) {tfseek(fp,pos,SEEK_SET);tfread(str,len,1,fp);}

#ifndef INMEM
#ifdef BOTHMEM
#define freelabel(x,g) (ondisk?(free(x),1):0)
#else
#define freelabel(x,g) free(x)
#endif
#else
#define freelabel(x,g) 
#endif
#ifdef __USE_GNUC__
inline
#endif
char getcharfile(LONG pos,Hashgegs *gegs) {
#ifndef INMEM
#ifdef BOTHMEM
if(ondisk) {
#endif
	char tmp;
	readat(gegs->fromfp,pos,&tmp,1);
	return tmp;
#ifdef BOTHMEM
	}
	else
#endif
#endif
#if defined(BOTHMEM) || defined(INMEM)

	return *((char *)(gegs->fromfp))+pos;
#endif
	}

#ifdef __USE_GNUC__
inline
#endif
char *getlabel(char *prpos,Hashgegs *gegs) {
	LONG pos=(long) prpos;
#ifndef INMEM
#ifdef BOTHMEM
if(ondisk) {
#endif
	char *tmp=(char *)malloc(gegs->take);
	readat(gegs->fromfp,pos,tmp,gegs->take);
	return tmp;
#ifdef BOTHMEM
	}
	else
#endif
#endif
#if defined(BOTHMEM) || defined(INMEM)

	return ((char *)(gegs->fromfp))+pos;
#endif
	}
#define onevalue(pos) (void*)(0x40000000|(pos))
#define getonevalue(get) ((get&0x40000000)?((get)&0x3FFFFFFF):0)
/* POINTER getathash(unsigned long index,char *label,Hashgegs *gegs) */
POINTER *itemptrathash(unsigned long index,LONG pos,char *label,Hashgegs *gegs)
{
index=index% gegs->tablesize;
{
Hashtable *tab=gegs->tab;
/* unsigned LONG index=hash(label,gegs); */
#ifndef POSARRAY
Deel *begin,*tijd;
#endif

#ifdef SAMELABELS
struct list *tmp,*tmp2;
Deel **item,*tmpdeel;
item = &tab[index];
if(ishashaddr(*item)) {
	tmpdeel=gethashaddr(*item);
	item=&tmpdeel;
	for(;*item;item= &((*item)->next)) {
		char *otherlabel=getlabel((((struct list*)((*item)->plaats))->plaats-1),gegs);
		if(!compfunctie(label,otherlabel,gegs)) {
			freelabel(otherlabel,gegs);
			tmp=(*item)->plaats;
			(*item)->plaats=tmp2=(struct list *)halloc(sizeof(struct list));
			tmp2->next=tmp;
			return 	&(tmp2->plaats);	}
		freelabel(otherlabel,gegs);
		}
	}
#endif
/* freelabel(label,gegs); */
/*  */

#ifdef POSARRAY
{
unsigned long *ar;
if(!ishashaddr((char *)tab[index]))  {
	unsigned long numb=(unsigned long)tab[index];
	if(numb>1) {
		ar=(unsigned long *)halloc((sizeof(Offtype)*numb)+sizeof(unsigned long));
		tab[index]=(Deel *)setishashaddr( ar);
		*ar=0;
		}
	else {
		tab[index]=(Deel*)onevalue(pos+1);
		return (POINTER *)&tab[index];
		}
	}
else
	{
	ar=(unsigned long *)gethashaddr(tab[index]);
	}
(*ar)++;
ar[*ar]=pos+1;
return (POINTER *)(ar+(*ar));
}
#else
#ifdef FIFO
begin = gethashaddr(tab[index]);
if(begin) {
	for(;begin->next;begin= begin->next) 
		;
	tijd=begin->next=(Deel *) halloc(sizeof(Deel));
	tijd->next=NULL;
	}
else
#endif
{
begin=tab[index];
tijd=halloc(sizeof(Deel));
tab[index]=setishashaddr(tijd);
tijd->next=gethashaddr(begin);
}
/* tijd->label=(char *)pos; */
#ifdef SAMELABELS
tmp=tijd->plaats=(struct list *)halloc(sizeof(struct list));
tmp->next=NULL;
return &(tmp->plaats);
#else
return &(tijd->plaats);
#endif
#endif
}
}

POINTER *itemptr(LONG pos,Hashgegs *gegs)
{
POINTER *ptr;
char *label=getlabel((char *)pos,gegs);
unsigned LONG index=hash(label,gegs);
ptr=itemptrathash(index,pos,label,gegs);
freelabel(label,gegs);
return ptr;
}
/*
POINTER getathash(unsigned long index,char *label,Hashgegs *gegs)
{
Hashtable *tab=gegs->tab;
Deel *deel;
index=index% gegs->tablesize;
#ifdef POSARRAY
{
unsigned long *ar,i,nr;
if(ar=gethashaddr(tab[index])) {
	nr=*ar+1;
	for(i=1;i<nr;i++) {
		char *otherlabel=getlabel(ar[i],gegs);
		if(!compfunctie(label,otherlabel,gegs)) {
			freelabel(otherlabel,gegs);
			return (POINTER )ar[i];
			}
		freelabel(otherlabel,gegs);
		}
	}
}
#else
for(deel=gethashaddr(tab[index]);deel!=NOHASHEL;deel=deel->next) {
#ifdef SAMELABELS
	char *otherlabel=getlabel((((struct list*)(deel->plaats))->plaats-1),gegs);
#else
	char *otherlabel=getlabel(deel->plaats-1,gegs);
#endif
	if(!compfunctie(label,otherlabel,gegs)) {
		freelabel(otherlabel,gegs);
#ifdef SAMELABELS
		return ((struct list *)(deel->plaats))->plaats;
#else
		return deel->plaats;
#endif
		}
	freelabel(otherlabel,gegs);
	}
#endif
return NOHASHEL;
}
POINTER getitem(char *label,Hashgegs *gegs)
{
unsigned LONG index=hash(label,gegs);
return getathash(index,label,gegs);
}
*/

#ifndef POSARRAY
#ifdef SAMELABELS
POINTER getlist(unsigned long index,char *label,Hashgegs *gegs)
{
Hashtable *tab=gegs->tab;
Deel *deel;
index=index% gegs->tablesize;
for(deel=gethashaddr(tab[index]);deel!=NOHASHEL;deel=deel->next) {
/* 	char *otherlabel=getlabel(deel->label,gegs); */
	char *otherlabel=getlabel((((struct list*)(deel->plaats))->plaats-1),gegs);
	if(!compfunctie(label,otherlabel,gegs)) {
		freelabel(otherlabel,gegs);
		return deel->plaats;
		}
	freelabel(otherlabel,gegs);
	}
return NOHASHEL;
}
#else
POINTER getlist(unsigned long index,char *label,Hashgegs *gegs)
{
Hashtable *tab=gegs->tab;
Deel *deel;
index=index% gegs->tablesize;
{
struct list *poslist=NULL;
for(deel=gethashaddr(tab[index]);deel!=NOHASHEL;deel=deel->next) {
	char *otherlabel=getlabel(deel->plaats-1,gegs);
	if(!compfunctie(label,otherlabel,gegs)) {
		struct list *tmp=poslist;
		poslist=malloc(sizeof(struct list));
		poslist->next=tmp;
		poslist->plaats=deel->plaats;
		}
	freelabel(otherlabel,gegs);
	}
return poslist;
}
}
#endif
#endif
/*
int rmitemathash(unsigned long index,char *label,POINTER data,Hashgegs *gegs) {
Hashtable *tab=gegs->tab;
#ifdef SAMELABELS
struct list **poslist,*tmp;
#endif
Deel **item,*deel;
index=index% gegs->tablesize;
item = &tab[index];

for(;*item!=NOHASHEL;item= &((*item)->next)) {
	char *otherlabel=getlabel((*item)->label,gegs);
	if(!compfunctie(label,otherlabel,gegs)) {
#ifndef SAMELABELS
		if((*item)->plaats==data) {
			freelabel(otherlabel,gegs);
#else
	
	for(poslist=(struct list **)&((*item)->plaats);
		*poslist;poslist=(struct list **)&((*poslist)->next)) 
		if((*poslist)->plaats==data) {
			freelabel(otherlabel,gegs);
			tmp=*poslist;
			poslist=(struct list **)&((*poslist)->next);
			free(tmp);
			if((*item)->plaats)
				return 1;	

#endif
			deel=*item;
			item=&((*item)->next);
			free(deel);
			return 1;	
			}

		}

	freelabel(otherlabel,gegs);
	}
return 0;
}
int rmitem(char *label,POINTER data,Hashgegs *gegs) {
	unsigned LONG index=hash(label,gegs);
	return rmitemathash(index,label,data,gegs);
	}
*/
#define BLOCKSIZE 1024
#undef min
static long maxnum(long x,long y) {return ((x)>(y))?(x):(y);}
static long minnum(long x,long y) {return ((x)<(y))?(x):(y);}
#define min(x,y) minnum(x,y)
Offtype settablesize=0;

#ifdef TESTTABLE
void testtable( Hashgegs *vol)
	{
	long zeros=0,ones=0;
	unsigned long tot=0,maxget=0,off;
	long double zoek=0.0;
	for(off=0;off<vol->tablesize;off++) {
		Deel *deel;
		int nr=0;
		for(deel=(Deel *)gethashaddr(vol->tab[off]);deel!=NOHASHEL;deel=deel->next) {
			nr++;
			}
		zoek+=nr*(nr+1);

		if(!nr)
			zeros++;
		else {
			if(nr>1) {
				maxget=nr>maxget?nr:maxget;
				printf("%ld: %d\n",off,nr);
				tot+=nr;
				}
			else
				ones++;
			}
		}
	printf("tablelen %ld\n",vol->tablesize);
	printf("Zero %ld\n",zeros);
	printf("One %ld\n",ones);
	printf("maxget %ld\n",maxget);
	printf("zoeklen %Lg\n",	((long double)zoek/(2*tot))) ;
	printf("average %Lg\n",((long double)(tot+ones) )/vol->tablesize	) ;
	printf("average above one %Lg\n",( (long double)tot)/(vol->tablesize-zeros-ones)	) ;
}
#endif
/* #define INCHASH 1 */
void	filltable(Hashgegs *vol,Offtype unit,Offtype fromlen) {
Offtype endblock=fromlen-unit+1,off,fillunit=unit;
/* Offtype endblock=fromlen-unit,off; */
#ifdef TRYNALIGN
if(noalign) {
	fillunit=1;
	}
#endif
{
	long counters=0,items=0,nonone=0,ones=0;
	Hashtable *table=vol->tab;
#ifdef HASHMEM
	long totmem=0,skiptotal=0,skip=0,i;
	htable=table;
#endif
	for(off=0;off<endblock;off+=fillunit) {
		char *label=getlabel((char *)off,vol);
		unsigned LONG index=hash(label,vol)%vol->tablesize,val;
		val= ((unsigned long)table[index]);
		switch(val) {
			case 1: counters++;break;
			case 0: items++;break;
			};
		val++;
		table[index]=(Deel *)val;
		}
	DEBUG("taged used\n");
ones=items-counters;	
nonone=(fromlen/fillunit)-ones;
hposmem=(char *)malloc((items+nonone)*sizeof(unsigned long));
hmemused=0;
#ifdef HASHMEM
	for(i=0;i<vol->tablesize;i++) {
		if(table[i]) {
			if(skip) {
				if((skip*4)>sizeof(struct hashmem)) {
					unsigned long tmp;	
					tmp=memhead;
					memhead=i-skip;
					hmem(memhead)->next=tmp;
					totmem+=(hmem(memhead)->len=(skip*4));
					skiptotal+=skip;
					}

				}
#ifndef POSARRAY
			table[i]=NULL;
#endif
			skip=0;
			}
		else
			skip++;
		}
#ifdef POSARRAY
/*
	hashelslen=vol->tablesize*sizeof(unsigned long);
	hashelsmem=malloc(hashelslen);
	((struct hashmem*)hashelsmem)->next=memhead;
	memhead=hashelsmem;
	memhead->len=hashelslen;
*/
#endif

#endif
}	
	DEBUG("Made memhead\n");
#ifdef TRYNALIGN
if(!noalign) {
#endif
	for(off=0;off<endblock;off+=unit) {
		POINTER *el=itemptr(off,vol);

#ifndef POSARRAY
		*el=(void *)(off+1);
#endif
		}
#ifdef TRYNALIGN
	}
else {
#if defined(INCHASH) && defined(UPDATE)
#ifdef BOTHMEM
	if(ondisk)
#endif
#endif

#ifndef INMEM
		{
		for(off=0;off<endblock;off++) {
			POINTER *el=itemptr(off,vol);

#ifndef POSARRAY
			*el=(void *)(off+1);
		#endif	
			}
		}
#endif
#if defined(INCHASH) && defined(UPDATE)
#if defined(INMEM) || defined(BOTHMEM)
#ifdef BOTHMEM
else
#endif
	 {
		char *label;
		unsigned long index;	
		POINTER *el;
		off=0;
		label=(char *)(vol->fromfp)+off;
		index=crc32(label, unit);
		el=itemptrathash(index,off,label,vol);
		*el=(void *)(off+1);
		for(off=1;off<endblock;off++) {
			label=(char *)(vol->fromfp)+off;
			index=crcshift(index,label[-1],label[unit-1],unit);
			el=itemptrathash(index,off,label,vol);
			*el=(void *)(off+1);
			}

		}
#endif
#endif
	}
#endif
#ifdef HASHMEM
	printf("Hmem used = %ld\n",hmemused);
	printf("in Hash = %ld\n",hmemused-hashelslen);
	printf("Mallocated used = %ld\n",mallocated);
#endif

	}
struct matchpath {
	Offmatch  match;
	struct matchpath *next;
	};
struct possib {
	Offtype lost,end;
	long nr;
	struct matchpath path;
	};
int SKIPMAX=100;
#ifndef INMEM
LONG fbindiff(FILE *tofp,Offtype tolen, FILE *fromfp, Offtype fromlen,Offtype unit,Offmatch **omatchptr,Offtype matches, Offtype maxmatches) {
#else
LONG bindiff(char *tofp,Offtype tolen, char *fromfp, Offtype fromlen,Offtype unit,Offmatch **omatchptr, Offtype maxmatches) {
#endif
#ifdef BESTMATCH
	int maxskip=50,skipnr=0;
	Offmatch *omatch=*omatchptr;
	struct skipper {
		unsigned long beg;
		unsigned long end;
		long displace;
		} *skip;
#endif
	Offtype off,lastmatch=0,end,oldoff=0,jumpoff=0,gojumpoff=tolen;
#ifdef UPDATE
	Offtype left=unit;
#endif
	unsigned long index=0;
#ifdef	TRYBOTH
	Offtype startto=((char *)tofp)-((char *)fromfp),lastadded=startto,testend=startto-unit;	
#endif
	
char *label;
#ifndef INMEM
	char *oldlabel,*tmplabel;
#endif
	Hashgegs *vol=gethash(settablesize?settablesize:(noalign?fromlen:fromlen/unit),tofp,tolen,fromfp,fromlen,unit) ;
#ifdef BOTHMEM
if(ondisk) {
#endif
#ifndef INMEM
	label =(char *)malloc(unit);
	oldlabel =(char *)malloc(unit);
#endif
#ifdef BOTHMEM
}
#endif
	filltable(vol,unit,fromlen);
#ifdef BESTMATCH
skip=(struct skipper*)malloc(sizeof(struct skipper)*maxskip);
omatch=(Offmatch *)realloc(omatch,maxmatches*sizeof(Offmatch));
#endif
	DEBUG("Filled table\n");
#ifdef TESTTABLE
	testtable(vol);
#endif
	end=tolen-unit;

	for(off=0;off<end;) {
		Offtype fromoff;

#ifdef	TRYBOTH
if(dotryboth)
	fromlen=startto+off;
#endif
#ifdef FIRSTDATA
if(off>gojumpoff) {
	off=jumpoff;
	gojumpoff=tolen;
	}
#endif
#ifdef	TRYBOTH
	if(dotryboth) {
		if(lastadded<(off+testend)) {
			Offtype start=lastadded,end=startto+off-unit+1;
			for(;start<end;start+=unit) {
				POINTER *el=itemptr(start,vol);
#ifdef POSARRAY
				*el=(void *)(start+1);
				#endif
				}
			lastadded=end;
			}
		}
#endif
#ifdef BOTHMEM
	if(ondisk) {
#endif
#ifndef INMEM
		readat(tofp,off,label,unit) ;
#endif
#ifdef BOTHMEM
	}
	else
#endif
#if defined(INMEM) ||defined(BOTHMEM)
		label=((char *)tofp)+off;
#endif
#ifdef UPDATE
	left=off-oldoff;
	if(left==1)  {
		index=crcshift(index,*oldlabel,label[unit-1],unit);
		}
	else

		index=crc32(label, unit);

#endif
	oldoff=	off;
{
#ifdef BESTMATCH
#ifndef POSARRAY
#ifdef SAMELABELS
struct list *poslist;
#else
char *otherlabel;
Deel *deel;
#endif
#else
unsigned long *posar,posarbuf[2];
unsigned long posarnr,result,posariter;
char *otherlabel;
#endif
long displace;
int dit,dituit;
#ifndef UPDATE
index=hash(label,vol);
#endif

#ifdef POSARRAY
result=(unsigned long)(vol->tab[index%vol->tablesize]);
if((posar=(unsigned long *)gethashaddr(result))) 
	posarnr=*posar+1;
else {
	if( (posarbuf[1]=getonevalue(result)))  {
		posarnr=2;	
		posar=posarbuf;
		}
	else {
		off=oldoff+1;
		goto leaveloop;
		}
	}
	{
	for(posariter=1;posariter<posarnr;posariter++,off=oldoff) {
		otherlabel=getlabel((char *)(posar[posariter]-1),vol);
		if(compfunctie(label,otherlabel,vol)) {
			freelabel(otherlabel,vol);
			}
		else {
			freelabel(otherlabel,vol);
			fromoff=posar[posariter];
#else
#ifdef SAMELABELS
poslist=getlist(index,label,vol);
	if(poslist) {
	for(;poslist;poslist=poslist->next,off=oldoff) {
		fromoff=(Offtype)poslist->plaats;
#else
for(deel=gethashaddr(vol->tab[index%vol->tablesize]);deel!=NOHASHEL;deel=deel->next,off=oldoff) {
	otherlabel=getlabel(deel->plaats-1,vol);
	if(compfunctie(label,otherlabel,vol)) {
			freelabel(otherlabel,vol);
		}
	else {
		freelabel(otherlabel,vol);
		fromoff=(Offtype)deel->plaats;
#endif
#endif
		if(bestmatch) {
			int havehad=0;
			displace=off-fromoff+1;
			for(dit=0,dituit=0;dit<skipnr;dit++) {
				if(off<skip[dit].end) {
					if(skip[dit].displace==displace&&skip[dit].beg<=off)
						havehad=1;
					skip[dituit++]=skip[dit];
					}
				}
			skipnr=dituit;
			if(havehad)
				continue;
			}
		{
		
#else
#ifdef UPDATE
	fromoff=(Offtype)getathash(index,label,vol);
		if(fromoff) {
#else
		fromoff=(Offtype)getitem(label,vol);
		if(fromoff) {
#endif
#endif
			Offtype len,endto,endfrom;
			fromoff--;
#ifdef BOTHMEM
	if(ondisk) {
#endif
#ifndef INMEM
			int i=-1;
#ifdef IFLOOKBACK
			if(lookback)
#endif
			while(off>0&&fromoff>0&&i==-1){
				char to[BLOCKSIZE],from[BLOCKSIZE];
				do {
					Offtype takeblock=min(BLOCKSIZE,min(off,fromoff));
					if(takeblock<1) {
						i=0;
						break;
						}
					i=takeblock-1;
					readat(tofp,off-takeblock,to,takeblock) 

					readat(fromfp,fromoff-takeblock,from,takeblock) 
					while(i>=0&&to[i]==from[i]) {
						i--;
						}
					off-=(takeblock-(i+1));
					fromoff-=(takeblock-(i+1));
					} while(i==-1);
				}
#ifdef BOTHMEM
	}
		else {
#endif
#endif
#if defined(INMEM) ||defined(BOTHMEM)

#ifdef IFLOOKBACK
			if(lookback)
#endif
			while(off>0&&fromoff>0&&((char *)fromfp)[fromoff-1]==((char *)tofp)[off-1]){
				fromoff--;
				off--;
				}
#ifdef BOTHMEM
	}
#endif
#endif
			if(off<lastmatch) {
				LONG matchiter=matches-1;
				while(matchiter>=0) {
					if(omatch[matchiter].tooff<off) {
						Offtype endlast=omatch[matchiter].tooff+ omatch[matchiter].size;
						if(endlast>off) {
							Offtype differ=endlast-off;
							fromoff+=differ;
							off+=differ;
							}
						break;
						}
					matchiter--;
					}
				matches=matchiter+1;
				}
			len=(oldoff-off)+unit;
			endfrom=fromoff+len;
			endto=off+len;

#ifndef INMEM
#ifdef BOTHMEM
	if(ondisk) {
#endif
			if(endto<tolen&&endfrom<fromlen) {
				int i=-1, takeblock;
				do {	
					char to[BLOCKSIZE],from[BLOCKSIZE];
					takeblock=min(min(tolen-endto,fromlen-endfrom),BLOCKSIZE);
					if(takeblock<1) {
						i=0;
						break;
						}
					readat(tofp,endto,to,takeblock) ;

					readat(fromfp,endfrom,from,takeblock) ;
					for(i=0;i<takeblock&&to[i]==from[i];i++) {
						;
						}
					endfrom+=i;
					endto+=i;
					}while(i==takeblock);
				}
#ifdef BOTHMEM
} else {
#endif
#endif
#if defined(INMEM) ||defined(BOTHMEM)
			while((endto)<tolen&&(endfrom)<fromlen&& ((char *)fromfp)[endfrom]==((char *)tofp)[endto]){
				endto++;endfrom++;
				}

#ifdef BOTHMEM
}
#endif
#endif
		len=endto-off;
	if(matches>=maxmatches) {
		maxmatches+=(maxmatches/2);
/* 		maxmatches*=2; */
		omatch=(Offmatch *)realloc(omatch,maxmatches*sizeof(Offmatch));
		if(!omatch) {
			fprintf(stderr,"Realloc %ld failt", maxmatches*sizeof(Offmatch));
			exit(4);

			}
		}
#ifdef BESTMATCH
if(bestmatch) {
if(skipnr>=maxskip) {
	maxskip*=2;
	skip=(struct skipper *)realloc(skip,sizeof(struct skipper)*maxskip);
	}
skip[skipnr].end=endto;
skip[skipnr].beg=off;
skip[skipnr++].displace=displace;
		}
			if(len>datasize&&(matches==0||!bestmatch||(off<omatch[matches-1].tooff|| endto>(omatch[matches-1].tooff+omatch[matches-1].size)))) {
#else
			if(len>datasize) {
#endif
				omatch[matches].tooff=off;
				omatch[matches].fromoff=fromoff;
				omatch[matches].size=len;
				if(len>verbose)
					printf("%ld: %ld-%ld - %ld\n",matches,omatch[matches].fromoff,omatch[matches].size,omatch[matches].tooff);
				matches++;
#ifdef BESTMATCH
/*
Possible find by lookback?
*/

				if(!bestmatch) {
					off+=len;
					lastmatch=off;
					goto leaveloop;
					}
			else
#define ENDPART 3*(unit-1)
/* Should first look for some alternative starting "within datasize" beside thisone */
#ifdef FASTNEXTALL
			if((endto-ENDPART)>oldoff) {
#ifdef FIRSTDATA
				jumpoff=maxnum(endto-ENDPART,jumpoff);
				gojumpoff=minnum(oldoff+datasize-2,gojumpoff);
				off=oldoff; /*No longer needed */
#else
				off=endto-ENDPART;
				goto leaveloop;
#endif
				}
			else
#endif
				off=oldoff;
			}
		else {
			if(skipnr>SKIPMAX) {
				off+=unit;
				break;
				}
			else
			off=oldoff;
			}
#else
					off+=len;
					lastmatch=off;


				}

		else
				off=oldoff+1;
#endif
			}
#ifdef BESTMATCH
			}

	 }

#ifdef POSARRAY
	}
#endif
#else
		else
#endif
			off=oldoff+1;
	leaveloop:
		tmplabel=oldlabel;
		oldlabel=label;
		label=tmplabel;
		}
		}
#ifdef BOTHMEM
if(ondisk) {
#endif
#ifndef INMEM
	free(label);
	free(oldlabel);
#endif
#ifdef BOTHMEM
	}
#endif
#ifdef BESTMATCH
	free(skip);
#endif
	freehash(vol);
	*omatchptr=omatch;
	return matches;
	}

#ifdef _POSIX_MAPPED_FILES
		 #include <unistd.h>
		 #include <sys/mman.h>
#endif
#define INVALID_SIZE ((Offtype)-1)



#ifdef TRYBOTH

#define decsfile(name) FILE *fp##name; LONG end##name;char * name##gegs
#define openfile(name)\
	*len##name=INVALID_SIZE;\
	if(!(fp##name=fopen(name,"rb")))\
			return NULL;\
	if(fseek(fp##name,0L,SEEK_END)!=0) {\
		fclose(fp##name);\
		return NULL;\
		}\
\
	if((end##name=ftell(fp##name))<=0L) {\
		fclose(fp##name);\
		return NULL;\
		}\
	if(fseek(fp##name,0L,SEEK_SET)!=0) {\
		fclose(fp##name);\
		return NULL;\
		}\
	if(!end##name)\
		return NULL;
#define nextseg(num,seg) ((((num)+(seg)-1)/(seg))*(seg))
size_t page_size;
char *mmapboth(char *from,char *to,Offtype *lenfrom,Offtype *lento,long take) {

	void *mmapgegs=NULL;
	LONG res,totlen,takeend;
	decsfile(from);
	decsfile(to);

	openfile(from);
	openfile(to);
	page_size = (size_t) sysconf (_SC_PAGESIZE);

	totlen=nextseg(endfrom+endto+4*take,page_size)+page_size;

       if((mmapgegs=  mmap(0, totlen , PROT_READ| PROT_WRITE , MAP_ANONYMOUS| MAP_PRIVATE , 0, 0))== MAP_FAILED) {
		return NULL;
		}
       if((fromgegs=  mmap(mmapgegs,  endfrom, PROT_READ| PROT_WRITE  ,MAP_PRIVATE|MAP_FIXED , fileno(fpfrom), 0))== MAP_FAILED) {
		munmap(mmapgegs,totlen);
		return NULL;
		}
	takeend=nextseg(endfrom,page_size);
	memset((char *)mmapgegs+endfrom,'\0',takeend-endfrom);
       if((togegs=  mmap((char *)mmapgegs+takeend,  endto, PROT_READ ,MAP_PRIVATE|MAP_FIXED , fileno(fpto), 0))== MAP_FAILED) {
		munmap(mmapgegs,totlen);
		return NULL;
		}
		

	*lenfrom=endfrom;
	*lento=endto;
	return mmapgegs;
	}


#endif







char *file2mem(char *filename,Offtype *len,int *what) {


	LONG end;
	char *gegs=NULL;
	FILE *fp;
	LONG res;
	errno=0;
	*len=INVALID_SIZE;
	if(!(fp=fopen(filename,"rb")))
			return NULL;
	if(fseek(fp,0L,SEEK_END)!=0) {
		fclose(fp);
		return NULL;
		}

	if((end=ftell(fp))<0L) {
		fclose(fp);
		return NULL;
		}
	if(fseek(fp,0L,SEEK_SET)!=0) {
		fclose(fp);
		return NULL;
		}

	if(end)  {
#define erbij 100
#ifdef HAS_MMAP
	void *mmapgegs;
       if((mmapgegs=  mmap(0,  end, PROT_READ ,MAP_SHARED , fileno(fp), 0))!= MAP_FAILED) {
		gegs=(char *)mmapgegs;
		res=end;
		*what=0;
		}
	else
#endif
		{
		*what=1;
		gegs=(char *)malloc(end+erbij);
		if((res=fread(gegs,1,end,fp))!=end) {
			free(gegs);
			gegs=NULL;
			}
		}
	
		*len=res;
		return gegs;
		}
	else {
		*len=end;return NULL;
		}
		
/*	fclose(fp); */
	}
	#include <sys/stat.h>
FILE *waropen(char *name,Offtype *len) {
	FILE *fp;
	struct stat st;
	if(!(fp=fopen(name,"rb"))) {
		perror(name);
		exit(2);
		}
#ifdef HASNO_FILENO
	stat(name,&st);
#else
	fstat(fileno(fp),&st);
#endif
	*len=st.st_size;
	return fp;
	}
int help(char *name,int dodiff) {
printf("BinPatch " BINPATCHVERSION "\n");
if(dodiff) {
	printf("Creates patchfile. The program binpatch can then be used to \n");
	printf("make tofile from fromfile and patchfile.\n\n");
	printf("Usage: bindiff fromfile tofile patchfile [Options]\n");
	}
else {
	printf("applies binary patch patchfile to fromfile to get tofile\n");
	printf("\nUsage: binpatch fromfile tofile patchfile [Options]\n");
	}


printf("Options:\n");
if(dodiff)  {
	printf("	-a	: apply patch\n");
	printf("	-c	: create patch file (default)\n");
	}
else	{
	printf("	-a	: apply patch (default)\n");
	printf("	-c	: create patch file\n");
	}
printf("	-h	: this help\n");
printf("Extra options when creating a patch:\n");
printf("	-v num	: verbose level\n");
printf("	-u num	: compare with units num bytes (default %d)\n",datasize);
/*printf("	-k num	: skip when below num bytes (default %d)\n",datasize); */
printf("	-l	: don't search only for aligned units\n");
printf("	-O	: search for best match\n");
printf("	-s num	: jump to next off after num inferior matches (default %ld)\n", SKIPMAX);
#ifdef BOTHMEM
printf("	-d	: read files from disk instead of using virtual memory\n");
#endif
printf("	-t num	: table size (default tofilesize/unitsize)\n");
printf("\n");
printf("For smallest patches you should use -l -O and try different values of
-u num (4-12)\n");
printf("Checks should be added with md5sum (e.g. md5sum fromfile tofile patchfile).\n");
printf("Send bugs, patches and questions to jkaltes@cyberbrain.com\n");

	exit(7);
	}
#define MAXBUF 1024
int copypart(FILE *from,Offtype off,FILE *out,Offtype lenin) {
	Offtype len=lenin;
	char buf[MAXBUF];
	tfseek(from,off,SEEK_SET);
	if(len>MAXBUF) {	
		Offtype end=len/MAXBUF;
		Offtype iter=0;
		for(iter=0;iter<end;iter++) {
			tfread(buf, MAXBUF, 1,from);
			tfwrite(buf, MAXBUF, 1,out);
			}
		len=len%MAXBUF;
		}
	if(len>0) {
		tfread(buf, len, 1,from);
		tfwrite(buf, len, 1,out);
		}
	return lenin;
	}
unsigned char magic[]={0xFA,0xDE};

#ifdef COUNTUPNEG
const unsigned long maxneg[]={(1<<7),(1<<15),(1<<23),(1<<31)};
#endif
#ifdef TRYHALF
const unsigned long maxbase[]={(1<<4)-2,(1<<8)-4,(1<<16)-3,(1<<24)-2, 0xFFFFFFFF};
const unsigned long *maxi=maxbase+1;
#else
const unsigned long maxi[]={(1<<8)-4,(1<<16)-3,(1<<24)-2,0xFFFFFFFF};
#endif
const unsigned long marks[]={0xFFFFFFFF,0xFFFFFFFE, 0xFFFFFFFD, 0xFFFFFFFC};
/*
int compmatch(const void *one, const void *two) {
	Offmatch *matchone=(Offmatch *)one;
	Offmatch *matchtwo=(Offmatch *)two;
	if(matchone->tooff!=matchtwo->tooff)
		return matchone->tooff-matchtwo->tooff;
	if(matchone->size!=matchtwo->size)
		return matchtwo->size-matchone->size;
	return labs(matchone->fromoff-matchone->tooff)-labs(matchtwo->fromoff-matchtwo->tooff);

	}
*/

long justaddbest(Offmatch ar[],long nr) { 
	long u,i;
	Offtype start=0;
	for(i=0,u=0;i<nr;i++) {
	again:
		if((ar[i].tooff+ar[i].size)>start) {
			int  j,oldi=i;
			Offtype havestart=maxnum(maxnum(0,start-datasize) ,ar[i].tooff);
			Offtype havend= ar[i].tooff+ar[i].size;
			
			for(j=i+1;j<nr&&ar[j].tooff<=havestart;j++)
				if((ar[j].tooff+ar[j].size)>havend) {
					i=j;
					havend= ar[i].tooff+ar[i].size;
					}

			if(u>0&&(ar[i].tooff-ar[u-1].tooff)<=datasize) {
				u--;
				i=oldi;
				if(u>0) {
					start=ar[u-1].tooff+ar[u-1].size+datasize;
					}
				else
					start=0;
				goto again;
				}

			ar[u++]=ar[i];
			start=ar[i].tooff+ar[i].size+datasize;
			}
		}
	return u;
	}
long rmoverlap(Offmatch ar[],long nr) { 
	long i,u;
	if(nr<2)
		return 0;
	for(i=nr-2,u=nr-1;i>=0;i--) {
	again:
		if((ar[i].tooff+ar[i].size)>ar[u].tooff) {
			Offtype dif=ar[i].tooff+ar[i].size-ar[u].tooff;
			if((ar[u].size-dif)<=datasize) {
				u++;
				goto again;
/* 				ar[u]=ar[i]; */
				}
			else {
				ar[i].size=(ar[u].tooff-ar[i].tooff);
				if(ar[i].size>datasize)
					ar[--u]=ar[i];
				}
			}
		else
			ar[--u]=ar[i];
		}
	return u;
	}
	
int compmatch(const void *one, const void *two) {
	Offmatch *matchone=(Offmatch *)one;
	Offmatch *matchtwo=(Offmatch *)two;
	if(matchone->tooff!=matchtwo->tooff)
		return matchone->tooff-matchtwo->tooff;
	if(matchone->size!=matchtwo->size)
		return matchtwo->size-matchone->size;
	return labs(matchone->fromoff-matchone->tooff)-labs(matchtwo->fromoff-matchtwo->tooff);

	}
int sortmatches(Offmatch *omatch,int matches) {
if(matches<2)
	return matches;
qsort(omatch, matches, sizeof(Offmatch), &compmatch);
{
int i,u;
Offtype prevend,nextend;
prevend=omatch[0].tooff+omatch[0].size;
for(i=1,u=0;i<matches;i++) {
	nextend=omatch[i].tooff+omatch[i].size;
	if(nextend>prevend) {
		omatch[++u]=omatch[i];
		prevend=nextend;
		}
	}
matches=u+1;
}
return matches;
}
int bdiff(char *fromfile,char *tofile,char *outfile,Offtype take) {
Offtype fromlen,tolen;
Offmatch *omatch;
Offtype newmax,matches,maxmatches,i;
Offtype totsize,lastoff;
struct stat st;
FILE *outfp;
#ifndef INMEM
FILE *tofp,*fromfp;
#endif

#if defined(BOTHMEM) || defined(INMEM)
char *from,*to;
int frommem=-1,tomem=-1;
#endif
if(take<=0)
	take=datasize;

#if defined(INMEM) || defined(BOTHMEM) 
#ifdef BOTHMEM
if(!ondisk) 
	{
#endif
#ifdef TRYBOTH
if(dotryboth)  {
	from=mmapboth(fromfile,tofile,&fromlen,&tolen,take);
	to=((char *)from)+nextseg(fromlen,page_size);
	}
else
#endif
{
	from=file2mem(fromfile,&fromlen,&frommem);
	to=file2mem(tofile,&tolen,&tomem);
}
if(tolen==INVALID_SIZE)	{
	perror(tofile);return -3;
	}
if(fromlen==INVALID_SIZE)	{
	perror(fromfile);return -4;
	}
if(tolen<=0) {
	fprintf(stderr,"Can't read data from %s\n",tofile);	
	return -5;
	}
if(fromlen<=0) {
	fprintf(stderr,"Can't read data from %s\n",fromfile);	
	return -6;
	}
#ifdef BOTHMEM
	}
else {
#endif
#endif
#ifndef INMEM
tofp=waropen(tofile,&tolen);
fromfp=waropen(fromfile,&fromlen);
#endif
#ifdef BOTHMEM
};
#endif
if(LSTAT(outfile,&st)==0) {
	fprintf(stderr,"%s already exists\n",outfile);return -1;
	}
if(!(outfp=fopen(outfile,"wb"))) {
	perror(outfile);
	return -1;
	}

if(take<=0)
	take=datasize;
maxmatches=(tolen/take)+1;
/*mmap?*/
omatch=NULL;
if(verbose!=NOVERBOSE)
	printf("nr: fromoffset-size - tooffset\n");
/* #define SPLITFILE */
#ifdef SPLITFILE
{
Offtype fromunit=1024*1024,fromoff,matchiter=0,newmatch=0,takefrom;
for(fromoff=0;fromoff<fromlen;fromoff+=fromunit) {

	takefrom=minnum(fromunit,fromlen-fromoff);
	#ifdef INMEM
	matches=bindiff(to,tolen,from,fromlen,take,&omatch,maxmatches);
	#else
	#ifdef BOTHMEM
	if(!ondisk)
		newmatch=fbindiff((FILE*)to,tolen,(FILE *)(from+fromoff),takefrom,take,&omatch,matchiter,maxmatches);
	else
	#endif
		newmatch=fbindiff(tofp,tolen,fromfp,takefrom,take,&omatch,matchiter,maxmatches);
	#endif
	maxmatches=newmatch;
	for(;matchiter<newmatch;matchiter++) {
		omatch[matchiter].fromoff+=fromoff;
		}
	matchiter=sortmatches(omatch,matchiter);
	}
matches=matchiter;
}
#else
	#ifdef INMEM
	matches=bindiff(to,tolen,from,fromlen,take,&omatch,maxmatches);
	#else
	#ifdef BOTHMEM
	if(!ondisk)
		matches=fbindiff((FILE*)to,tolen,(FILE *)from,fromlen,take,&omatch,0,maxmatches);
	else
	#endif
		matches=fbindiff(tofp,tolen,fromfp,fromlen,take,&omatch,0,maxmatches);
	#endif
#endif

/*
if(!ondisk)
	matches=fbindiff((FILE*)to,tolen,(FILE *)(from),fromlen,take,&omatch,0,maxmatches);
else
	matches=fbindiff(tofp,tolen,fromfp,fromlen,take,&omatch,0,maxmatches);
*/
#if defined(INMEM) || defined(BOTHMEM) 
#ifdef BOTHMEM
if(!ondisk) 
	{
#endif
#ifdef TRYBOTH
if(dotryboth)
	munmap(from,fromlen);
else 
#endif
{
if(frommem)
	free(from);
#ifdef HAS_MMAP
else
	munmap(from,fromlen);
#endif

}
#ifdef BOTHMEM
}
#endif
#endif

#ifdef BESTMATCH
if(bestmatch) {
matches=sortmatches(omatch,matches);
omatch=(Offmatch *)realloc(omatch,matches*sizeof(Offmatch));
DEBUG("Discarded obvious wrong\n");
{
Offtype start;
#ifdef NONOPT
matches= makefirst(omatch,matches);
#else
matches= justaddbest(omatch,matches) ;
/* matches= makelineopt(omatch,matches); */
/* omatch=realloc(omatch,matches*sizeof(Offmatch)); */
#endif
start=rmoverlap(omatch,matches); 
matches-=start;
omatch+=start;
}
}
DEBUG("Selected matches\n");
if(matches==0) {
	printf("%s and %s have really nothing in common (given -u and -l)\n",
		fromfile,tofile);
	exit(9);
	}

#endif
#ifdef SHOWRES
{
int i;
for(i=0;i<matches;i++)
	printf("%ld: %ld (%ld)\n",omatch[i].tooff,omatch[i].fromoff,omatch[i].size);
}
#endif
totsize=0;
lastoff=0;
if(fwrite( (char *)&magic, sizeof(magic), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&fromlen, sizeof(fromlen), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&matches, sizeof(matches), 1,outfp)!=1) {
	perror(outfile); return -2;
	}

#ifdef LARGEOFFS
if(fwrite( (char *)omatch, sizeof(Offmatch),matches,outfp)!=matches) {
	perror(outfile); return -2;
	}
#else
{

#define MARKSMALL 0xFFFFFFFF
unsigned int large=MARKSMALL;
/* int froms[4]={0,0,0,0},to[4]={0,0,0,0},lens[4]={0,0,0,0}; */
/* unsigned long fromsneeds[4]={0,0,0,0},toneeds[4]={0,0,0,0},lensneeds[4]={0,0,0,0}; */
unsigned long fromsneedsbuf[5]={0,0,0,0,0},toneedsbuf[5]={0,0,0,0,0},lensneedsbuf[5]={0,0,0,0,0};
unsigned long *fromsneeds=fromsneedsbuf+1;
unsigned long *toneeds=toneedsbuf+1;
unsigned long *lensneeds=lensneedsbuf+1;

unsigned long fromsbuf[5]={0,0,0,0,0},tobuf[5]={0,0,0,0,0},lensbuf[5]={0,0,0,0,0};
unsigned long *froms=fromsbuf+1;
unsigned long *to=tobuf+1;
unsigned long *lens=lensbuf+1;
int todef,fromdef,lendef;
int tomax,frommax,lenmax;
unsigned long tosize,fromsize,lensize;

/*const unsigned long long marku=0xFFFFFFFF;
const long volu[3]={0,-1,-2};
const unsigned long long marks=0x80000000;
const unsigned long vols[3]= {0,0xFFFFFFFF,0x1};
*/

		
#define MARKSMALL 0xFFFFFFFF
#define RELFROM

#ifdef RELFROM
/* const unsigned long maxs[]={(1<<7)-2,(1<<15)-2,(1<<23)-1}; */
#endif
Offtype topos=0,relto;
#ifdef COUNTUPNEG
#define design(get,num) ((get)+maxneg[(num)])
#define resign(get,num) ((get)-maxneg[(num)])
#else
#define design(get,num) ((labs(get)<<1)|(((get)<0)?1:0))
#define resign(get,num) (((get)&1)?(-((get)>>1)):((get)>>1))
#endif
#ifdef TRYAHALF
#define settos(relto,to,max) { char it;\
	for(it=-1;it<3&&(relto>max[it]);it++)\
		;	\
	to[it]++;\
	}
#define settossign(relto,to,max) {\
	long get;\
	char it;\
	for(it=-1;it<3&&((((get=design(relto,it))<0)||(get>max[it])));it++)\
		;	\
	to[it]++;\
	}
	
#define needsize(get,max,bytes)  for(bytes=-1;bytes<3&&get>max[bytes];bytes++) ; bytes++;
#define needsizesign(get,max,bytes)  {long tal; for(bytes=-1;bytes<3&&((((tal=design(get,bytes)),tal<0)||(tal>max[bytes])));bytes++) ; bytes++;}

#define desize(to,take,last) { \
unsigned long min=0xFFFFFFFF; \
getsize(to,to##needs);\
for(i=0;i<4;i++) { \
	if(to[i]) { \
		last=i+1; \
		} \
	if(to##needs[i]<min) {\
		min=to##needs[i];\
		take=i;\
		}\
	} }
#define getsize(to,dsize)	dsize[0]=to[-1]+to[0]+to[1]*3+to[2]*4+to[3]*5; dsize[1]=(to[-1]+to[0]+to[1])*2+to[2]*5+to[3]*6; dsize[2]=(to[-1]+to[0]+to[1]+to[2])*3+to[3]*7; dsize[3]=(to[-1]+to[0]+to[1]+to[2]+to[3])*4; dsize[-1]=(to[-1]/2)+to[0]*2+to[1]*3+to[2]*4+to[3]*5; 
/* dsize[0]=to[0]+to[1]*3+to[2]*4+to[3]*5; dsize[1]=(to[0]+to[1])*2+to[2]*5+to[3]*6; dsize[2]=(to[0]+to[1]+to[2])*3+to[3]*7; dsize[3]=(to[0]+to[1]+to[2]+to[3])*4; dsize[-1]=(to[-1]/2)+to[0]*2+to[1]*3+to[2]*4+to[3]*5;  */
#else
#define settos(relto,to,max) { char it;\
	for(it=0;it<3&&(relto>max[it]);it++)\
		;	\
	to[it]++;\
	}
#define settossign(relto,to,max) {\
	long get;\
	char it;\
	for(it=0;it<3&&((get=design(relto,it))<0||(get>max[it]));it++)\
		;	\
	to[it]++;\
	}
	
#define needsize(get,max,bytes)  for(bytes=0;bytes<3&&get>max[bytes];bytes++) ; bytes++;
#define needsizesign(get,max,bytes)  {long tal; for(bytes=0;bytes<3&&((tal=design(get,bytes),tal<0)||tal>max[bytes]);bytes++) ; bytes++;}

#define desize(to,take,last) { \
unsigned long min=0xFFFFFFFF; \
getsize(to,to##needs);\
for(i=0;i<4;i++) { \
	if(to[i]) { \
		last=i+1; \
		} \
	if(to##needs[i]<min) {\
		min=to##needs[i];\
		take=i;\
		}\
	} }
#define getsize(to,dsize) dsize[0]=to[0]+to[1]*3+to[2]*4+to[3]*5; dsize[1]=(to[0]+to[1])*2+to[2]*5+to[3]*6; dsize[2]=(to[0]+to[1]+to[2])*3+to[3]*7; dsize[3]=(to[0]+to[1]+to[2]+to[3])*4;
#endif
{
/* #define FROMFROM */
#ifdef FROMFROM
Offtype frompos=0;
#endif
for(i=0;i<matches;i++) {
	
	if(omatch[i].size>0) {
		Offtype len=omatch[i].size;
#ifdef FROMFROM
		Offtype from=omatch[i].fromoff-frompos;
		frompos=omatch[i].fromoff+omatch[i].size;
#else
	#ifdef RELFROM
		Offtype from=omatch[i].fromoff-omatch[i].tooff;
	#else
		Offtype from=omatch[i].fromoff;
	#endif
#endif
		relto=omatch[i].tooff-topos;
		settos(relto,to,maxi);
		settos(len,lens,maxi);
	#ifdef RELFROM
		settossign(from,froms,maxi);
	#else
		settos(from,froms,maxi);
	#endif
		topos=omatch[i].tooff+omatch[i].size;
		}
	}

}
desize(to,todef,tomax)
desize(froms,fromdef,frommax)
desize(lens,lendef,lenmax)
#ifdef NOCOMPRE
todef=fromdef=lendef=3;
tomax=frommax=lenmax=4;
#endif
/*  */
/* #define maxsize(to) to##size=max[to##def]+(4-to##max); */
/*  */
#ifdef COUNTREPEAT
#define maxsize(to) to##size=maxi[to##def]+(4-to##max)-1; /*-1 for repsign */
#else
#define maxsize(to) to##size=maxi[to##def]+(4-to##max);
#endif
/* #define maxsize(to) to##size=max[to##def]; */
maxsize(to)
maxsize(from)
maxsize(len)
/* #define BESIDE */

if(fwrite( (char *)&todef, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&fromdef, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&lendef, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&large, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&tomax, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&frommax, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&lenmax, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
if(fwrite( (char *)&large, sizeof(char), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
newmax=matches;
topos=0;
DEBUG("\n");
#define nothing(x) x
/*#define mksign(defau,type,mar) *((unsigned long*)((char *)&mark##type+(3-defau)))+vol##type[mar]*/

#define mksign(defau,type,mar) marks[mar]
#define gensign(defau,bytes) mksign((defau),type,(bytes)-(defau)-2)
#ifdef BESIDE
#define save(str,len,nr,outfp,name) fwrite(str,len,nr,outfp)
#else
#define save(str,len,nr,outfp,name) (memcpy(name##uit+name##iter,str,(len)*(nr)), name##prev=name##iter,name##iter+=((len)*(nr)),(nr))
#endif
#define savenum(num,defau,thesize,name) { \
	 if((num)<=(thesize)) {\
		 if(save( (char *)&(num), (defau+1),1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	}\
else {\
	int bytes,mar;\
	unsigned long sign;\
	needsize(num,maxi,bytes);\
 	mar=bytes-defau-2;\
	sign= mksign(defau,type,mar);\
	if(save( (char *)&sign,defau+1, 1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	if(save( (char *)&num, bytes,1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	}\
}

#define savenumsign(num,defau,thesize,name) {\
unsigned long  unnum;\
unnum=design(num,defau);\
if(unnum<=thesize) {\
	if(save( (char *)&unnum, defau+1,1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	}\
else {\
	int bytes,mar;\
	unsigned long sign;\
	needsizesign(num,maxi,bytes);\
 	mar=bytes-defau-2;\
	sign= mksign(defau,type,mar);\
	if(save( (char *)&sign,defau+1, 1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	sign=design(num,bytes-1);\
	if(save( (char *)&sign, bytes,1,outfp,name)!=1) {\
		perror(outfile); return -2;\
		}\
	}\
}
{
#ifndef BESIDE
int toiter=0,fromsiter=0,lensiter=0;
int toprev=0,fromsprev=0,lensprev=0;
char *fromsuit=(char *)malloc(fromsneeds[fromdef]);
char *touit=(char *)malloc(toneeds[todef]);
char *lensuit=(char *)malloc(lensneeds[lendef]);
if(!fromsuit||!touit||!lensuit) {
	fprintf(stderr,"Malloc failt\n");exit(8);
	}
#endif
/* #define ALLTOGETHER */
#if defined(ALLTOGETHER)||defined(BESIDE)
for(i=0;i<matches;i++) {
	int startpos,len;
	Offtype from=omatch[i].fromoff-omatch[i].tooff;
	relto=omatch[i].tooff-topos;
#ifdef BESIDE
	startpos=ftell(outfp);
#endif
	savenum(relto,todef,tosize,to);
	savenum(omatch[i].size,lendef,lensize,lens);
	savenumsign(from,fromdef,fromsize,froms);
#ifdef BESIDE
	len=ftell(outfp)-startpos;
#else
len=toiter+fromsiter+lensiter- (toprev+fromsprev+lensprev);
#endif
	if(omatch[i].size<=len) {
#ifdef BESIDE
		tfseek(outfp,startpos,SEEK_SET);
#else
	#define iterback(name)	name##iter=name##prev;
	iterback(to);
	iterback(froms);
	iterback(lens);
#endif
		omatch[i].size=0;
		newmax--;
		}
	else {
		DEBUG("%ld: %ld->%ld (%ld)\n",omatch[i].tooff,relto,from,omatch[i].size);
		topos=omatch[i].tooff+omatch[i].size;
		}
	
	}
#else
{
Offtype *tobuf,*fromsbuf,*lensbuf;
#ifdef FROMFROM
Offtype frompos=0;
#endif
#ifdef COUNTREPEAT
char nrdef=0;
long nrsize=maxi[nrdef];
#endif
tobuf=(Offtype *)malloc(sizeof(Offtype)*matches);
fromsbuf=(Offtype *)malloc(sizeof(Offtype)*matches);
lensbuf=(Offtype *)malloc(sizeof(Offtype)*matches);
for(i=0;i<matches;i++) {
	tobuf[i]= omatch[i].tooff-topos;
	topos=omatch[i].tooff+omatch[i].size;
	}
for(i=0;i<matches;i++) {
	
#ifdef FROMFROM
	fromsbuf[i]=omatch[i].fromoff-frompos;
	frompos=omatch[i].fromoff+omatch[i].size;
#else
	fromsbuf[i]=omatch[i].fromoff-omatch[i].tooff;
#endif

	}
for(i=0;i<matches;i++) {
	lensbuf[i]=omatch[i].size;	
	}


#define repsave(num,defau,thesize,name,nr,type) {\
	unsigned long repsign=thesize+1;\
	save( (char *)&repsign,defau+1, 1,outfp,name); \
	savenum(nr,nrdef,nrsize,name);\
	save##type(num,defau,thesize,name);}

/* 	savenumsign(from,fromdef,fromsize,froms); */
/* 	savenum(relto,todef,tosize,to); */
/* 	 */
#ifdef COUNTREPEAT
#define savearray(to,tobuf,todef,tosize,type)	\
for(i=0;i<matches;i++) {\
	Offtype get=tobuf[i];\
	if(get==tobuf[i+1]&&get==tobuf[i+2]) {\
		long j,nr;\
		for(j=i+3;j<matches&&get==tobuf[j];j++)\
			;\
		nr=j-i;\
		repsave(get,todef,tosize,to,nr,type); \
		i=(j-1);\
		}\
	else\
		save##type(get,todef,tosize,to);\
	}
#else
#define savearray(to,tobuf,todef,tosize,type)	\
for(i=0;i<matches;i++) {\
	Offtype get=tobuf[i];\
	save##type(get,todef,tosize,to);\
	}
#endif
savearray(to,tobuf,todef,tosize,num)	
savearray(froms,fromsbuf,fromdef,fromsize,numsign)	
savearray(lens,lensbuf,lendef,lensize,num)	

free(tobuf);free(fromsbuf);free(lensbuf);
}
#endif
#ifndef BESIDE
	tfwrite(&toiter,4,1,outfp);
	tfwrite(&fromsiter,4,1,outfp);
	tfwrite(&lensiter,4,1,outfp);
	tfwrite(touit,toiter,1,outfp);
	tfwrite(fromsuit,fromsiter,1,outfp);
	tfwrite(lensuit,lensiter,1,outfp);
{
int tryunit= ((toiter+fromsiter+lensiter+matches-1)/matches)+2;
if((!noalign)||tryunit!=datasize||!bestmatch) {
	printf("Smaller patch sometimes possible with %s%s%s\n",(noalign?"":"-l "),(bestmatch?"":"-O "),(tryunit==datasize)?"":"-u num (4-13)");
	}
}
free(touit);
free(lensuit);
free(fromsuit);
#endif
}
}
#endif
DEBUG("end index=%ld\n",ftell(outfp));
for(i=0;i<matches;i++) {
	if(omatch[i].size>0) {
		if(lastoff<omatch[i].tooff) {
			Offtype len=omatch[i].tooff-lastoff;

	#ifndef INMEM
	#ifdef BOTHMEM
		if(ondisk) {
	#endif
			copypart(tofp,lastoff,outfp,len);
	#endif
	#ifdef BOTHMEM
		}
		else {
	#endif
	#if defined(INMEM) ||defined(BOTHMEM)
			if(fwrite( to+lastoff, len, 1,outfp)!=1) {
				perror(outfile); return -2;
				}
	#endif
	#ifdef BOTHMEM
		}
	#endif
			}
		lastoff=omatch[i].tooff+omatch[i].size;
		totsize+=omatch[i].size;
		}
	}
if(lastoff<tolen) {
	Offtype len=tolen-lastoff;

#ifndef INMEM
#ifdef BOTHMEM
	if(ondisk) {
#endif
	copypart(tofp,lastoff,outfp,len);
#endif

#ifdef BOTHMEM
	}	else {
#endif
#if defined(INMEM) || defined(BOTHMEM)
		if(fwrite( to+lastoff, len, 1,outfp)!=1) {
			perror(outfile); return -2;
			}
#endif
#ifdef BOTHMEM
	}
#endif
	}
tfseek(outfp,(sizeof(magic)+sizeof(fromlen)),SEEK_SET)
if(fwrite( (char *)&newmax, sizeof(matches), 1,outfp)!=1) {
	perror(outfile); return -2;
	}
fclose(outfp);
if(verbose!=NOVERBOSE)
	printf("total in common %ld bytes\n",totsize);
return 0;
}
int bpatch(char *fromfile,char *outfile,char *patchfile) {
		FILE *outfp;
		Offtype fromlen,needfromlen,patchlen,i,lastoff=0,dataiter=0,matches;	
		char *data;
		Offtype datalen;
		Offmatch *omatch;
		int patchmem=-1,frommem=-1;
		char *patch=file2mem(patchfile,&patchlen,&patchmem);
		struct stat st;
#ifndef INMEM
		FILE *fromfp=waropen(fromfile,&fromlen);
#else
		char *from=file2mem(fromfile,&fromlen,&frommem);

		if(!from||fromlen==INVALID_SIZE)	{
			perror(fromfile);return -4;
			}
#endif
		if(!patch||patchlen==INVALID_SIZE)	{
			perror(patchfile);return -3;
			}
		if(patchlen<12L)	{
			fprintf(stderr,"%s too small (%ld) for a patchfile\n",patchfile,patchlen);
			return -4;
			}
		if(LSTAT(outfile,&st)==0) {
			fprintf(stderr,"%s already exists\n",outfile);return -1;
			}
		if(memcmp(patch,magic,sizeof(magic))) {
			fprintf(stderr,"%s is no proper patchfile\n",patchfile);
			return -2;
			}
		needfromlen=*((Offtype *)((char *)patch+sizeof(magic)));
		if(needfromlen!=fromlen) {
			fprintf(stderr,"fromfile %s should have size %ld according to patchfile %s\n",fromfile,needfromlen,patchfile);
			return -4;
			}
		if(!(outfp=fopen(outfile,"wb"))) {
			perror(outfile);
			return -1;
			}
		matches=*((Offtype *)((char *)patch+sizeof(magic)+sizeof(Offtype)));
#define startmatches ((2*sizeof(Offtype))+sizeof(magic))
#ifdef LARGEOFFS
		if(patchlen<(startmatches+(matches*sizeof(Offmatch)))) {
			fprintf(stderr,"%s Invalid patchfile 1. Not long enough\n",patchfile); return -7;
			}
#endif
			
{
#ifndef LARGEOFFS
#define MARKSMALL 0xFFFFFFFF
/*unsigned long large=MARKSMALL;*/
char todef,fromdef,lendef;
char tomax,frommax,lenmax;
unsigned long tosize,fromsize,lensize;


/* const unsigned long long eerder=0,tweeder=0,marku=0xFFFFFFFF,nogger=0,eener=0; */
/* const long volu[3]={0,-1,-2}; */
/* const unsigned long long one=0,two=0,marks=0x80000000,nog=0,een=0; */
/* const unsigned long vols[3]= {0,0xFFFFFFFF,0x1}; */
/* const unsigned long max[]={(1<<8)-4,(1<<16)-3,(1<<24)-2}; */
/* const unsigned long maxs[]={(1<<7)-2,(1<<15)-2,(1<<23)-1}; */
#define MARKSMALL 0xFFFFFFFF
/* #define mksign(defau,type,mar) *((unsigned long*)((char *)&(long long)mark##type+(3-defau)))+vol##type[mar] */
/* #define signval(defau,type,sign,val) for(val=defau;val<3;val++) if(!memcmp(&mksign(defau,type,val),&sign,val+2)) break;  */
#define signval(defau,type,sign,val) for(val=0;val<3;val++) if(!memcmp(&mksign(defau,type,val),&sign,defau+1)) break; 
#ifdef BESIDE
#define getvalue(table,def,max,type,val) {\
	memcpy(&val,table,def+1);\
	table+=(def+1);\
	if(val>max[def]) {\
		int nr;\
		signval(def,type,val,nr);\
		nr+=(def+2);\
		val=0;\
		memcpy(&val,table,nr);\
		table+=nr;\
		}\
	}
#else
#define getvalue(table,def,maxsize,name,val) {\
	memcpy(&val,name##uit+name##iter,def+1);\
	name##iter+=(def+1);\
	if(val>maxsize) {\
		int nr;\
		signval(def,type,val,nr);\
		nr+=(def+2);\
		val=0;\
		memcpy(&val,name##uit+name##iter,nr);\
		name##iter+=nr;\
		}\
	}
#endif
#ifdef BESIDE
#define getvaluesign(table,def,maxsize,type,val) {\
	unsigned long uval=0;\
	memcpy(&uval,table,def+1);\
	table+=(def+1);\
	if(uval>maxsize) {\
		int nr;\
		signval(def,type,uval,nr);\
		nr+=(def+2);\
		uval=0;\
		memcpy(&uval,table,nr);\
		table+=nr;\
		val=resign(uval,nr-1);\
		}\
	else {\
		val=resign(uval,def);\
		}\
	}
#else
#define getvaluesign(table,def,maxsize,name,val) {\
	unsigned long uval=0;\
	memcpy(&uval,name##uit+name##iter,def+1);\
	name##iter+=(def+1);\
	if(uval>maxsize) {\
		int nr;\
		signval(def,type,uval,nr);\
		nr+=(def+2);\
		uval=0;\
		memcpy(&uval,name##uit+name##iter,nr);\
		name##iter+=nr;\
		val=resign(uval,nr-1);\
		}\
	else {\
		val=resign(uval,def);\
		}\
	}
#endif
unsigned char *piter=(unsigned char*)(patch+startmatches);

	if(*((unsigned char*)(patch+startmatches+3))==0xFF&&
	*((unsigned char*)(patch+startmatches+7))==0xFF)
 {
unsigned long toiter=0,fromsiter=0,lensiter=0;
unsigned long tolen=0,fromslen=0,lenslen=0;
char *fromsuit;
char *touit;
char *lensuit;
		Offtype topos=0;
#ifdef BESIDE
		unsigned char *table=(unsigned char *)(patch+startmatches+8);
#endif
		omatch=(Offmatch  *) malloc(sizeof(Offmatch)*matches);

		todef=*piter++;
		fromdef=*piter++;
		lendef=*piter++;
		piter++;
		tomax=*piter++;
		frommax=*piter++;
		lenmax=*piter++;
/* #define maxsize(to) to##size=max[to##def]+(4-to##max); */
/* #define maxsize(to) to##size=max[to##def]; */
maxsize(to)
maxsize(from)
maxsize(len)
		piter++;
#ifndef BESIDE
	tolen=*((long *)piter);piter+=sizeof(long);
	fromslen=*((long *)piter);piter+=sizeof(long);
	lenslen=*((long *)piter);piter+=sizeof(long);
	touit=(char *)piter;piter+=tolen;
	fromsuit=(char *)piter;piter+=fromslen;
	lensuit=(char *)piter;piter+=lenslen;
#endif
		for(i=0;i<matches;i++) {
			Offtype newto=0,newlen=0,newfrom=0;
			getvalue(table,todef,tosize,to,newto);
			getvalue(table,lendef,lensize,lens,newlen);
			getvaluesign(table,fromdef,fromsize,froms,newfrom);
			topos=omatch[i].tooff=topos+newto;
			omatch[i].size=newlen;
			omatch[i].fromoff=topos+newfrom;
			topos+=omatch[i].size;
/* 	DEBUG("%ld->%ld (%ld)\n",omatch[i].fromoff,omatch[i].tooff,omatch[i].size); */
			}
#ifdef BESIDE
		data=(char *)table;
#else
		data=(char *)piter;
#endif
		}
	else
#endif
		{
		omatch=(Offmatch*)(patch+startmatches);
		data=(char *)&omatch[matches];
		}
		datalen=patchlen-(data-patch);
		for(i=0;i<matches;i++) {
			if(lastoff<omatch[i].tooff) {
				Offtype len=omatch[i].tooff-lastoff;
				Offtype newiter=dataiter+len;
				if(newiter>datalen) {
					fprintf(stderr,"%s Invalid patchfile 2. Not long enough\n",patchfile); return -7;
					}
				tfwrite(data+dataiter,len,1,outfp);
				dataiter=newiter;
				}
#ifdef INMEM
			tfwrite(from+omatch[i].fromoff,omatch[i].size,1,outfp);
#else
		 copypart(fromfp,omatch[i].fromoff,outfp,omatch[i].size) ;
#endif
			lastoff=omatch[i].tooff+omatch[i].size;
			}
		if(dataiter<datalen) {
			Offtype len=datalen-dataiter;
			Offtype newiter=dataiter+len;
			if(newiter>datalen) {
				fprintf(stderr,"%s Invalid patchfile 3. Not long enough\n",patchfile); return -7;
				}
			tfwrite(data+dataiter,len,1,outfp);
			dataiter=newiter;
			}
		fclose(outfp);
		
	}
	return 0;
	}
/*
extern int MAXCOMPARE;
extern int MAXDEPTH;
*/
#if !defined(__USE_GNUC__) || defined(GO32) || defined(__CYGWIN__)

#define	strcasestr(name,lab) (strstr(name,"binpatch")||strstr(name,"BINPATCH"))
#endif
#define numarg(var) if(argv[arg][2]) var=atol(argv[arg]+2); else { if(argc>(arg+1)) { arg++; var=atol(argv[arg]); } else { fprintf(stderr,"%s Option %s requires an argument\n",argv[0],argv[arg]); return -2; } }
int main(int argc,char **argv) {
	int dodiff=1,arg,take=0,inmemory=0;
	if(strcasestr(argv[0],"BINPATCH")) {
			dodiff=0;
			}
	if(argc<4) {
		help(argv[0],dodiff);
		exit(3);
		}
	for(arg=4;arg<argc;arg++) {
		if(argv[arg][0]=='-') {
			switch(argv[arg][1]) {
#ifdef BOTHMEM
				case 'd': ondisk=1;break;
#endif
				case 'u': numarg(take);datasize=take; break;
				case 'k': numarg(datasize); break;
#ifdef TRYNALIGN
				case 'l': noalign=1;break;

#endif
#ifdef IFLOOKBACK
				case 'b': lookback=0;break;
#endif
#ifdef BESTMATCH
				case 'O': bestmatch=1;break;
/*
				case 'B': numarg(MAXCOMPARE);break;
				case 'D': numarg(MAXDEPTH);break;
*/
				case 's': numarg(SKIPMAX);break;
#endif
#ifdef TRYBOTH
				case 'A': dotryboth=1;break;
#endif
				case 'a': dodiff=0;break;
				case 'c': dodiff=1;break;
				case 't': numarg(settablesize); break;
				case 'm': inmemory=1;	break;
				case 'h': return help(argv[0],dodiff); break;
				case 'v': numarg(verbose);break;
							
				};
			
			}

		}
	if(dodiff)
		return bdiff( argv[1],argv[2],argv[3],take) ;
	return bpatch(argv[1],argv[2],argv[3]);
	}
/*
File Format:
from: name
to: name
add: name
*/

