/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class DateTimeSerializer
extends SimpleTypeSerializer<OffsetDateTime> {
    public DateTimeSerializer() {
        super(DataType.DATETIME);
    }

    @Override
    protected OffsetDateTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        LocalDate localDate = LocalDate.of(buffer.readInt(), buffer.readByte(), (int)buffer.readByte());
        LocalTime localTime = LocalTime.ofNanoOfDay(buffer.readLong());
        LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
        ZoneOffset zo = ZoneOffset.ofTotalSeconds(buffer.readInt());
        return OffsetDateTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(OffsetDateTime value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value.getYear()).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
        buffer.writeLong(value.toLocalTime().toNanoOfDay());
        buffer.writeInt(value.getOffset().getTotalSeconds());
    }
}

