/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DiscardStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectCapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.util.StepOutputArityPredictor;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class EarlyLimitStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final EarlyLimitStrategy INSTANCE = new EarlyLimitStrategy();

    private EarlyLimitStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        List<Step> steps = traversal.getSteps();
        Step insertAfter = null;
        boolean merge = false;
        int j = steps.size();
        for (int i = 0; i < j; ++i) {
            Step step = steps.get(i);
            if (step instanceof RangeGlobalStep) {
                if (insertAfter == null) continue;
                TraversalHelper.copyLabels(step, step.getPreviousStep(), true);
                insertAfter = this.moveRangeStep((RangeGlobalStep)step, insertAfter, traversal, merge);
                if (insertAfter instanceof DiscardStep) {
                    int discardStepIndex = TraversalHelper.stepIndex(insertAfter, traversal);
                    for (i = j - 2; i > discardStepIndex; --i) {
                        if (steps.get(i) instanceof SideEffectCapStep || steps.get(i) instanceof ProfileSideEffectStep) continue;
                        traversal.removeStep(i);
                    }
                    break;
                }
                j = steps.size();
                continue;
            }
            if (!this.isMapStepMovable(step) && !(step instanceof SideEffectStep)) {
                insertAfter = step;
                merge = true;
                continue;
            }
            if (!(step instanceof SideEffectCapable)) continue;
            merge = false;
        }
    }

    private boolean isMapStepMovable(Step<?, ?> step) {
        return step instanceof MapStep && StepOutputArityPredictor.hasAlwaysBoundResult(step);
    }

    private Step moveRangeStep(RangeGlobalStep step, Step insertAfter, Traversal.Admin<?, ?> traversal, boolean merge) {
        FilterStep rangeStep;
        boolean remove = true;
        if (insertAfter instanceof RangeGlobalStep) {
            long high;
            RangeGlobalStep other = (RangeGlobalStep)insertAfter;
            long low = other.getLowRange() + step.getLowRange();
            rangeStep = other.getHighRange() == -1L ? new RangeGlobalStep(traversal, low, other.getLowRange() + step.getHighRange()) : (step.getHighRange() == -1L ? (low < (high = other.getHighRange() - other.getLowRange() - step.getLowRange() + low) ? new RangeGlobalStep(traversal, low, high) : new DiscardStep(traversal)) : ((high = Math.min(other.getLowRange() + step.getHighRange(), other.getHighRange())) > low ? new RangeGlobalStep(traversal, low, high) : new DiscardStep(traversal)));
            remove = merge;
            TraversalHelper.replaceStep(merge ? insertAfter : step, rangeStep, traversal);
        } else if (!step.getPreviousStep().equals(insertAfter, true)) {
            rangeStep = step.clone();
            TraversalHelper.insertAfterStep(rangeStep, insertAfter, traversal);
        } else {
            return step;
        }
        if (remove) {
            traversal.removeStep(step);
        }
        return rangeStep;
    }

    public static EarlyLimitStrategy instance() {
        return INSTANCE;
    }
}

