/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.util.GremlinDisabledListDelimiterHandler;

public class TraversalStrategyVisitor
extends DefaultGremlinBaseVisitor<TraversalStrategy> {
    protected final GremlinAntlrToJava antlr;

    public TraversalStrategyVisitor(GremlinAntlrToJava antlrToJava) {
        this.antlr = antlrToJava;
    }

    @Override
    public TraversalStrategy visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            String strategyName = ctx.getChild(0).getText();
            return TraversalStrategyVisitor.tryToConstructStrategy(strategyName, this.getConfiguration(ctx.configuration()));
        }
        int childIndex = ctx.getChild(0).getText().equals("new") ? 1 : 0;
        String strategyName = ctx.getChild(childIndex).getText();
        return TraversalStrategyVisitor.tryToConstructStrategy(strategyName, this.getConfiguration(ctx.configuration()));
    }

    private Configuration getConfiguration(List<GremlinParser.ConfigurationContext> contexts) {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setListDelimiterHandler((ListDelimiterHandler)GremlinDisabledListDelimiterHandler.instance());
        if (null != contexts) {
            for (GremlinParser.ConfigurationContext ctx : contexts) {
                String key = ctx.getChild(0).getText();
                Object val = this.antlr.argumentVisitor.visitGenericLiteralArgument(ctx.genericLiteralArgument());
                conf.setProperty(key, val);
            }
        }
        return conf;
    }

    private static TraversalStrategy tryToConstructStrategy(String strategyName, Configuration conf) {
        Optional<? extends Class<? extends TraversalStrategy>> opt = TraversalStrategies.GlobalCache.getRegisteredStrategyClass(strategyName);
        if (!opt.isPresent()) {
            throw new IllegalStateException("TraversalStrategy not recognized - " + strategyName);
        }
        Class<? extends TraversalStrategy> clazz = opt.get();
        try {
            if (conf.isEmpty()) {
                try {
                    return (TraversalStrategy)clazz.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception ex) {
                    try {
                        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exinner) {
                        return (TraversalStrategy)clazz.getMethod("create", Configuration.class).invoke(null, conf);
                    }
                }
            }
            return (TraversalStrategy)clazz.getMethod("create", Configuration.class).invoke(null, conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException("TraversalStrategy not recognized - " + strategyName, ex);
        }
    }
}

