/**
 * @author Jorge Bay Gondra
 */
import { Graph } from '../structure/graph.js';
import Bytecode from './bytecode.js';
import { TraversalStrategies } from './traversal-strategy.js';
export declare class Traversal {
    graph: Graph | null;
    traversalStrategies: TraversalStrategies | null;
    bytecode: Bytecode;
    traversers: Traverser<any>[] | null;
    sideEffects?: any;
    private _traversalStrategiesPromise;
    private _traversersIteratorIndex;
    constructor(graph: Graph | null, traversalStrategies: TraversalStrategies | null, bytecode: Bytecode);
    /** @returns {Bytecode} */
    getBytecode(): Bytecode;
    /**
     * Returns an Array containing the traverser objects.
     * @returns {Promise.<Array>}
     */
    toList<T>(): Promise<T[]>;
    /**
     * Determines if there are any more items to iterate from the traversal.
     * @returns {Promise.<boolean>}
     */
    hasNext(): Promise<boolean | null>;
    /**
     * Iterates all Traverser instances in the traversal.
     * @returns {Promise}
     */
    iterate(): Promise<void>;
    /**
     * Async iterator method implementation.
     * Returns a promise containing an iterator item.
     * @returns {Promise.<{value, done}>}
     */
    next<T>(): Promise<IteratorResult<T, null>>;
    /**
     * Synchronous iterator of traversers including
     * @private
     */
    _getNext<T>(): IteratorResult<T, null>;
    _applyStrategies(): Promise<void>;
    /**
     * Returns step instructions during JSON serialization
     * @returns {Array}
     */
    toJSON(): any[];
    /**
     * Returns the Bytecode JSON representation of the traversal
     * @returns {String}
     */
    toString(): string;
}
export declare class IO {
    static get graphml(): string;
    static get graphson(): string;
    static get gryo(): string;
    static get reader(): string;
    static get registry(): string;
    static get writer(): string;
}
export declare class P<T1 = any, T2 = any> {
    operator: string;
    value: T1;
    other: T2;
    /**
     * Represents an operation.
     * @constructor
     */
    constructor(operator: string, value: T1, other: T2);
    /**
     * Returns the string representation of the instance.
     * @returns {string}
     */
    toString(): string;
    and(arg?: any): P<this, any>;
    or(arg?: any): P<this, any>;
    static within(...args: any[]): P<any[], null>;
    static without(...args: any[]): P<any[], null>;
    /** @param {...Object} args */
    static between(...args: any[]): any;
    /** @param {...Object} args */
    static eq(...args: any[]): any;
    /** @param {...Object} args */
    static gt(...args: any[]): any;
    /** @param {...Object} args */
    static gte(...args: any[]): any;
    /** @param {...Object} args */
    static inside(...args: any[]): any;
    /** @param {...Object} args */
    static lt(...args: any[]): any;
    /** @param {...Object} args */
    static lte(...args: any[]): any;
    /** @param {...Object} args */
    static neq(...args: any[]): any;
    /** @param {...Object} args */
    static not(...args: any[]): any;
    /** @param {...Object} args */
    static outside(...args: any[]): any;
    /** @param {...Object} args */
    static test(...args: any[]): any;
}
export declare class TextP<T1 = any, T2 = any> {
    operator: string;
    value: T1;
    other: T2;
    /**
     * Represents an operation.
     * @constructor
     */
    constructor(operator: string, value: T1, other: T2);
    /**
     * Returns the string representation of the instance.
     * @returns {string}
     */
    toString(): string;
    and(arg: any): P<this, any>;
    or(arg: any): P<this, any>;
    /** @param {...Object} args */
    static containing(...args: any[]): any;
    /** @param {...Object} args */
    static endingWith(...args: any[]): any;
    /** @param {...Object} args */
    static notContaining(...args: any[]): any;
    /** @param {...Object} args */
    static notEndingWith(...args: any[]): any;
    /** @param {...Object} args */
    static notStartingWith(...args: any[]): any;
    /** @param {...Object} args */
    static startingWith(...args: any[]): any;
    /** @param {...Object} args */
    static regex(...args: any[]): any;
    /** @param {...Object} args */
    static notRegex(...args: any[]): any;
}
export declare class Traverser<T = any> {
    object: T;
    bulk: number;
    constructor(object: T, bulk: number);
}
export declare class TraversalSideEffects {
}
export declare const withOptions: {
    tokens: string;
    none: number;
    ids: number;
    labels: number;
    keys: number;
    values: number;
    all: number;
    indexer: string;
    list: number;
    map: number;
};
export declare class EnumValue {
    typeName: string;
    elementName: string;
    constructor(typeName: string, elementName: string);
    toString(): string;
}
export declare const barrier: Record<string, EnumValue>;
export declare const cardinality: Record<string, EnumValue>;
export declare const column: Record<string, EnumValue>;
export declare const direction: Record<string, EnumValue>;
export declare const dt: Record<string, EnumValue>;
export declare const graphSONVersion: Record<string, EnumValue>;
export declare const gryoVersion: Record<string, EnumValue>;
export declare const merge: Record<string, EnumValue>;
export declare const operator: Record<string, EnumValue>;
export declare const order: Record<string, EnumValue>;
export declare const pick: Record<string, EnumValue>;
export declare const pop: Record<string, EnumValue>;
export declare const scope: Record<string, EnumValue>;
export declare const t: Record<string, EnumValue>;
