/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.GValueConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddElementStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.GValueHelper;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;

public abstract class AbstractAddElementStepPlaceholder<S, E extends Element, X extends Event>
extends ScalarMapStep<S, E>
implements AddElementStepContract<S, E>,
GValueHolder<S, E>,
Writing<X> {
    protected Object label;
    protected Map<Object, List<Object>> properties = new HashMap<Object, List<Object>>();
    protected Object elementId;
    protected Set<String> scopeKeys = new HashSet<String>();
    protected Parameters withConfiguration = new Parameters();

    protected AbstractAddElementStepPlaceholder(Traversal.Admin traversal, String label) {
        super(traversal);
        this.label = label == null ? this.getDefaultLabel() : label;
    }

    protected AbstractAddElementStepPlaceholder(Traversal.Admin traversal, GValue<String> label) {
        super(traversal);
        Object object = this.label = label == null ? this.getDefaultLabel() : label;
        if (label.isVariable()) {
            traversal.getGValueManager().register(label);
        }
    }

    protected AbstractAddElementStepPlaceholder(Traversal.Admin traversal, Traversal.Admin<S, String> labelTraversal) {
        super(traversal);
        Object object = this.label = labelTraversal == null ? this.getDefaultLabel() : labelTraversal;
        if (labelTraversal instanceof GValueConstantTraversal) {
            traversal.getGValueManager().register(((GValueConstantTraversal)labelTraversal).getGValue());
        }
        this.addTraversal(labelTraversal);
    }

    protected abstract String getDefaultLabel();

    @Override
    public Set<String> getScopeKeys() {
        return Collections.unmodifiableSet(this.scopeKeys);
    }

    protected void addTraversal(Traversal.Admin<?, ?> traversal) {
        this.integrateChild(traversal);
        TraversalHelper.getStepsOfAssignableClassRecursively(Scoping.class, traversal).forEach(s -> this.scopeKeys.addAll(s.getScopeKeys()));
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList childTraversals = new ArrayList();
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            if (entry.getKey() instanceof Traversal) {
                childTraversals.add(((Traversal)entry.getKey()).asAdmin());
            }
            for (Object value : entry.getValue()) {
                if (!(value instanceof Traversal)) continue;
                childTraversals.add(((Traversal)value).asAdmin());
            }
        }
        if (this.label != null && this.label instanceof Traversal) {
            childTraversals.add(((Traversal)this.label).asAdmin());
        }
        if (this.elementId != null && this.elementId instanceof Traversal) {
            childTraversals.add(((Traversal)this.elementId).asAdmin());
        }
        return childTraversals;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.getLocalChildren().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("GValuePlaceholder step is not executable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractAddElementStepPlaceholder that = (AbstractAddElementStepPlaceholder)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.properties, that.properties) && Objects.equals(this.elementId, that.elementId) && Objects.equals(this.scopeKeys, that.scopeKeys) && Objects.equals(this.withConfiguration, that.withConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.label, this.properties, this.elementId, this.scopeKeys, this.withConfiguration);
    }

    protected void configureConcreteStep(AddElementStepContract<S, E> step) {
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            for (Object value : entry.getValue()) {
                step.addProperty(entry.getKey(), value instanceof GValue ? ((GValue)value).get() : value);
            }
        }
        if (this.elementId != null) {
            step.setElementId(this.elementId instanceof GValue ? ((GValue)this.elementId).get() : this.elementId);
        }
        for (Map.Entry<Object, List<Object>> entry : this.withConfiguration.getRaw(new Object[0]).entrySet()) {
            for (Object value : entry.getValue()) {
                step.configure(entry.getKey(), value);
            }
        }
        TraversalHelper.copyLabels(this, step, false);
    }

    @Override
    public boolean isParameterized() {
        if (this.label instanceof GValue && ((GValue)this.label).isVariable() || this.elementId instanceof GValue && ((GValue)this.elementId).isVariable()) {
            return true;
        }
        for (List<Object> list : this.properties.values()) {
            if (!GValue.containsVariables(list.toArray())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getLabel() {
        if (this.label instanceof GValue) {
            this.traversal.getGValueManager().pinVariable(((GValue)this.label).getName());
            return ((GValue)this.label).get();
        }
        return this.label;
    }

    @Override
    public Object getLabelWithGValue() {
        return this.label;
    }

    @Override
    public void setLabel(Object label) {
        if (this.label.equals(this.getDefaultLabel())) {
            if (label instanceof Traversal) {
                this.label = ((Traversal)label).asAdmin();
                this.integrateChild((Traversal.Admin)this.label);
            } else if (label instanceof GValue) {
                this.label = label;
                this.traversal.getGValueManager().register((GValue)label);
            } else {
                this.label = label;
            }
        } else {
            throw new IllegalArgumentException(String.format("Element T.label has already been set to [%s] and cannot be overridden with [%s]", this.label, label));
        }
    }

    @Override
    public void addProperty(Object key, Object value) {
        List<Object> values;
        if (key instanceof GValue) {
            throw new IllegalArgumentException("GValue cannot be used as a property key");
        }
        if (key instanceof Traversal) {
            this.integrateChild(((Traversal)key).asAdmin());
        }
        if (value instanceof GValue) {
            this.traversal.getGValueManager().register((GValue)value);
        }
        if (key == T.label) {
            this.setLabel(value);
            return;
        }
        if (key == T.id) {
            this.setElementId(value);
            return;
        }
        if (!this.supportsMultiProperties() && this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Multi-properties are not supported by this step");
        }
        if (value instanceof Traversal) {
            this.integrateChild(((Traversal)value).asAdmin());
        }
        if ((values = this.properties.get(key)) == null) {
            values = new ArrayList<Object>();
            this.properties.put(key, values);
        }
        values.add(value);
    }

    protected abstract boolean supportsMultiProperties();

    @Override
    public Map<Object, List<Object>> getProperties() {
        return GValueHelper.resolveProperties(this.properties, gValue -> this.traversal.getGValueManager().pinVariable(gValue.getName()));
    }

    @Override
    public Map<Object, List<Object>> getPropertiesWithGValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.properties.containsKey(k)) {
            this.properties.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public Object getElementId() {
        if (this.elementId instanceof GValue) {
            this.traversal.getGValueManager().pinVariable(((GValue)this.elementId).getName());
            return ((GValue)this.elementId).get();
        }
        return this.elementId;
    }

    @Override
    public Object getElementIdWithGValue() {
        return this.elementId;
    }

    @Override
    public boolean removeElementId() {
        if (this.elementId == null) {
            return false;
        }
        this.elementId = null;
        return true;
    }

    @Override
    public void setElementId(Object elementId) {
        if (this.elementId != null) {
            throw new IllegalArgumentException(String.format("Element T.id has already been set to [%s] and cannot be overridden with [%s]", this.elementId, elementId));
        }
        if (elementId instanceof Traversal) {
            this.elementId = ((Traversal)elementId).asAdmin();
            this.integrateChild((Traversal.Admin)this.elementId);
        } else if (elementId instanceof GValue) {
            this.traversal.getGValueManager().register((GValue)elementId);
            this.elementId = elementId;
        } else {
            this.elementId = elementId;
        }
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (this.label instanceof GValue && name.equals(((GValue)this.label).getName())) {
            this.label = GValue.of(name, value);
        }
        if (this.elementId instanceof GValue && name.equals(((GValue)this.elementId).getName())) {
            this.elementId = GValue.of(name, value);
        }
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            for (Object propertyVal : entry.getValue()) {
                if (!(propertyVal instanceof GValue) || !name.equals(((GValue)propertyVal).getName())) continue;
                this.properties.put(entry.getKey(), Collections.singletonList(GValue.of(name, value)));
            }
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        Set<GValue<?>> gValues = GValueHelper.getGValuesFromProperties(this.properties);
        if (this.label instanceof GValue && ((GValue)this.label).isVariable()) {
            gValues.add((GValue)this.label);
        }
        if (this.elementId instanceof GValue && ((GValue)this.elementId).isVariable()) {
            gValues.add((GValue)this.elementId);
        }
        return gValues;
    }

    @Override
    public CallbackRegistry<X> getMutatingCallbackRegistry() {
        throw new IllegalStateException("Cannot get mutating CallbackRegistry on GValue placeholder step");
    }

    @Override
    public AbstractAddElementStepPlaceholder<S, E, X> clone() {
        AbstractAddElementStepPlaceholder clone = (AbstractAddElementStepPlaceholder)super.clone();
        if (this.label != null) {
            clone.label = this.label instanceof Traversal ? ((Traversal)this.label).asAdmin().clone() : (this.label instanceof GValue ? ((GValue)this.label).clone() : this.label);
        }
        if (this.elementId != null) {
            clone.elementId = this.elementId instanceof Traversal ? ((Traversal)this.elementId).asAdmin().clone() : (this.elementId instanceof GValue ? ((GValue)this.elementId).clone() : this.elementId);
        }
        clone.properties = new HashMap<Object, List<Object>>();
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            List<Object> oldValues = entry.getValue();
            ArrayList<Object> newValues = new ArrayList<Object>(oldValues.size());
            for (Object v : oldValues) {
                if (v instanceof Traversal) {
                    newValues.add(((Traversal)v).asAdmin().clone());
                    continue;
                }
                if (v instanceof GValue) {
                    newValues.add(((GValue)v).clone());
                    continue;
                }
                newValues.add(v);
            }
            clone.properties.put(key, newValues);
        }
        clone.scopeKeys = new HashSet<String>(this.scopeKeys);
        clone.withConfiguration = this.withConfiguration.clone();
        return clone;
    }

    @Override
    public Parameters getParameters() {
        return this.withConfiguration;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.withConfiguration.set(this, keyValues);
    }
}

