/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.corpus;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.javatuples.Pair;

public class FeatureReader {
    private static final Pattern generalParameterPattern = Pattern.compile("And using the parameter (.+) (defined as|of) (.*)");

    public static List<String> parseFlat(String featureDir) throws IOException {
        return FeatureReader.parseFlat(featureDir, Collections.emptyList());
    }

    public static List<String> parseFlat(String featureDir, List<Pair<Pattern, BiFunction<String, String, String>>> parameterMatchers) throws IOException {
        return FeatureReader.parseGrouped(featureDir, parameterMatchers).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static Map<String, List<String>> parseGrouped(String featureDir) throws IOException {
        return FeatureReader.parseGrouped(featureDir, Collections.emptyList());
    }

    public static Map<String, List<String>> parseGrouped(String featureDir, List<Pair<Pattern, BiFunction<String, String, String>>> parameterMatchers) throws IOException {
        LinkedHashMap<String, List<String>> gremlins = new LinkedHashMap<String, List<String>>();
        Files.find(Paths.get(featureDir, new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith(".feature"), new FileVisitOption[0]).sorted().forEach(f -> {
            Object currentGremlin = "";
            boolean openTriples = false;
            boolean skipIgnored = false;
            String scenarioName = "";
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                List<String> lines = Files.readAllLines(f, StandardCharsets.UTF_8);
                for (String line : lines) {
                    String cleanLine = line.trim();
                    if (cleanLine.startsWith("Scenario:")) {
                        scenarioName = cleanLine.split(":")[1].trim();
                        skipIgnored = false;
                        parameters.clear();
                        continue;
                    }
                    if (!parameterMatchers.isEmpty() && cleanLine.startsWith("And using the parameter")) {
                        Matcher m = generalParameterPattern.matcher(cleanLine);
                        if (m.matches()) {
                            parameters.put(m.group(1), FeatureReader.matchAndTransform(m.group(1), StringEscapeUtils.unescapeJava((String)m.group(3)), parameterMatchers));
                            continue;
                        }
                        throw new IllegalStateException(String.format("Could not read parameters at: %s", cleanLine));
                    }
                    if (cleanLine.contains("nothing should happen because") || cleanLine.contains("the result should be a tree with a structure of")) {
                        skipIgnored = true;
                        continue;
                    }
                    if (cleanLine.startsWith("And the graph should return")) {
                        gremlins.computeIfAbsent(scenarioName, k -> new ArrayList()).add(FeatureReader.applyParametersToGremlin(StringEscapeUtils.unescapeJava((String)cleanLine.substring(cleanLine.indexOf("\"") + 1, cleanLine.lastIndexOf("\""))), parameters));
                        continue;
                    }
                    if (cleanLine.startsWith("\"\"\"")) {
                        boolean bl = openTriples = !openTriples;
                        if (skipIgnored || openTriples) continue;
                        currentGremlin = FeatureReader.applyParametersToGremlin((String)currentGremlin, parameters);
                        gremlins.computeIfAbsent(scenarioName, k -> new ArrayList()).add(currentGremlin);
                        currentGremlin = "";
                        continue;
                    }
                    if (!openTriples || skipIgnored) continue;
                    currentGremlin = (String)currentGremlin + cleanLine;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        return gremlins;
    }

    private static String applyParametersToGremlin(String currentGremlin, Map<String, String> parameters) {
        ArrayList<String> paramNames = new ArrayList<String>(parameters.keySet());
        paramNames.sort((a, b) -> b.length() - a.length());
        for (String k : paramNames) {
            currentGremlin = currentGremlin.replace(k, parameters.get(k));
        }
        return currentGremlin;
    }

    private static String matchAndTransform(String k, String v, List<Pair<Pattern, BiFunction<String, String, String>>> parameterMatchers) {
        for (Pair<Pattern, BiFunction<String, String, String>> matcherConverter : parameterMatchers) {
            Pattern pattern = (Pattern)matcherConverter.getValue0();
            Matcher matcher = pattern.matcher(v);
            if (!matcher.find()) continue;
            BiFunction converter = (BiFunction)matcherConverter.getValue1();
            return (String)converter.apply(k, matcher.groupCount() == 0 ? "" : matcher.group(1));
        }
        return v;
    }
}

