/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.service;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.CollectionUtil;

public interface Service<I, R>
extends AutoCloseable {
    public Type getType();

    default public Set<TraverserRequirement> getRequirements() {
        return Collections.emptySet();
    }

    default public boolean isStart() {
        return this.getType() == Type.Start;
    }

    default public boolean isStreaming() {
        return this.getType() == Type.Streaming;
    }

    default public boolean isBarrier() {
        return this.getType() == Type.Barrier;
    }

    default public int getMaxBarrierSize() {
        return Integer.MAX_VALUE;
    }

    default public CloseableIterator<R> execute(ServiceCallContext ctx, Map params) {
        throw new UnsupportedOperationException("This service cannot be used to start a traversal.");
    }

    default public CloseableIterator<R> execute(ServiceCallContext ctx, Traverser.Admin<I> in, Map params) {
        throw new UnsupportedOperationException("This service does not support streaming execution.");
    }

    default public CloseableIterator<R> execute(ServiceCallContext ctx, TraverserSet<I> in, Map params) {
        throw new UnsupportedOperationException("This service does not support barrier execution.");
    }

    @Override
    default public void close() {
    }

    public static interface Exceptions {
        public static final String cannotStartTraversal = "This service cannot be used to start a traversal.";
        public static final String cannotUseMidTraversal = "This service cannot be used mid-traversal.";
        public static final String doesNotSupportStreaming = "This service does not support streaming execution.";
        public static final String doesNotSupportBarrier = "This service does not support barrier execution.";
        public static final String directoryStartOnly = "Directory service can only be used to start a traversal.";
    }

    public static class ServiceCallContext
    implements Cloneable {
        private final Traversal.Admin traversal;
        private final Step step;

        public ServiceCallContext(Traversal.Admin traversal, Step step) {
            this.traversal = traversal;
            this.step = step;
        }

        public Traversal.Admin getTraversal() {
            return this.traversal;
        }

        public Step getStep() {
            return this.step;
        }

        public <T> Traverser<T> generateTraverser(T value) {
            return this.traversal.getTraverserGenerator().generate(value, this.step, 1L);
        }

        public <T> Traverser.Admin<T> split(Traverser.Admin<T> t, T value) {
            return t.split(value, this.step);
        }

        public ServiceCallContext clone() {
            return new ServiceCallContext(this.traversal, this.step);
        }
    }

    public static interface DirectoryService<I>
    extends Service<I, String>,
    ServiceFactory {
        public static final String NAME = "--list";

        @Override
        default public String getName() {
            return NAME;
        }

        @Override
        default public Type getType() {
            return Type.Start;
        }

        @Override
        default public Set<Type> getSupportedTypes() {
            return Collections.singleton(Type.Start);
        }

        @Override
        default public Map describeParams() {
            return Params.describeParams;
        }

        default public Service createService(boolean isStart, Map params) {
            if (!isStart) {
                throw new UnsupportedOperationException("Directory service can only be used to start a traversal.");
            }
            return this;
        }

        @Override
        public CloseableIterator<String> execute(ServiceCallContext var1, Map var2);

        @Override
        default public void close() {
        }

        public static interface Params {
            public static final String SERVICE = "service";
            public static final String VERBOSE = "verbose";
            public static final Map describeParams = CollectionUtil.asMap("service", "The name of the service to describe", "verbose", "Flag to provide a detailed service description");
        }
    }

    public static enum Type {
        Start,
        Streaming,
        Barrier;

    }

    public static interface ServiceFactory<I, R>
    extends AutoCloseable {
        public String getName();

        public Set<Type> getSupportedTypes();

        default public Map describeParams() {
            return Collections.emptyMap();
        }

        default public Map<Type, Set<TraverserRequirement>> getRequirementsByType() {
            return Collections.emptyMap();
        }

        default public Set<TraverserRequirement> getRequirements(Type type) {
            return this.getRequirementsByType().getOrDefault((Object)type, Collections.emptySet());
        }

        public Service<I, R> createService(boolean var1, Map var2);

        @Override
        default public void close() {
        }
    }
}

