/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class Result {
    final Object resultObject;

    public Result(Object responseData) {
        this.resultObject = responseData;
    }

    public String getString() {
        return this.resultObject.toString();
    }

    public int getInt() {
        return Integer.parseInt(this.resultObject.toString());
    }

    public byte getByte() {
        return Byte.parseByte(this.resultObject.toString());
    }

    public short getShort() {
        return Short.parseShort(this.resultObject.toString());
    }

    public long getLong() {
        return Long.parseLong(this.resultObject.toString());
    }

    public float getFloat() {
        return Float.parseFloat(this.resultObject.toString());
    }

    public double getDouble() {
        return Double.parseDouble(this.resultObject.toString());
    }

    public boolean getBoolean() {
        return Boolean.parseBoolean(this.resultObject.toString());
    }

    public boolean isNull() {
        return null == this.resultObject;
    }

    public Vertex getVertex() {
        return (Vertex)this.resultObject;
    }

    public Edge getEdge() {
        return (Edge)this.resultObject;
    }

    public Element getElement() {
        return (Element)this.resultObject;
    }

    public Path getPath() {
        return (Path)this.resultObject;
    }

    public <V> Property<V> getProperty() {
        return (Property)this.resultObject;
    }

    public <V> VertexProperty<V> getVertexProperty() {
        return (VertexProperty)this.resultObject;
    }

    public <T> T get(Class<? extends T> clazz) {
        return clazz.cast(this.resultObject);
    }

    public Object getObject() {
        return this.resultObject;
    }

    public String toString() {
        String c = this.resultObject != null ? this.resultObject.getClass().getCanonicalName() : "null";
        return "result{object=" + this.resultObject + " class=" + c + "}";
    }
}

