(function() {
  define(["t5/core/dom", "t5/core/events", "t5/core/console", "t5/core/ajax"], function(dom, events, console, ajax) {
    var AFL_SELECTOR, FRAGMENT_TYPE;
    AFL_SELECTOR = "[data-container-type='core/AjaxFormLoop']";
    FRAGMENT_TYPE = "core/ajaxformloop-fragment";
    dom.onDocument("click", AFL_SELECTOR + " [data-afl-behavior=remove]", function() {
      var afl, url;
      afl = this.findParent(AFL_SELECTOR);
      if (!afl) {
        console.error("Enclosing element for AjaxFormLoop remove row link not found.");
        return false;
      }
      url = afl.attr("data-remove-row-url");
      ajax(url, {
        data: {
          "t:rowvalue": (this.closest("[data-afl-row-value]")).attr("data-afl-row-value")
        },
        success: (function(_this) {
          return function() {
            var fragment;
            fragment = _this.findParent("[data-container-type='" + FRAGMENT_TYPE + "']");
            return fragment.remove();
          };
        })(this)
      });
      return false;
    });
    dom.onDocument("click", AFL_SELECTOR + " [data-afl-behavior=insert-before] [data-afl-trigger=add]", function() {
      var afl, insertionPoint, url;
      afl = this.findParent(AFL_SELECTOR);
      insertionPoint = this.findParent("[data-afl-behavior=insert-before]");
      url = afl.attr("data-inject-row-url");
      ajax(url, {
        success: function(response) {
          var content, newElement, ref;
          content = ((ref = response.json) != null ? ref.content : void 0) || "";
          newElement = dom.create(insertionPoint.element.tagName, {
            'class': insertionPoint.element.className,
            'data-container-type': FRAGMENT_TYPE
          }, content);
          insertionPoint.insertBefore(newElement);
          newElement.trigger(events.initializeComponents);
          insertionPoint.trigger(events.zone.didUpdate);
        }
      });
      return false;
    });
  });

}).call(this);
