/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.services.UnknownActivationContextHandler;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.HttpError;
import org.apache.tapestry5.services.Traditional;
import org.slf4j.Logger;

public class UnknownActivationContextHandlerImpl
implements UnknownActivationContextHandler {
    private final Logger logger;
    private final ComponentEventResultProcessor resultProcessor;

    public UnknownActivationContextHandlerImpl(Logger logger, @Traditional @Primary ComponentEventResultProcessor resultProcessor) {
        this.logger = logger;
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void handleUnknownContext(ComponentResources pageResources, EventContext activationContext) throws IOException {
        this.logger.warn("Activate event on page {} was fired with context {} but was not handled", pageResources.getPage().getClass(), (Object)activationContext);
        String message = String.format("Activation context %s unrecognized for page %s", activationContext, pageResources.getPage().getClass());
        this.resultProcessor.processResultValue(new HttpError(404, message));
    }
}

