/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.jcache.module;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Advise;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.jcache.internal.CacheLookupUtil;
import org.apache.tapestry5.jcache.internal.CacheMethodAdvice;
import org.apache.tapestry5.jcache.internal.CachePutMethodAdvice;
import org.apache.tapestry5.jcache.internal.CacheRemoveAllMethodAdvice;
import org.apache.tapestry5.jcache.internal.CacheRemoveMethodAdvice;
import org.apache.tapestry5.jcache.internal.CacheResultMethodAdvice;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.DefaultCacheKeyGenerator;
import org.jsr107.ri.annotations.DefaultCacheResolverFactory;

public final class JCacheModule {
    private JCacheModule() {
    }

    public static void bind(ServiceBinder binder) {
        binder.bind(CacheKeyGenerator.class, DefaultCacheKeyGenerator.class);
        binder.bind(CacheResolverFactory.class, DefaultCacheResolverFactory.class);
        binder.bind(CacheContextSource.class, CacheLookupUtil.class);
    }

    @Match(value={"*"})
    @Advise(id="JCache")
    public static void adviseCache(MethodAdviceReceiver receiver, ObjectLocator objectLocator) {
        JCacheModule.advise(CachePut.class, objectLocator, CachePutMethodAdvice.class, receiver);
        JCacheModule.advise(CacheRemoveAll.class, objectLocator, CacheRemoveAllMethodAdvice.class, receiver);
        JCacheModule.advise(CacheRemove.class, objectLocator, CacheRemoveMethodAdvice.class, receiver);
        JCacheModule.advise(CacheResult.class, objectLocator, CacheResultMethodAdvice.class, receiver);
    }

    private static void advise(Class<? extends Annotation> annotationClass, ObjectLocator objectLocator, Class<? extends CacheMethodAdvice> adviceClass, MethodAdviceReceiver methodAdviceReceiver) {
        CacheMethodAdvice advice = null;
        if (methodAdviceReceiver.getClassAnnotationProvider().getAnnotation(annotationClass) != null) {
            advice = JCacheModule.build(objectLocator, adviceClass);
            methodAdviceReceiver.adviseAllMethods((MethodAdvice)advice);
        } else {
            for (Method method : methodAdviceReceiver.getInterface().getMethods()) {
                if (methodAdviceReceiver.getMethodAnnotation(method, annotationClass) == null) continue;
                if (advice == null) {
                    advice = JCacheModule.build(objectLocator, adviceClass);
                }
                methodAdviceReceiver.adviseMethod(method, (MethodAdvice)advice);
            }
        }
    }

    private static CacheMethodAdvice build(ObjectLocator objectLocator, Class<? extends CacheMethodAdvice> advice) {
        return (CacheMethodAdvice)objectLocator.autobuild(advice);
    }
}

