/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.http.CorsHandlerResult;
import org.apache.tapestry5.http.services.CorsHandler;
import org.apache.tapestry5.http.services.HttpServletRequestFilter;
import org.apache.tapestry5.http.services.HttpServletRequestHandler;
import org.apache.tapestry5.ioc.annotations.UsesOrderedConfiguration;

@UsesOrderedConfiguration(value=CorsHandler.class)
public class CorsHttpServletRequestFilter
implements HttpServletRequestFilter {
    final List<CorsHandler> handlers;

    public CorsHttpServletRequestFilter(List<CorsHandler> handlers) {
        this.handlers = new ArrayList<CorsHandler>(handlers);
    }

    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        CorsHandler corsHandler;
        CorsHandlerResult result;
        boolean serviced = false;
        Iterator<CorsHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext() && !(result = (corsHandler = iterator.next()).handle(request, response)).equals((Object)CorsHandlerResult.CONTINUE_REQUEST_PROCESSING)) {
            if (!result.equals((Object)CorsHandlerResult.STOP_REQUEST_PROCESSING)) continue;
            serviced = true;
            break;
        }
        if (!serviced) {
            serviced = handler.service(request, response);
        }
        return serviced;
    }
}

