/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import org.apache.tapestry5.dom.MarkupModel;

public abstract class AbstractMarkupModel
implements MarkupModel {
    private final boolean useApostropheForAttributes;
    private final char attributeQuoteChar;

    protected AbstractMarkupModel(boolean useApostropheForAttributes) {
        this.useApostropheForAttributes = useApostropheForAttributes;
        this.attributeQuoteChar = (char)(useApostropheForAttributes ? 39 : 34);
    }

    @Override
    public char getAttributeQuote() {
        return this.attributeQuoteChar;
    }

    @Override
    public String encode(String content) {
        int length = content.length();
        StringBuilder builder = null;
        block5: for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            switch (ch) {
                case '<': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&amp;");
                    continue block5;
                }
                default: {
                    if (builder == null) continue block5;
                    builder.append(ch);
                }
            }
        }
        return builder == null ? content : builder.toString();
    }

    @Override
    public void encodeQuoted(String content, StringBuilder builder) {
        assert (content != null);
        int length = content.length();
        int tokenStart = 0;
        builder.ensureCapacity(builder.length() + length);
        block7: for (int i = 0; i < length; ++i) {
            String delimiter;
            char ch = content.charAt(i);
            switch (ch) {
                case '<': {
                    delimiter = "&lt;";
                    break;
                }
                case '>': {
                    delimiter = "&gt;";
                    break;
                }
                case '&': {
                    delimiter = "&amp;";
                    break;
                }
                case '\"': {
                    if (this.useApostropheForAttributes) continue block7;
                    delimiter = "&quot;";
                    break;
                }
                case '\'': {
                    if (!this.useApostropheForAttributes) continue block7;
                    delimiter = "&#39;";
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if (tokenStart != i) {
                builder.append(content.subSequence(tokenStart, i));
            }
            builder.append(delimiter);
            tokenStart = i + 1;
        }
        if (tokenStart != length) {
            builder.append(content.subSequence(tokenStart, length));
        }
    }
}

