/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.IOException;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.OperationTrackerImpl;
import org.slf4j.Logger;

public class PerThreadOperationTracker
implements OperationTracker {
    private final Logger logger;
    private final ThreadLocal<OperationTrackerImpl> perThread = new ThreadLocal<OperationTrackerImpl>(){

        @Override
        protected OperationTrackerImpl initialValue() {
            return new OperationTrackerImpl(PerThreadOperationTracker.this.logger);
        }
    };

    public PerThreadOperationTracker(Logger logger) {
        this.logger = logger;
    }

    OperationTracker get() {
        return this.perThread.get();
    }

    void cleanup() {
        if (this.perThread.get().isEmpty()) {
            this.perThread.remove();
        }
    }

    @Override
    public void run(String description, Runnable operation) {
        try {
            this.get().run(description, operation);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        try {
            T t = this.get().invoke(description, operation);
            return t;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T perform(String description, IOOperation<T> operation) throws IOException {
        try {
            T t = this.get().perform(description, operation);
            return t;
        }
        finally {
            this.cleanup();
        }
    }
}

