/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.dom.CData;
import org.apache.tapestry5.dom.Comment;
import org.apache.tapestry5.dom.DTD;
import org.apache.tapestry5.dom.DefaultMarkupModel;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.dom.Node;
import org.apache.tapestry5.dom.Raw;
import org.apache.tapestry5.dom.Text;
import org.apache.tapestry5.dom.Visitor;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public final class Document
extends Node {
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private Element rootElement;
    private DTD dtd;
    private final MarkupModel model;
    private final String encoding;
    private final String mimeType;
    private List<Node> preamble;

    public Document(MarkupModel model) {
        this(model, null);
    }

    public Document(MarkupModel model, String encoding) {
        this(model, encoding, null);
    }

    public Document(MarkupModel model, String encoding, String mimeType) {
        super(null);
        assert (model != null);
        this.model = model;
        this.encoding = encoding;
        this.mimeType = mimeType;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    public Element find(String path) {
        String rootElementName;
        assert (InternalUtils.isNonBlank((String)path));
        if (this.rootElement == null) {
            return null;
        }
        int slashx = path.indexOf("/");
        String string = rootElementName = slashx < 0 ? path : path.substring(0, slashx);
        if (!this.rootElement.getName().equals(rootElementName)) {
            return null;
        }
        return slashx < 0 ? this.rootElement : this.rootElement.find(path.substring(slashx + 1));
    }

    public Document() {
        this(new DefaultMarkupModel());
    }

    public MarkupModel getMarkupModel() {
        return this.model;
    }

    public Element newRootElement(String name) {
        this.rootElement = new Element(this, null, name);
        return this.rootElement;
    }

    public Element newRootElement(String namespace, String name) {
        this.rootElement = new Element(this, namespace, name);
        return this.rootElement;
    }

    @Override
    public void toMarkup(Document document, PrintWriter writer, Map<String, String> namespaceURIToPrefix) {
        if (this.model.isXML()) {
            writer.print("<?xml version=\"1.0\"");
            if (this.encoding != null) {
                writer.printf(" encoding=\"%s\"", this.encoding);
            }
            writer.print("?>\n");
        }
        if (this.dtd != null) {
            this.dtd.toMarkup(writer);
        }
        if (this.preamble != null) {
            for (Node n : this.preamble) {
                n.toMarkup(this, writer, namespaceURIToPrefix);
            }
        }
        if (this.rootElement == null) {
            return;
        }
        Map initialNamespaceMap = CollectionFactory.newMap();
        initialNamespaceMap.put("xml", XML_NAMESPACE_URI);
        initialNamespaceMap.put("xmlns", XMLNS_NAMESPACE_URI);
        this.rootElement.toMarkup(document, writer, initialNamespaceMap);
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Element getElementById(String id) {
        return this.rootElement.getElementById(id);
    }

    public void dtd(String name, String publicId, String systemId) {
        this.dtd = new DTD(name, publicId, systemId);
    }

    public boolean hasDTD() {
        return this.dtd != null;
    }

    @Override
    protected Map<String, String> getNamespaceURIToPrefix() {
        if (this.rootElement == null) {
            return Collections.emptyMap();
        }
        return this.rootElement.getNamespaceURIToPrefix();
    }

    void visit(Visitor visitor) {
        this.rootElement.visit(visitor);
    }

    private <T extends Node> T newChild(T child) {
        if (this.preamble == null) {
            this.preamble = CollectionFactory.newList();
        }
        this.preamble.add(child);
        return child;
    }

    public Document comment(String text) {
        this.newChild(new Comment(null, text));
        return this;
    }

    public Document raw(String text) {
        this.newChild(new Raw(null, text));
        return this;
    }

    public Text text(String text) {
        return this.newChild(new Text(null, text));
    }

    public CData cdata(String content) {
        return this.newChild(new CData(null, content));
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

