/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.corelib.components.EventLink;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridModel;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;

@SupportsInformalParameters
public class GridColumns {
    @Parameter(value="componentResources.container")
    private GridModel gridModel;
    @Parameter
    private boolean lean;
    @Parameter(value="this")
    private PropertyOverrides overrides;
    @Parameter
    private String zone;
    @Component(parameters={"event=sort", "disabled=sortDisabled", "context=columnModel.id", "zone=inherit:zone"})
    private EventLink sort;
    @Inject
    private Messages messages;
    @Inject
    private Block standardHeader;
    @Parameter
    @Property
    private int index;
    private int lastColumnIndex;
    @Property(write=false)
    private PropertyModel columnModel;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;

    void setupRender() {
        this.lastColumnIndex = this.gridModel.getDataModel().getPropertyNames().size() - 1;
    }

    public boolean isSortDisabled() {
        return !this.columnModel.isSortable();
    }

    private ColumnSort getSortForColumn() {
        GridSortModel sortModel = this.gridModel.getSortModel();
        String columnId = this.columnModel.getId();
        return sortModel.getColumnSort(columnId);
    }

    void onBeginRenderFromLoop(MarkupWriter writer) {
        if (!this.lean) {
            writer.attributes("data-grid-property", this.columnModel.getId());
        }
        if (!this.isSortDisabled()) {
            switch (this.getSortForColumn()) {
                case ASCENDING: {
                    writer.attributes("data-grid-column-sort", "ascending");
                    break;
                }
                case DESCENDING: {
                    writer.attributes("data-grid-column-sort", "descending");
                }
                default: {
                    writer.attributes("data-grid-column-sort", "sortable");
                }
            }
        }
        if (this.index == 0) {
            writer.attributes("data-grid-column", "first");
        }
        if (this.index == this.lastColumnIndex) {
            writer.attributes("data-grid-column", "last");
        }
    }

    public boolean isActiveSortColumn() {
        return this.getSortForColumn() != ColumnSort.UNSORTED;
    }

    boolean onSort(String columnId) {
        this.gridModel.getSortModel().updateSort(columnId);
        if (this.request.isXHR()) {
            this.resources.triggerEvent("inplaceupdate", null, null);
        }
        return true;
    }

    public List<String> getColumnNames() {
        return this.gridModel.getDataModel().getPropertyNames();
    }

    public void setColumnName(String columnName) {
        this.columnModel = this.gridModel.getDataModel().get(columnName);
    }

    public Block getBlockForColumn() {
        Block override = this.overrides.getOverrideBlock(this.columnModel.getId() + "Header");
        if (override != null) {
            return override;
        }
        return this.standardHeader;
    }

    public String getInplaceGridLinks() {
        return this.zone == null ? null : "true";
    }
}

