/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.spark.CovarianceSPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CovarianceFEDInstruction
extends BinaryFEDInstruction {
    private CovarianceFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateBinary, op, in1, in2, in3, out, opcode, istr);
    }

    public static CovarianceFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        FEDInstruction.FederatedOutput fedOut = FEDInstruction.FederatedOutput.valueOf(parts[parts.length - 1]);
        String cleanInstStr = InstructionUtils.removeFEDOutputFlag(str);
        CovarianceFEDInstruction fedInst = CovarianceFEDInstruction.parseInstruction(CovarianceCPInstruction.parseInstruction(cleanInstStr));
        fedInst._fedOut = fedOut;
        return fedInst;
    }

    public static CovarianceFEDInstruction parseInstruction(CovarianceCPInstruction inst) {
        return new CovarianceFEDInstruction(inst.getOperator(), inst.input1, inst.input2, inst.input3, inst.output, inst.getOpcode(), inst.getInstructionString());
    }

    public static CovarianceFEDInstruction parseInstruction(CovarianceSPInstruction inst) {
        return new CovarianceFEDInstruction(inst.getOperator(), inst.input1, inst.input2, inst.input3, inst.output, inst.getOpcode(), inst.getInstructionString());
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        boolean weightsAligned;
        MatrixLineagePair weights;
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        MatrixObject mo2 = ec.getMatrixObject(this.input2);
        MatrixLineagePair matrixLineagePair = weights = this.input3 != null ? ec.getMatrixLineagePair(this.input3) : null;
        if (mo1.isFederated() && mo2.isFederated() && !mo1.getFedMapping().isAligned(mo2.getFedMapping(), false)) {
            throw new DMLRuntimeException("Not supported matrix-matrix binary operation: covariance.");
        }
        boolean moAligned = mo1.isFederated() && mo2.isFederated() && mo1.getFedMapping().isAligned(mo2.getFedMapping(), false);
        boolean bl = weightsAligned = weights == null || weights.isFederated() && mo2.isFederated() && weights.getFedMapping().isAligned(mo2.getFedMapping(), false);
        if (moAligned && weightsAligned) {
            this.processAlignedFedCov(ec, mo1, mo2, weights);
        } else if (moAligned) {
            this.processFedCovWeights(ec, mo1, mo2, weights);
        } else {
            this.processCov(ec, mo1, mo2);
        }
    }

    private void processAlignedFedCov(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2, MatrixLineagePair moLin3) {
        FederatedRequest fr1 = moLin3 == null ? FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()}) : FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID(), moLin3.getFedMapping().getID()});
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
        Double[] cov = CovarianceFEDInstruction.getResponses(mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3));
        Double[] mean1 = CovarianceFEDInstruction.getResponses(this.processMean(mo1, moLin3, 0));
        Double[] mean2 = CovarianceFEDInstruction.getResponses(this.processMean(mo2, moLin3, 1));
        if (moLin3 == null) {
            double result = CovarianceFEDInstruction.aggCov(cov, mean1, mean2, mo1.getFedMapping().getFederatedRanges());
            ec.setVariable(this.output.getName(), new DoubleObject(result));
        } else {
            Double[] weights = CovarianceFEDInstruction.getResponses(this.getWeightsSum(moLin3, moLin3.getFedMapping().getID(), this.instString, moLin3.getFedMapping()));
            double result = CovarianceFEDInstruction.aggWeightedCov(cov, mean1, mean2, weights);
            ec.setVariable(this.output.getName(), new DoubleObject(result));
        }
    }

    private void processFedCovWeights(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2, MatrixLineagePair moLin3) {
        FederatedRequest[] fr1 = mo1.getFedMapping().broadcastSliced(moLin3, false);
        String[] parts = this.instString.split("\u00b0");
        String covInstr = this.instString.replace(parts[4], String.valueOf(fr1[0].getID()) + "\u00b7MATRIX\u00b7FP64");
        FederatedRequest fr2 = FederationUtils.callInstruction(covInstr, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID(), fr1[0].getID()});
        FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
        FederatedRequest fr4 = mo1.getFedMapping().cleanup(this.getTID(), fr2.getID());
        Double[] cov = CovarianceFEDInstruction.getResponses(mo1.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2, fr3, fr4}));
        Double[] mean1 = CovarianceFEDInstruction.getResponses(this.processMean(mo1, 0, fr1[0].getID()));
        Double[] mean2 = CovarianceFEDInstruction.getResponses(this.processMean(mo2, 1, fr1[0].getID()));
        Double[] weights = CovarianceFEDInstruction.getResponses(this.getWeightsSum(moLin3, fr1[0].getID(), this.instString, mo1.getFedMapping()));
        double result = CovarianceFEDInstruction.aggWeightedCov(cov, mean1, mean2, weights);
        ec.setVariable(this.output.getName(), new DoubleObject(result));
    }

    private void processCov(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2) {
        MatrixBlock mb;
        MatrixObject mo;
        COVOperator cop = (COVOperator)this._optr;
        if (!mo1.isFederated() && mo2.isFederated()) {
            mo = mo2;
            mb = ec.getMatrixInput(this.input1.getName());
        } else {
            mo = mo1;
            mb = ec.getMatrixInput(this.input2.getName());
        }
        FederationMap fedMapping = mo.getFedMapping();
        ArrayList globalCmobj = new ArrayList();
        long varID = FederationUtils.getNextFedDataID();
        fedMapping.mapParallel(varID, (range, data) -> {
            try {
                Object wtBlock;
                FederatedResponse response;
                if (this.input3 == null) {
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new COVFunction(data.getVarID(), mb.slice(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1), cop))).get();
                } else {
                    wtBlock = ec.getMatrixInput(this.input3.getName());
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new COVWeightsFunction(data.getVarID(), mb.slice(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1), cop, ((MatrixBlock)wtBlock).slice(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1)))).get();
                }
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                wtBlock = globalCmobj;
                synchronized (wtBlock) {
                    globalCmobj.add((CM_COV_Object)response.getData()[0]);
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        Optional res = globalCmobj.stream().reduce((arg0, arg1) -> (CM_COV_Object)cop.fn.execute((Data)arg0, (Data)arg1));
        try {
            ec.setScalarOutput(this.output.getName(), new DoubleObject(((CM_COV_Object)res.get()).getRequiredResult(cop)));
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static Double[] getResponses(Future<FederatedResponse>[] ffr) {
        Double[] fr = new Double[ffr.length];
        IntStream.range(0, fr.length).forEach(i -> {
            try {
                fr[i] = ((ScalarObject)((FederatedResponse)ffr[i].get()).getData()[0]).getDoubleValue();
            }
            catch (Exception e) {
                throw new DMLRuntimeException("CovarianceFEDInstruction: incorrect means or cov.", e);
            }
        });
        return fr;
    }

    private static double aggCov(Double[] covValues, Double[] mean1, Double[] mean2, FederatedRange[] ranges) {
        long[] sizes = new long[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            sizes[i] = ranges[i].getSize();
        }
        double totalMeanX = 0.0;
        double totalMeanY = 0.0;
        int totalCount = 0;
        for (int i = 0; i < mean1.length; ++i) {
            totalMeanX += mean1[i] * (double)sizes[i];
            totalMeanY += mean2[i] * (double)sizes[i];
            totalCount = (int)((long)totalCount + sizes[i]);
        }
        totalMeanX /= (double)totalCount;
        totalMeanY /= (double)totalCount;
        double cov = 0.0;
        for (int i = 0; i < covValues.length; ++i) {
            cov += (double)(sizes[i] - 1L) * covValues[i];
            cov += (double)sizes[i] * (mean1[i] - totalMeanX) * (mean2[i] - totalMeanY);
        }
        return cov / (double)(totalCount - 1);
    }

    private static double aggWeightedCov(Double[] covValues, Double[] mean1, Double[] mean2, Double[] weights) {
        double totalWeightedMeanX = 0.0;
        double totalWeightedMeanY = 0.0;
        double totalWeight = 0.0;
        for (int i = 0; i < mean1.length; ++i) {
            totalWeight += weights[i].doubleValue();
            totalWeightedMeanX += mean1[i] * weights[i];
            totalWeightedMeanY += mean2[i] * weights[i];
        }
        totalWeightedMeanX /= totalWeight;
        totalWeightedMeanY /= totalWeight;
        double cov = 0.0;
        for (int i = 0; i < covValues.length; ++i) {
            cov += (weights[i] - 1.0) * covValues[i];
            cov += weights[i] * (mean1[i] - totalWeightedMeanX) * (mean2[i] - totalWeightedMeanY);
        }
        return cov / (totalWeight - 1.0);
    }

    private Future<FederatedResponse>[] processMean(MatrixObject mo1, MatrixLineagePair moLin3, int var) {
        String[] parts = this.instString.split("\u00b0");
        Future<FederatedResponse>[] meanTmp = null;
        if (moLin3 == null) {
            String meanInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("cov", "uamean"));
            meanInstr = meanInstr.replace((var == 0 ? parts[2] : parts[3]) + "\u00b0", "");
            meanInstr = meanInstr.replace(parts[4], parts[4].replace("FP64", "STRING\u00b016"));
            FederatedRequest meanFr1 = FederationUtils.callInstruction(meanInstr, this.output, new CPOperand[]{var == 0 ? this.input2 : this.input1}, new long[]{mo1.getFedMapping().getID()});
            FederatedRequest meanFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, meanFr1.getID());
            FederatedRequest meanFr3 = mo1.getFedMapping().cleanup(this.getTID(), meanFr1.getID());
            meanTmp = mo1.getFedMapping().execute(this.getTID(), meanFr1, meanFr2, meanFr3);
        } else {
            String multOutput = CovarianceFEDInstruction.incrementVar(parts[4], 1);
            String multInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("cov", "*")).replace((var == 0 ? parts[2] : parts[3]) + "\u00b0", "").replace(parts[5], multOutput);
            CPOperand multOutputCPOp = new CPOperand(multOutput.substring(0, multOutput.indexOf("\u00b7")), mo1.getValueType(), mo1.getDataType());
            FederatedRequest multFr = FederationUtils.callInstruction(multInstr, multOutputCPOp, new CPOperand[]{var == 0 ? this.input2 : this.input1, this.input3}, new long[]{mo1.getFedMapping().getID(), moLin3.getFedMapping().getID()});
            String[] partsMult = multInstr.split("\u00b0");
            String sumInstr1Output = CovarianceFEDInstruction.incrementVar(multOutput, 1).replace("m", "").replace("MATRIX", "SCALAR");
            String sumInstr1 = multInstr.replace(partsMult[1], "uak+").replace(partsMult[3] + "\u00b0", "").replace(partsMult[4], sumInstr1Output).replace(partsMult[2], multOutput);
            FederatedRequest sumFr1 = FederationUtils.callInstruction(sumInstr1, new CPOperand(sumInstr1Output.substring(0, sumInstr1Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{multOutputCPOp}, new long[]{multFr.getID()});
            String[] partsSum1 = sumInstr1.split("\u00b0");
            String sumInstr2Output = CovarianceFEDInstruction.incrementVar(sumInstr1Output, 1);
            String sumInstr2 = sumInstr1.replace(partsSum1[2], parts[4]).replace(partsSum1[3], sumInstr2Output);
            FederatedRequest sumFr2 = FederationUtils.callInstruction(sumInstr2, new CPOperand(sumInstr2Output.substring(0, sumInstr2Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{this.input3}, new long[]{moLin3.getFedMapping().getID()});
            String[] partsSum2 = sumInstr2.split("\u00b0");
            String divInstrOutput = CovarianceFEDInstruction.incrementVar(sumInstr2Output, 1);
            String divInstrInput1 = partsSum2[2].replace(partsSum2[2], sumInstr1Output + "\u00b7false");
            String divInstrInput2 = partsSum2[3].replace(partsSum2[3], sumInstr2Output + "\u00b7false");
            String divInstr = partsSum2[0] + "\u00b0" + partsSum2[1].replace("uak+", "/") + "\u00b0" + divInstrInput1 + "\u00b0" + divInstrInput2 + "\u00b0" + divInstrOutput + "\u00b0" + partsSum2[4];
            FederatedRequest divFr1 = FederationUtils.callInstruction(divInstr, new CPOperand(divInstrOutput.substring(0, divInstrOutput.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{new CPOperand(sumInstr1Output.substring(0, sumInstr1Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType(), this.output.isLiteral()), new CPOperand(sumInstr2Output.substring(0, sumInstr2Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType(), this.output.isLiteral())}, new long[]{sumFr1.getID(), sumFr2.getID()});
            FederatedRequest divFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, divFr1.getID());
            FederatedRequest divFr3 = mo1.getFedMapping().cleanup(this.getTID(), multFr.getID(), sumFr1.getID(), sumFr2.getID(), divFr1.getID(), divFr2.getID());
            meanTmp = mo1.getFedMapping().execute(this.getTID(), multFr, sumFr1, sumFr2, divFr1, divFr2, divFr3);
        }
        return meanTmp;
    }

    private Future<FederatedResponse>[] processMean(MatrixObject mo1, int var, long weightsID) {
        String[] parts = this.instString.split("\u00b0");
        Future<FederatedResponse>[] meanTmp = null;
        String multOutput = var == 0 ? CovarianceFEDInstruction.incrementVar(parts[2], 5) : CovarianceFEDInstruction.incrementVar(parts[3], 3);
        String multInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("cov", "*")).replace((var == 0 ? parts[2] : parts[3]) + "\u00b0", "").replace(parts[4], String.valueOf(weightsID) + "\u00b7MATRIX\u00b7FP64").replace(parts[5], multOutput);
        CPOperand multOutputCPOp = new CPOperand(multOutput.substring(0, multOutput.indexOf("\u00b7")), mo1.getValueType(), mo1.getDataType());
        FederatedRequest multFr = FederationUtils.callInstruction(multInstr, multOutputCPOp, new CPOperand[]{var == 0 ? this.input2 : this.input1, this.input3}, new long[]{mo1.getFedMapping().getID(), weightsID});
        String[] partsMult = multInstr.split("\u00b0");
        String sumInstr1Output = CovarianceFEDInstruction.incrementVar(multOutput, 1).replace("m", "").replace("MATRIX", "SCALAR");
        String sumInstr1 = multInstr.replace(partsMult[1], "uak+").replace(partsMult[3] + "\u00b0", "").replace(partsMult[4], sumInstr1Output).replace(partsMult[2], multOutput);
        FederatedRequest sumFr1 = FederationUtils.callInstruction(sumInstr1, new CPOperand(sumInstr1Output.substring(0, sumInstr1Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{multOutputCPOp}, new long[]{multFr.getID()});
        String[] partsSum1 = sumInstr1.split("\u00b0");
        String sumInstr2Output = CovarianceFEDInstruction.incrementVar(sumInstr1Output, 1);
        String sumInstr2 = sumInstr1.replace(partsSum1[2], String.valueOf(weightsID) + "\u00b7MATRIX\u00b7FP64").replace(partsSum1[3], sumInstr2Output);
        FederatedRequest sumFr2 = FederationUtils.callInstruction(sumInstr2, new CPOperand(sumInstr2Output.substring(0, sumInstr2Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{this.input3}, new long[]{weightsID});
        String[] partsSum2 = sumInstr2.split("\u00b0");
        String divInstrOutput = CovarianceFEDInstruction.incrementVar(sumInstr2Output, 1);
        String divInstrInput1 = partsSum2[2].replace(partsSum2[2], sumInstr1Output + "\u00b7false");
        String divInstrInput2 = partsSum2[3].replace(partsSum2[3], sumInstr2Output + "\u00b7false");
        String divInstr = partsSum2[0] + "\u00b0" + partsSum2[1].replace("uak+", "/") + "\u00b0" + divInstrInput1 + "\u00b0" + divInstrInput2 + "\u00b0" + divInstrOutput + "\u00b0" + partsSum2[4];
        FederatedRequest divFr1 = FederationUtils.callInstruction(divInstr, new CPOperand(divInstrOutput.substring(0, divInstrOutput.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{new CPOperand(sumInstr1Output.substring(0, sumInstr1Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType(), this.output.isLiteral()), new CPOperand(sumInstr2Output.substring(0, sumInstr2Output.indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType(), this.output.isLiteral())}, new long[]{sumFr1.getID(), sumFr2.getID()});
        FederatedRequest divFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, divFr1.getID());
        FederatedRequest divFr3 = mo1.getFedMapping().cleanup(this.getTID(), multFr.getID(), sumFr1.getID(), sumFr2.getID(), divFr1.getID(), divFr2.getID());
        meanTmp = mo1.getFedMapping().execute(this.getTID(), multFr, sumFr1, sumFr2, divFr1, divFr2, divFr3);
        return meanTmp;
    }

    private Future<FederatedResponse>[] getWeightsSum(MatrixLineagePair moLin3, long weightsID, String instString, FederationMap fedMap) {
        Future<FederatedResponse>[] weightsSumTmp = null;
        String[] parts = instString.split("\u00b0");
        if (!instString.contains("pREADW")) {
            String sumInstr = "CP\u00b0uak+\u00b0" + parts[4] + "\u00b0" + parts[5] + "\u00b0" + parts[6];
            FederatedRequest sumFr = FederationUtils.callInstruction(sumInstr, new CPOperand(parts[5].substring(0, parts[5].indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{this.input3}, new long[]{weightsID});
            FederatedRequest sumFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, sumFr.getID());
            FederatedRequest sumFr3 = moLin3.getFedMapping().cleanup(this.getTID(), sumFr.getID());
            weightsSumTmp = fedMap.execute(this.getTID(), sumFr, sumFr2, sumFr3);
        } else {
            String sumInstr = "CP\u00b0uak+\u00b0" + String.valueOf(weightsID) + "\u00b7MATRIX\u00b7FP64\u00b0" + parts[5] + "\u00b0" + parts[6];
            FederatedRequest sumFr = FederationUtils.callInstruction(sumInstr, new CPOperand(parts[5].substring(0, parts[5].indexOf("\u00b7")), this.output.getValueType(), this.output.getDataType()), new CPOperand[]{this.input3}, new long[]{weightsID});
            FederatedRequest sumFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, sumFr.getID());
            FederatedRequest sumFr3 = fedMap.cleanup(this.getTID(), sumFr.getID());
            weightsSumTmp = fedMap.execute(this.getTID(), sumFr, sumFr2, sumFr3);
        }
        return weightsSumTmp;
    }

    private static String incrementVar(String str, int inc) {
        StringBuilder strOut = new StringBuilder(str);
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(strOut);
        if (matcher.find()) {
            int num = Integer.parseInt(matcher.group()) + inc;
            int start = matcher.start();
            int end = matcher.end();
            strOut.replace(start, end, String.valueOf(num));
        }
        return strOut.toString();
    }

    private static class COVWeightsFunction
    extends FederatedUDF {
        private static final long serialVersionUID = -1768739786192949573L;
        private final COVOperator _op;
        private final MatrixBlock _mo2;
        private final MatrixBlock _weights;

        protected COVWeightsFunction(long input, MatrixBlock mo2, COVOperator op, MatrixBlock weights) {
            super(new long[]{input});
            this._mo2 = mo2;
            this._op = op;
            this._weights = weights;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.covOperations(this._op, this._mo2, this._weights));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class COVFunction
    extends FederatedUDF {
        private static final long serialVersionUID = -501036588060113499L;
        private final MatrixBlock _mo2;
        private final COVOperator _op;

        public COVFunction(long input, MatrixBlock mo2, COVOperator op) {
            super(new long[]{input});
            this._op = op;
            this._mo2 = mo2;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.covOperations(this._op, this._mo2));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

