/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class FrameFromMatrixBlock {
    protected static final Log LOG = LogFactory.getLog((String)FrameFromMatrixBlock.class.getName());
    private final MatrixBlock mb;
    private final Types.ValueType[] schema;
    private final FrameBlock frame;
    private final int blocksizeIJ = 32;
    private final int blocksizeParallel = 64;
    private final int m;
    private final int n;
    private final int k;
    private final ExecutorService pool;

    private FrameFromMatrixBlock(MatrixBlock mb, Types.ValueType[] schema, int k) {
        this.mb = mb;
        this.m = mb.getNumRows();
        this.n = mb.getNumColumns();
        this.schema = schema == null ? FrameFromMatrixBlock.getSchema(mb) : schema;
        this.frame = new FrameBlock(this.schema);
        this.k = k;
        this.pool = k > 1 ? CommonThreadPool.get(k) : null;
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, int k) {
        return new FrameFromMatrixBlock(mb, null, k).apply();
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Types.ValueType vt, int k) {
        return new FrameFromMatrixBlock(mb, UtilFunctions.nCopies(mb.getNumColumns(), vt), k).apply();
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Types.ValueType[] schema, int k) {
        return new FrameFromMatrixBlock(mb, schema, k).apply();
    }

    private static Types.ValueType[] getSchema(MatrixBlock mb) {
        int nCol = mb.getNumColumns();
        int nRow = mb.getNumRows();
        Types.ValueType[] schema = UtilFunctions.nCopies(nCol, Types.ValueType.BOOLEAN);
        for (int c = 0; c < nCol; ++c) {
            block4: for (int r = 0; r < nRow; ++r) {
                switch (schema[c]) {
                    case FP64: {
                        continue block4;
                    }
                    default: {
                        schema[c] = FrameUtil.isType(mb.get(r, c), schema[c]);
                    }
                }
            }
        }
        return schema;
    }

    private FrameBlock apply() {
        try {
            if (this.mb.isEmpty()) {
                this.convertToEmptyFrameBlock();
            } else if (this.mb.isInSparseFormat()) {
                this.convertToFrameBlockSparse();
            } else {
                this.convertToFrameBlockDense();
            }
            FrameBlock frameBlock = this.frame;
            return frameBlock;
        }
        catch (Exception e) {
            throw new DMLRuntimeException("failed to convert to matrix block", e);
        }
        finally {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    private void convertToEmptyFrameBlock() {
        this.frame.ensureAllocatedColumns(this.mb.getNumRows());
    }

    private void convertToFrameBlockSparse() {
        int i;
        SparseBlock sblock = this.mb.getSparseBlock();
        Array[] columns = new Array[this.mb.getNumColumns()];
        for (i = 0; i < columns.length; ++i) {
            columns[i] = ArrayFactory.allocate(this.schema[i], this.mb.getNumRows());
        }
        for (i = 0; i < this.mb.getNumRows(); ++i) {
            if (sblock.isEmpty(i)) continue;
            int apos = sblock.pos(i);
            int alen = sblock.size(i);
            int[] aix = sblock.indexes(i);
            double[] aval = sblock.values(i);
            for (int j = apos; j < apos + alen; ++j) {
                columns[aix[j]].set(i, aval[j]);
            }
        }
        this.frame.reset();
        for (i = 0; i < columns.length; ++i) {
            this.frame.appendColumn(columns[i]);
        }
    }

    private void convertToFrameBlockDense() throws InterruptedException, ExecutionException {
        int dFreq = UtilFunctions.frequency(this.schema, Types.ValueType.FP64);
        if (this.schema.length == 1) {
            if (dFreq == 1) {
                this.convertToFrameDenseSingleColDouble();
            } else {
                this.convertToFrameDenseSingleColOther(this.schema[0]);
            }
        } else if (dFreq == this.schema.length) {
            this.convertToFrameDenseMultiColDouble();
        } else {
            this.convertToFrameDenseMultiColGeneric();
        }
    }

    private void convertToFrameDenseSingleColDouble() {
        this.frame.reset();
        this.frame.appendColumn(this.mb.getDenseBlockValues());
    }

    private void convertToFrameDenseSingleColOther(Types.ValueType vt) {
        DoubleArray d = ArrayFactory.create(this.mb.getDenseBlockValues());
        this.frame.reset();
        this.frame.appendColumn(d.changeType(vt));
    }

    private void convertToFrameDenseMultiColDouble() throws InterruptedException, ExecutionException {
        double[][] c = this.mb.getDenseBlock().isContiguous() ? this.convertToFrameDenseMultiColContiguous() : this.convertToFrameDenseMultiColMultiBlock();
        this.frame.reset();
        this.frame.appendColumns(c);
    }

    private double[][] convertToFrameDenseMultiColContiguous() throws InterruptedException, ExecutionException {
        return this.k == 1 ? this.convertToFrameDenseMultiColContiguousSingleThread() : this.convertToFrameDenseMultiColContiguousMultiThread();
    }

    private double[][] convertToFrameDenseMultiColContiguousSingleThread() {
        double[][] c = new double[this.n][this.m];
        double[] a = this.mb.getDenseBlockValues();
        for (int bi = 0; bi < this.m; bi += 32) {
            for (int bj = 0; bj < this.n; bj += 32) {
                int bimin = Math.min(bi + 32, this.m);
                int bjmin = Math.min(bj + 32, this.n);
                int i = bi;
                int aix = bi * this.n;
                while (i < bimin) {
                    for (int j = bj; j < bjmin; ++j) {
                        c[j][i] = a[aix + j];
                    }
                    ++i;
                    aix += this.n;
                }
            }
        }
        return c;
    }

    private double[][] convertToFrameDenseMultiColContiguousMultiThread() throws InterruptedException, ExecutionException {
        double[][] c = new double[this.n][this.m];
        ArrayList<CVB> tasks = new ArrayList<CVB>();
        for (int bi = 0; bi < this.m; bi += 64) {
            for (int bj = 0; bj < this.n; bj += 64) {
                tasks.add(new CVB(bi, bj, c));
            }
        }
        for (Future rt : this.pool.invokeAll(tasks)) {
            rt.get();
        }
        return c;
    }

    private double[][] convertToFrameDenseMultiColMultiBlock() throws InterruptedException, ExecutionException {
        return this.k == 1 ? this.convertToFrameDenseMultiColMultiBlockSingleThread() : this.convertToFrameDenseMultiColMultiBlockMultiThread();
    }

    private double[][] convertToFrameDenseMultiColMultiBlockSingleThread() {
        double[][] c = new double[this.n][this.m];
        DenseBlock a = this.mb.getDenseBlock();
        for (int bi = 0; bi < this.m; bi += 32) {
            for (int bj = 0; bj < this.n; bj += 32) {
                int bimin = Math.min(bi + 32, this.m);
                int bjmin = Math.min(bj + 32, this.n);
                for (int i = bi; i < bimin; ++i) {
                    double[] avals = a.values(i);
                    int apos = a.pos(i);
                    for (int j = bj; j < bjmin; ++j) {
                        c[j][i] = avals[apos + j];
                    }
                }
            }
        }
        return c;
    }

    private double[][] convertToFrameDenseMultiColMultiBlockMultiThread() throws InterruptedException, ExecutionException {
        double[][] c = new double[this.n][this.m];
        ArrayList<CVMB> tasks = new ArrayList<CVMB>();
        for (int bi = 0; bi < this.m; bi += 64) {
            for (int bj = 0; bj < this.n; bj += 64) {
                tasks.add(new CVMB(bi, bj, c));
            }
        }
        for (Future rt : this.pool.invokeAll(tasks)) {
            rt.get();
        }
        return c;
    }

    private void convertToFrameDenseMultiColGeneric() throws InterruptedException, ExecutionException {
        Array<?>[] c = this.mb.getDenseBlock().isContiguous() ? this.convertToFrameDenseMultiColGenericContiguous() : this.convertToFrameDenseMultiColGenericMultiBlock();
        this.frame.reset();
        for (Array<?> col : c) {
            this.frame.appendColumn(col);
        }
    }

    private Array<?>[] convertToFrameDenseMultiColGenericContiguous() throws InterruptedException, ExecutionException {
        return this.k == 1 ? this.convertToFrameDenseMultiColGenericContiguousSingleThread() : this.convertToFrameDenseMultiColGenericContiguousMultiThread();
    }

    private Array<?>[] convertToFrameDenseMultiColGenericContiguousSingleThread() {
        Array[] c = new Array[this.n];
        for (int i = 0; i < this.n; ++i) {
            c[i] = ArrayFactory.allocate(this.schema[i], this.m);
        }
        double[] a = this.mb.getDenseBlockValues();
        for (int bi = 0; bi < this.m; bi += 32) {
            for (int bj = 0; bj < this.n; bj += 32) {
                int bimin = Math.min(bi + 32, this.m);
                int bjmin = Math.min(bj + 32, this.n);
                int i = bi;
                int aix = bi * this.n;
                while (i < bimin) {
                    for (int j = bj; j < bjmin; ++j) {
                        c[j].set(i, a[aix + j]);
                    }
                    ++i;
                    aix += this.n;
                }
            }
        }
        return c;
    }

    private Array<?>[] convertToFrameDenseMultiColGenericContiguousMultiThread() throws InterruptedException, ExecutionException {
        Array[] c = new Array[this.n];
        for (int i = 0; i < this.n; ++i) {
            c[i] = ArrayFactory.allocate(this.schema[i], this.m);
        }
        ArrayList<CVTAB> tasks = new ArrayList<CVTAB>();
        for (int bi = 0; bi < this.m; bi += 64) {
            for (int bj = 0; bj < this.n; bj += 64) {
                tasks.add(new CVTAB(bi, bj, c));
            }
        }
        for (Future rt : this.pool.invokeAll(tasks)) {
            rt.get();
        }
        return c;
    }

    private Array<?>[] convertToFrameDenseMultiColGenericMultiBlock() {
        Array[] c = new Array[this.n];
        for (int i = 0; i < this.n; ++i) {
            c[i] = ArrayFactory.allocate(this.schema[i], this.m);
        }
        DenseBlock a = this.mb.getDenseBlock();
        for (int bi = 0; bi < this.m; bi += 32) {
            for (int bj = 0; bj < this.n; bj += 32) {
                int bimin = Math.min(bi + 32, this.m);
                int bjmin = Math.min(bj + 32, this.n);
                for (int i = bi; i < bimin; ++i) {
                    double[] avals = a.values(i);
                    int apos = a.pos(i);
                    for (int j = bj; j < bjmin; ++j) {
                        c[j].set(i, avals[apos + j]);
                    }
                }
            }
        }
        return c;
    }

    protected class CVTAB
    implements Callable<Object> {
        private final int bi;
        private final int bj;
        private final Array<?>[] c;

        protected CVTAB(int bi, int bj, Array<?>[] c) {
            this.bi = bi;
            this.bj = bj;
            this.c = c;
        }

        @Override
        public Object call() {
            double[] a = FrameFromMatrixBlock.this.mb.getDenseBlockValues();
            int bimin = Math.min(this.bi + 64, FrameFromMatrixBlock.this.m);
            int bjmin = Math.min(this.bj + 64, FrameFromMatrixBlock.this.n);
            int i = this.bi;
            int aix = this.bi * FrameFromMatrixBlock.this.n;
            while (i < bimin) {
                for (int j = this.bj; j < bjmin; ++j) {
                    this.c[j].set(i, a[aix + j]);
                }
                ++i;
                aix += FrameFromMatrixBlock.this.n;
            }
            return null;
        }
    }

    protected class CVMB
    implements Callable<Object> {
        private final int bi;
        private final int bj;
        private final double[][] c;

        protected CVMB(int bi, int bj, double[][] c) {
            this.bi = bi;
            this.bj = bj;
            this.c = c;
        }

        @Override
        public Object call() {
            DenseBlock a = FrameFromMatrixBlock.this.mb.getDenseBlock();
            int bimin = Math.min(this.bi + 64, FrameFromMatrixBlock.this.m);
            int bjmin = Math.min(this.bj + 64, FrameFromMatrixBlock.this.n);
            for (int i = this.bi; i < bimin; ++i) {
                double[] avals = a.values(i);
                int apos = a.pos(i);
                for (int j = this.bj; j < bjmin; ++j) {
                    this.c[j][i] = avals[apos + j];
                }
            }
            return null;
        }
    }

    protected class CVB
    implements Callable<Object> {
        private final int bi;
        private final int bj;
        private final double[][] c;

        protected CVB(int bi, int bj, double[][] c) {
            this.bi = bi;
            this.bj = bj;
            this.c = c;
        }

        @Override
        public Object call() {
            double[] a = FrameFromMatrixBlock.this.mb.getDenseBlockValues();
            int bimin = Math.min(this.bi + 64, FrameFromMatrixBlock.this.m);
            int bjmin = Math.min(this.bj + 64, FrameFromMatrixBlock.this.n);
            int i = this.bi;
            int aix = this.bi * FrameFromMatrixBlock.this.n;
            while (i < bimin) {
                for (int j = this.bj; j < bjmin; ++j) {
                    this.c[j][i] = a[aix + j];
                }
                ++i;
                aix += FrameFromMatrixBlock.this.n;
            }
            return null;
        }
    }
}

