/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ApplicationStatus;
import org.apache.spark.status.api.v1.SimpleDateParam;
import org.apache.spark.status.api.v1.UIRoot;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005}a!\u0002\u0003\u0006\u0001\u0015\t\u0002\"\u0002\u000f\u0001\t\u0003q\u0002\"\u0002\u0011\u0001\t\u0003\t\u0003\"\u0002<\u0001\t\u00139(aF!qa2L7-\u0019;j_:d\u0015n\u001d;SKN|WO]2f\u0015\t1q!\u0001\u0002wc)\u0011\u0001\"C\u0001\u0004CBL'B\u0001\u0006\f\u0003\u0019\u0019H/\u0019;vg*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xmE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005)\u0011BA\u000e\u0006\u0005E\t\u0005/\u001b*fcV,7\u000f^\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0004\u0005\u0002\u001a\u0001\u00059\u0011\r\u001d9MSN$Hc\u0002\u00122\u0015^s6\r\u001b\t\u0004G-rcB\u0001\u0013*\u001d\t)\u0003&D\u0001'\u0015\t9S$\u0001\u0004=e>|GOP\u0005\u0002+%\u0011!\u0006F\u0001\ba\u0006\u001c7.Y4f\u0013\taSF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tQC\u0003\u0005\u0002\u001a_%\u0011\u0001'\u0002\u0002\u0010\u0003B\u0004H.[2bi&|g.\u00138g_\")!B\u0001a\u0001eA\u00191\u0007\u000f\u001e\u000e\u0003QR!!\u000e\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0003MSN$\bCA\r<\u0013\taTAA\tBaBd\u0017nY1uS>t7\u000b^1ukNDC!\r I\u0013B\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003eNT!a\u0011#\u0002\u0005]\u001c(\"A#\u0002\u000b)\fg/\u0019=\n\u0005\u001d\u0003%AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\n!\u0002C\u0003L\u0005\u0001\u0007A*A\u0004nS:$\u0015\r^3\u0011\u0005ei\u0015B\u0001(\u0006\u0005=\u0019\u0016.\u001c9mK\u0012\u000bG/\u001a)be\u0006l\u0007\u0006\u0002&?\u0011B\u000b\u0013a\u0013\u0015\u0005\u0015JCU\u000b\u0005\u0002@'&\u0011A\u000b\u0011\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0002-\u0006Q!\u0007M\u00191[A\nT\u0006M\u0019\t\u000ba\u0013\u0001\u0019\u0001'\u0002\u000f5\f\u0007\u0010R1uK\"\"qK\u0010%[C\u0005A\u0006\u0006B,S\u0011r\u000b\u0013!X\u0001\u000bgA\u0002\u0004'\f\u00192[A\n\u0004\"B0\u0003\u0001\u0004a\u0015AC7j]\u0016sG\rR1uK\"\"aL\u0010%bC\u0005y\u0006\u0006\u00020S\u0011VCQ\u0001\u001a\u0002A\u00021\u000b!\"\\1y\u000b:$G)\u0019;fQ\u0011\u0019g\b\u00134\"\u0003\u0011DCa\u0019*I9\")\u0011N\u0001a\u0001U\u0006)A.[7jiB\u00111N\\\u0007\u0002Y*\u0011QNN\u0001\u0005Y\u0006tw-\u0003\u0002pY\n9\u0011J\u001c;fO\u0016\u0014\b\u0006\u00025?\u0011F\f\u0013!\u001b\u0015\u0003\u0005M\u0004\"a\u0010;\n\u0005U\u0004%aA$F)\u0006\u0001\u0012n]!ui\u0016l\u0007\u000f^%o%\u0006tw-\u001a\u000b\rqn\f\t!!\u0002\u0002\n\u0005-\u0011Q\u0002\t\u0003'eL!A\u001f\u000b\u0003\u000f\t{w\u000e\\3b]\")Ap\u0001a\u0001{\u00069\u0011\r\u001e;f[B$\bCA\r\u007f\u0013\tyXA\u0001\fBaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018J\u001c4p\u0011\u0019\t\u0019a\u0001a\u0001\u0019\u0006aQ.\u001b8Ti\u0006\u0014H\u000fR1uK\"1\u0011qA\u0002A\u00021\u000bA\"\\1y'R\f'\u000f\u001e#bi\u0016DQaX\u0002A\u00021CQ\u0001Z\u0002A\u00021Ca!a\u0004\u0004\u0001\u0004A\u0018AC1osJ+hN\\5oO\"2\u0001!a\u0005I\u00033\u00012aPA\u000b\u0013\r\t9\u0002\u0011\u0002\t!J|G-^2fg2\u0012\u00111D\u0011\u0003\u0003;\t\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8")
public class ApplicationListResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Iterator<ApplicationInfo> appList(@QueryParam(value="status") List<ApplicationStatus> status, @DefaultValue(value="2010-01-01") @QueryParam(value="minDate") SimpleDateParam minDate, @DefaultValue(value="3000-01-01") @QueryParam(value="maxDate") SimpleDateParam maxDate, @DefaultValue(value="2010-01-01") @QueryParam(value="minEndDate") SimpleDateParam minEndDate, @DefaultValue(value="3000-01-01") @QueryParam(value="maxEndDate") SimpleDateParam maxEndDate, @QueryParam(value="limit") Integer limit) {
        int numApps = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limit).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        boolean includeCompleted = status.isEmpty() || status.contains((Object)ApplicationStatus.COMPLETED);
        boolean includeRunning = status.isEmpty() || status.contains((Object)ApplicationStatus.RUNNING);
        return this.uiRoot().getApplicationInfoList().filter((Function1 & Serializable & scala.Serializable)app -> BoxesRunTime.boxToBoolean((boolean)ApplicationListResource.$anonfun$appList$3(this, includeCompleted, includeRunning, minDate, maxDate, minEndDate, maxEndDate, app))).take(numApps);
    }

    private boolean isAttemptInRange(ApplicationAttemptInfo attempt, SimpleDateParam minStartDate, SimpleDateParam maxStartDate, SimpleDateParam minEndDate, SimpleDateParam maxEndDate, boolean anyRunning) {
        boolean startTimeOk = attempt.startTime().getTime() >= minStartDate.timestamp() && attempt.startTime().getTime() <= maxStartDate.timestamp();
        boolean endTimeOkForRunning = anyRunning && maxEndDate.timestamp() > System.currentTimeMillis();
        boolean endTimeOkForCompleted = !anyRunning && attempt.endTime().getTime() >= minEndDate.timestamp() && attempt.endTime().getTime() <= maxEndDate.timestamp();
        boolean endTimeOk = endTimeOkForRunning || endTimeOkForCompleted;
        return startTimeOk && endTimeOk;
    }

    public static final /* synthetic */ boolean $anonfun$appList$3(ApplicationListResource $this, boolean includeCompleted$1, boolean includeRunning$1, SimpleDateParam minDate$1, SimpleDateParam maxDate$1, SimpleDateParam minEndDate$1, SimpleDateParam maxEndDate$1, ApplicationInfo app) {
        boolean anyRunning = app.attempts().isEmpty() || !((ApplicationAttemptInfo)app.attempts().head()).completed();
        return (!anyRunning && includeCompleted$1 || anyRunning && includeRunning$1) && app.attempts().exists((Function1 & Serializable & scala.Serializable)attempt -> BoxesRunTime.boxToBoolean((boolean)$this.isAttemptInRange(attempt, minDate$1, maxDate$1, minEndDate$1, maxEndDate$1, anyRunning)));
    }

    public ApplicationListResource() {
        ApiRequestContext.$init$(this);
    }
}

