/*
 * Decompiled with CFR 0.152.
 */
package jcuda;

public class cuDoubleComplex {
    public double x;
    public double y;

    private cuDoubleComplex() {
    }

    public static double cuCreal(cuDoubleComplex x) {
        return x.x;
    }

    public static double cuCimag(cuDoubleComplex x) {
        return x.y;
    }

    public static cuDoubleComplex cuCmplx(double r, double i) {
        cuDoubleComplex res = new cuDoubleComplex();
        res.x = r;
        res.y = i;
        return res;
    }

    public static cuDoubleComplex cuConj(cuDoubleComplex x) {
        return cuDoubleComplex.cuCmplx(cuDoubleComplex.cuCreal(x), -cuDoubleComplex.cuCimag(x));
    }

    public static cuDoubleComplex cuCadd(cuDoubleComplex x, cuDoubleComplex y) {
        return cuDoubleComplex.cuCmplx(cuDoubleComplex.cuCreal(x) + cuDoubleComplex.cuCreal(y), cuDoubleComplex.cuCimag(x) + cuDoubleComplex.cuCimag(y));
    }

    public static cuDoubleComplex cuCmul(cuDoubleComplex x, cuDoubleComplex y) {
        cuDoubleComplex prod = cuDoubleComplex.cuCmplx(cuDoubleComplex.cuCreal(x) * cuDoubleComplex.cuCreal(y) - cuDoubleComplex.cuCimag(x) * cuDoubleComplex.cuCimag(y), cuDoubleComplex.cuCreal(x) * cuDoubleComplex.cuCimag(y) + cuDoubleComplex.cuCimag(x) * cuDoubleComplex.cuCreal(y));
        return prod;
    }

    public static cuDoubleComplex cuCdiv(cuDoubleComplex x, cuDoubleComplex y) {
        double s = Math.abs(cuDoubleComplex.cuCreal(y)) + Math.abs(cuDoubleComplex.cuCimag(y));
        double oos = 1.0 / s;
        double ars = cuDoubleComplex.cuCreal(x) * oos;
        double ais = cuDoubleComplex.cuCimag(x) * oos;
        double brs = cuDoubleComplex.cuCreal(y) * oos;
        double bis = cuDoubleComplex.cuCimag(y) * oos;
        s = brs * brs + bis * bis;
        oos = 1.0 / s;
        cuDoubleComplex quot = cuDoubleComplex.cuCmplx((ars * brs + ais * bis) * oos, (ais * brs - ars * bis) * oos);
        return quot;
    }

    public static double cuCabs(cuDoubleComplex x) {
        double r;
        double p = cuDoubleComplex.cuCreal(x);
        double q = cuDoubleComplex.cuCimag(x);
        if (p == 0.0) {
            return q;
        }
        if (q == 0.0) {
            return p;
        }
        if ((p = Math.sqrt(p)) < (q = Math.sqrt(q))) {
            r = p;
            p = q;
            q = r;
        }
        r = q / p;
        return p * Math.sqrt(1.0 + r * r);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

