/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.template.TemplateUtil;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.InputStreamInputFormat;

public abstract class FrameGenerateReader
extends FrameReader {
    protected CustomProperties _props;
    protected TemplateUtil.SplitOffsetInfos _offsets;

    public FrameGenerateReader(CustomProperties _props) {
        this._props = _props;
    }

    @Override
    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        FrameGenerateReader.checkValidInputFile(fs, path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        Types.ValueType[] lschema = FrameGenerateReader.createOutputSchema(schema, clen);
        String[] lnames = FrameGenerateReader.createOutputNames(names, clen);
        FrameBlock ret = rlen <= 0L || this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter ? this.computeSizeAndCreateOutputFrameBlock(informat, job, schema, names, splits, path) : FrameGenerateReader.createOutputFrameBlock(lschema, lnames, rlen);
        this.readFrameFromHDFS(informat, splits, job, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameBlock computeSizeAndCreateOutputFrameBlock(TextInputFormat informat, JobConf job, Types.ValueType[] schema, String[] names, InputSplit[] splits, Path path) throws IOException, DMLRuntimeException {
        int row = 0;
        try {
            if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.Identity) {
                for (InputSplit inputSplit : splits) {
                    RecordReader reader = informat.getRecordReader(inputSplit, job, Reporter.NULL);
                    LongWritable key = new LongWritable();
                    Text value = new Text();
                    try {
                        while (reader.next((Object)key, (Object)value)) {
                            ++row;
                        }
                    }
                    finally {
                        IOUtilFunctions.closeSilently(reader);
                    }
                }
            } else if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                this._offsets = new TemplateUtil.SplitOffsetInfos(splits.length);
                for (int i = 0; i < splits.length; ++i) {
                    TemplateUtil.SplitInfo splitInfo = new TemplateUtil.SplitInfo();
                    this._offsets.setSeqOffsetPerSplit(i, splitInfo);
                    this._offsets.setOffsetPerSplit(i, row);
                }
                int splitIndex = 0;
                for (InputSplit inputSplit : splits) {
                    int j;
                    int i;
                    ArrayList<Object> endIndexes;
                    int nrows = 0;
                    TemplateUtil.SplitInfo splitInfo = this._offsets.getSeqOffsetPerSplit(splitIndex);
                    Pair<ArrayList<Pair<Long, Integer>>, Long> tokenPair = TemplateUtil.getTokenIndexOnMultiLineRecords(inputSplit, informat, job, this._props.getRowIndexStructure().getSeqBeginString());
                    ArrayList<Pair<Long, Integer>> beginIndexes = tokenPair.getKey();
                    long lastLineIndex = tokenPair.getValue();
                    int tokenLength = 0;
                    if (!this._props.getRowIndexStructure().getSeqBeginString().equals(this._props.getRowIndexStructure().getSeqEndString())) {
                        endIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(inputSplit, informat, job, this._props.getRowIndexStructure().getSeqEndString()).getKey();
                        tokenLength = this._props.getRowIndexStructure().getSeqEndString().length();
                        lastLineIndex = -1L;
                    } else {
                        endIndexes = new ArrayList();
                        for (i = 1; i < beginIndexes.size(); ++i) {
                            endIndexes.add(beginIndexes.get(i));
                        }
                    }
                    i = 0;
                    if (beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(0)).getKey()) {
                        ++nrows;
                        for (j = 0; j < endIndexes.size() && beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(j)).getKey(); ++j) {
                        }
                    }
                    while (i < beginIndexes.size() && j < endIndexes.size()) {
                        Pair<Long, Integer> p1 = beginIndexes.get(i);
                        Pair p2 = (Pair)endIndexes.get(j);
                        int n = 0;
                        while (p1.getKey() < (Long)p2.getKey() || p1.getKey() == p2.getKey() && p1.getValue() < (Integer)p2.getValue()) {
                            ++n;
                            if (++i == beginIndexes.size()) break;
                            p1 = beginIndexes.get(i);
                        }
                        splitInfo.addIndexAndPosition(beginIndexes.get(i - n).getKey(), (Long)((Pair)endIndexes.get(j += n - 1)).getKey(), beginIndexes.get(i - n).getValue(), (Integer)((Pair)endIndexes.get(j)).getValue() + tokenLength);
                        ++j;
                        ++nrows;
                    }
                    if (splitIndex < splits.length - 1) {
                        RecordReader reader = informat.getRecordReader(inputSplit, job, Reporter.NULL);
                        LongWritable key = new LongWritable();
                        Text value = new Text();
                        StringBuilder sb = new StringBuilder();
                        for (long ri = 0L; ri < beginIndexes.get(beginIndexes.size() - 1).getKey(); ++ri) {
                            reader.next((Object)key, (Object)value);
                        }
                        if (reader.next((Object)key, (Object)value)) {
                            String strVar = value.toString();
                            sb.append(strVar.substring(beginIndexes.get(beginIndexes.size() - 1).getValue()));
                            while (reader.next((Object)key, (Object)value)) {
                                sb.append(value.toString());
                            }
                            this._offsets.getSeqOffsetPerSplit(splitIndex + 1).setRemainString(sb.toString());
                        }
                    } else if (lastLineIndex != -1L) {
                        splitInfo.addIndexAndPosition((Long)((Pair)endIndexes.get(endIndexes.size() - 1)).getKey(), lastLineIndex, (Integer)((Pair)endIndexes.get(endIndexes.size() - 1)).getValue(), 0);
                        ++nrows;
                    }
                    splitInfo.setNrows(nrows);
                    this._offsets.setOffsetPerSplit(splitIndex, row);
                    row += nrows;
                    ++splitIndex;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Thread pool Error " + e.getMessage(), e);
        }
        FrameBlock ret = FrameGenerateReader.createOutputFrameBlock(schema, names, row);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Types.ValueType[] lschema = FrameGenerateReader.createOutputSchema(schema, clen);
        String[] lnames = FrameGenerateReader.createOutputNames(names, clen);
        FrameBlock ret = FrameGenerateReader.createOutputFrameBlock(lschema, lnames, rlen);
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        informat.getSplits(null, 1);
        return ret;
    }

    protected void readFrameFromHDFS(TextInputFormat informat, InputSplit[] splits, JobConf job, FrameBlock dest) throws IOException {
        int rpos = 0;
        for (int i = 0; i < splits.length; ++i) {
            RecordReader reader = informat.getRecordReader(splits[i], job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            TemplateUtil.SplitInfo splitInfo = null;
            if (this._props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                splitInfo = this._offsets.getSeqOffsetPerSplit(i);
                rpos = this._offsets.getOffsetPerSplit(i);
            }
            this.readFrameFromHDFS((RecordReader<LongWritable, Text>)reader, key, value, dest, rpos, splitInfo);
        }
    }

    protected abstract int readFrameFromHDFS(RecordReader<LongWritable, Text> var1, LongWritable var2, Text var3, FrameBlock var4, int var5, TemplateUtil.SplitInfo var6) throws IOException;
}

