/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Adler32;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheDataOutput;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageItem;

public class FederatedRequest
implements Serializable {
    private static final long serialVersionUID = 5946781306963870394L;
    private RequestType _method;
    private long _id;
    private long _tid;
    private List<Object> _data;
    private boolean _checkPrivacy;
    private List<Long> _checksums;
    private long _pid;
    private String _lineageTrace;

    public FederatedRequest(RequestType method) {
        this(method, FederationUtils.getNextFedDataID(), new ArrayList<Object>());
    }

    public FederatedRequest(RequestType method, long id) {
        this(method, id, new ArrayList<Object>());
    }

    public FederatedRequest(RequestType method, long id, Object ... data) {
        this(method, id, Arrays.asList(data));
    }

    public FederatedRequest(RequestType method, LineageItem linItem, long id, Object ... data) {
        this(method, id, Arrays.asList(data));
        this._lineageTrace = linItem != null ? Lineage.serializeSingleTrace(linItem) : null;
    }

    public FederatedRequest(RequestType method, long id, List<Object> data) {
        if (DMLScript.STATISTICS) {
            FederatedStatistics.incFederated(method, data);
        }
        this._method = method;
        this._id = id;
        this._data = data;
        this._pid = Long.valueOf(IDHandler.getProcessID());
        this.setCheckPrivacy();
    }

    public RequestType getType() {
        return this._method;
    }

    public long getID() {
        return this._id;
    }

    public long getTID() {
        return this._tid;
    }

    public void setTID(long tid) {
        this._tid = tid;
    }

    public long getPID() {
        return this._pid;
    }

    public Object getParam(int i) {
        return this._data.get(i);
    }

    public FederatedRequest appendParam(Object obj) {
        this._data.add(obj);
        return this;
    }

    public FederatedRequest appendParams(Object ... objs) {
        this._data.addAll(Arrays.asList(objs));
        return this;
    }

    public int getNumParams() {
        return this._data.size();
    }

    public FederatedRequest deepClone() {
        return new FederatedRequest(this._method, this._id, new ArrayList<Object>(this._data));
    }

    public void setCheckPrivacy(boolean checkPrivacy) {
        this._checkPrivacy = checkPrivacy;
    }

    public void setCheckPrivacy() {
        this.setCheckPrivacy(DMLScript.CHECK_PRIVACY);
    }

    public boolean checkPrivacy() {
        return this._checkPrivacy;
    }

    public void setChecksum() {
        this._checksums = new ArrayList<Long>();
        try {
            this.calcChecksum();
        }
        catch (IOException e) {
            throw new DMLException(e);
        }
    }

    public long getChecksum(int i) {
        if (this._checksums == null) {
            this.setChecksum();
        }
        return this._checksums.get(i);
    }

    private void calcChecksum() throws IOException {
        for (Object ob : this._data) {
            if (!(ob instanceof CacheBlock) && !(ob instanceof ScalarObject)) continue;
            Adler32 checksum = new Adler32();
            if (ob instanceof ScalarObject) {
                byte[] bytes = ((ScalarObject)ob).getStringValue().getBytes();
                checksum.update(bytes, 0, bytes.length);
                this._checksums.add(checksum.getValue());
            }
            if (!(ob instanceof CacheBlock)) continue;
            try {
                CacheBlock cb = (CacheBlock)ob;
                long cbsize = LazyWriteBuffer.getCacheBlockSize(cb);
                CacheDataOutput dout = new CacheDataOutput(new byte[(int)cbsize]);
                cb.write(dout);
                byte[] bytes = dout.getBytes();
                checksum.update(bytes, 0, bytes.length);
                this._checksums.add(checksum.getValue());
            }
            catch (Exception ex) {
                throw new IOException("Failed to serialize cache block.", ex);
            }
        }
    }

    public String getLineageTrace() {
        return this._lineageTrace;
    }

    public long estimateSerializationBufferSize() {
        long minBufferSize = 512L;
        if (this._data != null) {
            for (Object obj : this._data) {
                if (!(obj instanceof CacheBlock)) continue;
                minBufferSize += ((CacheBlock)obj).getExactSerializedSize();
            }
        }
        if (this._lineageTrace != null) {
            minBufferSize += (long)this._lineageTrace.length();
        }
        return minBufferSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FederatedRequest[");
        sb.append((Object)this._method);
        sb.append(";");
        sb.append(this._pid);
        sb.append(";");
        sb.append(this._id);
        sb.append(";t");
        sb.append(this._tid);
        if (this._data.size() > 0) {
            sb.append(";[");
            for (Object o : this._data) {
                sb.append(o.getClass().getSimpleName());
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum RequestType {
        READ_VAR,
        PUT_VAR,
        GET_VAR,
        EXEC_INST,
        EXEC_UDF,
        CLEAR,
        NOOP;

    }
}

