/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.rewrite;

import java.util.List;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.rewrite.LopRewriteRule;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;

public class RewriteFixIDs
extends LopRewriteRule {
    @Override
    public List<StatementBlock> rewriteLOPinStatementBlock(StatementBlock sb) {
        if (!(ConfigurationManager.isPrefetchEnabled() || ConfigurationManager.isBroadcastEnabled() || ConfigurationManager.isCheckpointEnabled())) {
            return List.of(sb);
        }
        if (HopRewriteUtils.isLastLevelLoopStatementBlock(sb)) {
            StatementBlock csb = sb instanceof WhileStatementBlock ? ((WhileStatement)sb.getStatement(0)).getBody().get(0) : ((ForStatement)sb.getStatement(0)).getBody().get(0);
            this.assignNewIDStatementBlock(csb);
        } else {
            this.assignNewIDStatementBlock(sb);
        }
        return List.of(sb);
    }

    @Override
    public List<StatementBlock> rewriteLOPinStatementBlocks(List<StatementBlock> sbs) {
        return sbs;
    }

    private void assignNewIDStatementBlock(StatementBlock sb) {
        if (sb.getLops() != null && !sb.getLops().isEmpty()) {
            for (Lop root : sb.getLops()) {
                this.assignNewIDLop(root);
            }
            sb.getLops().forEach(Lop::resetVisitStatus);
        }
    }

    private void assignNewIDLop(Lop lop) {
        if (lop.isVisited()) {
            return;
        }
        if (lop.getInputs().isEmpty()) {
            lop.setNewID();
            lop.setVisited();
            return;
        }
        for (Lop input : lop.getInputs()) {
            this.assignNewIDLop(input);
        }
        lop.setNewID();
        lop.setVisited();
    }
}

