/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class PickByCount
extends Lop {
    public static final String OPCODE = "qpick";
    private OperationTypes operation;
    private boolean inMemoryInput = false;

    public PickByCount(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, OperationTypes op, Types.ExecType et) {
        super(Lop.Type.PickValues, dt, vt);
        this.init(input1, input2, op, et);
    }

    public PickByCount(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, OperationTypes op, Types.ExecType et, boolean inMemoryInput) {
        super(Lop.Type.PickValues, dt, vt);
        this.inMemoryInput = inMemoryInput;
        this.init(input1, input2, op, et);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, Types.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        if (input2 != null) {
            this.addInput(input2);
            input2.addOutput(this);
        }
        this.operation = op;
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation: " + this.operation;
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (this.operation != OperationTypes.MEDIAN) {
            if (this.getInputs().get(1).getDataType() == Types.DataType.SCALAR) {
                sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
            } else {
                sb.append(this.getInputs().get(1).prepInputOperand(input2));
            }
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this.operation);
        sb.append("\u00b0");
        sb.append(this.inMemoryInput);
        if (this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._fedOutput.name());
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String input, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input), this.prepOutputOperand(output), this.operation.name(), String.valueOf(this.inMemoryInput));
        if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, this._fedOutput.name());
        }
        return ret;
    }

    public static enum OperationTypes {
        VALUEPICK,
        RANGEPICK,
        IQM,
        MEDIAN;

    }
}

