/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.GetMapAndMergeResultStatuses;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.KeyLock;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!\u0002\t\u0012\u0001E9\u0002\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u000b\u0005\u0002A\u0011\u0001\u0012\t\u000f\u0015\u0002!\u0019!C\u0001M!1a\b\u0001Q\u0001\n\u001dBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004G\u0001\u0001\u0006I!\u0011\u0005\t\u000f\u0002A)\u0019!C\u0005\u0011\"9A\n\u0001b\u0001\n\u0013i\u0005B\u0002+\u0001A\u0003%a\nC\u0003V\u0001\u0011\u0005c\u000bC\u0003e\u0001\u0011\u0005S\r\u0003\u0004e\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019E\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe^{'o[3s\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7C\u0001\u0001\u0019!\tI\"$D\u0001\u0012\u0013\tY\u0012C\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006!1m\u001c8g\u0007\u0001\u0001\"!G\u0010\n\u0005\u0001\n\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u00111\u0005\n\t\u00033\u0001AQ\u0001\b\u0002A\u0002y\t1\"\\1q'R\fG/^:fgV\tq\u0005\u0005\u0003)_E*T\"A\u0015\u000b\u0005)Z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003Y5\n!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019*\u0005\ri\u0015\r\u001d\t\u0003eMj\u0011!L\u0005\u0003i5\u00121!\u00138u!\r\u0011d\u0007O\u0005\u0003o5\u0012Q!\u0011:sCf\u0004\"!\u000f\u001f\u000e\u0003iR!aO\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA\u001f;\u0005%i\u0015\r]*uCR,8/\u0001\u0007nCB\u001cF/\u0019;vg\u0016\u001c\b%A\u0007nKJ<Wm\u0015;biV\u001cXm]\u000b\u0002\u0003B!\u0001fL\u0019C!\r\u0011dg\u0011\t\u0003s\u0011K!!\u0012\u001e\u0003\u00175+'oZ3Ti\u0006$Xo]\u0001\u000f[\u0016\u0014x-Z*uCR,8/Z:!\u0003A1W\r^2i\u001b\u0016\u0014x-\u001a*fgVdG/F\u0001J!\t\u0011$*\u0003\u0002L[\t9!i\\8mK\u0006t\u0017\u0001\u00044fi\u000eD\u0017N\\4M_\u000e\\W#\u0001(\u0011\u0007=\u0013\u0016'D\u0001Q\u0015\t\t\u0016#\u0001\u0003vi&d\u0017BA*Q\u0005\u001dYU-\u001f'pG.\fQBZ3uG\"Lgn\u001a'pG.\u0004\u0013aJ4fiB+8\u000f\u001b\"bg\u0016$7\u000b[;gM2,W*\u00199TSj,7OQ=Fq\u0016\u001cW\u000f^8s\u0013\u0012$ba\u0016.]=\u0002\u0014\u0007CA\rY\u0013\tI\u0016C\u0001\u000bNCB\u001c\u0016N_3t\u0005f,\u00050Z2vi>\u0014\u0018\n\u001a\u0005\u00067*\u0001\r!M\u0001\ng\",hM\u001a7f\u0013\u0012DQ!\u0018\u0006A\u0002E\nQb\u001d;beRl\u0015\r]%oI\u0016D\b\"B0\u000b\u0001\u0004\t\u0014aC3oI6\u000b\u0007/\u00138eKbDQ!\u0019\u0006A\u0002E\nab\u001d;beR\u0004\u0016M\u001d;ji&|g\u000eC\u0003d\u0015\u0001\u0007\u0011'\u0001\u0007f]\u0012\u0004\u0016M\u001d;ji&|g.A\rhKRl\u0015\r]*ju\u0016\u001chi\u001c:NKJ<WMU3tk2$H#\u00024\u0002\u0010\u0005E\u0001cA4pe:\u0011\u0001.\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003Wv\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00059l\u0013a\u00029bG.\fw-Z\u0005\u0003aF\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003]6\u0002BAM:vw&\u0011A/\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005YLX\"A<\u000b\u0005a\f\u0012aB:u_J\fw-Z\u0005\u0003u^\u0014aB\u00117pG.l\u0015M\\1hKJLE\rE\u0002hyzL!!`9\u0003\u0007M+\u0017\u000fE\u00043\u007f\u0006\r\u0011\u0011B\u0019\n\u0007\u0005\u0005QF\u0001\u0004UkBdWm\r\t\u0004m\u0006\u0015\u0011bAA\u0004o\n9!\t\\8dW&#\u0007c\u0001\u001a\u0002\f%\u0019\u0011QB\u0017\u0003\t1{gn\u001a\u0005\u00067.\u0001\r!\r\u0005\u0007\u0003'Y\u0001\u0019A\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u000b\bM\u0006]\u0011\u0011DA\u000e\u0011\u0015YF\u00021\u00012\u0011\u0019\t\u0019\u0002\u0004a\u0001c!9\u0011Q\u0004\u0007A\u0002\u0005}\u0011\u0001D2ik:\\GK]1dW\u0016\u0014\b\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015R#A\u0007s_\u0006\u0014\u0018N\\4cSRl\u0017\r]\u0005\u0005\u0003S\t\u0019CA\u0007S_\u0006\u0014\u0018N\\4CSRl\u0017\r]\u0001\fO\u0016$8\u000b^1ukN,7\u000f\u0006\u0004\u00020\u0005E\u00121\u0007\t\u0005eM,$\tC\u0003\\\u001b\u0001\u0007\u0011\u0007C\u0003\u001d\u001b\u0001\u0007a$A\tv]J,w-[:uKJ\u001c\u0006.\u001e4gY\u0016$B!!\u000f\u0002@A\u0019!'a\u000f\n\u0007\u0005uRF\u0001\u0003V]&$\b\"B.\u000f\u0001\u0004\t\u0014aC;qI\u0006$X-\u00129pG\"$B!!\u000f\u0002F!9\u0011qI\bA\u0002\u0005%\u0011\u0001\u00038fo\u0016\u0003xn\u00195")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private boolean fetchMergeResult;
    private final SparkConf conf;
    private final Map<Object, MapStatus[]> mapStatuses;
    private final Map<Object, MergeStatus[]> mergeStatuses;
    private final KeyLock<Object> fetchingLock;
    private volatile boolean bitmap$0;

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    public Map<Object, MergeStatus[]> mergeStatuses() {
        return this.mergeStatuses;
    }

    private boolean fetchMergeResult$lzycompute() {
        MapOutputTrackerWorker mapOutputTrackerWorker = this;
        synchronized (mapOutputTrackerWorker) {
            if (!this.bitmap$0) {
                this.fetchMergeResult = Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, false, Utils$.MODULE$.isPushBasedShuffleEnabled$default$3());
                this.bitmap$0 = true;
            }
        }
        return this.fetchMergeResult;
    }

    private boolean fetchMergeResult() {
        return !this.bitmap$0 ? this.fetchMergeResult$lzycompute() : this.fetchMergeResult;
    }

    private KeyLock<Object> fetchingLock() {
        return this.fetchingLock;
    }

    @Override
    public MapSizesByExecutorId getPushBasedShuffleMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        MapSizesByExecutorId mapSizesByExecutorId;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Fetching outputs for shuffle ").append(shuffleId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergedOutputStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergedOutputStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergedOutputStatuses2 = (MergeStatus[])tuple23._2();
        try {
            int actualEndMapIndex = endMapIndex == Integer.MAX_VALUE ? mapOutputStatuses2.length : endMapIndex;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Convert map statuses for shuffle ").append(shuffleId).append(", ").append("mappers ").append(startMapIndex).append("-").append(actualEndMapIndex).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
            mapSizesByExecutorId = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, mapOutputStatuses2, startMapIndex, actualEndMapIndex, (Option<MergeStatus[]>)Option$.MODULE$.apply((Object)mergedOutputStatuses2));
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return mapSizesByExecutorId;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergeResultStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergeResultStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergeResultStatuses2 = (MergeStatus[])tuple23._2();
        try {
            MergeStatus mergeStatus = mergeResultStatuses2[partitionId];
            MapOutputTracker$.MODULE$.validateStatus(mergeStatus, shuffleId, partitionId);
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, mergeStatus.tracker());
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId, RoaringBitmap chunkTracker) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        MapStatus[] mapOutputStatuses;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapStatusArray = mapOutputStatuses = (MapStatus[])tuple2._1();
        MapStatus[] mapOutputStatuses2 = mapStatusArray;
        try {
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, chunkTracker);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    private Tuple2<MapStatus[], MergeStatus[]> getStatuses(int shuffleId, SparkConf conf) {
        Tuple2 tuple2;
        if (this.fetchMergeResult()) {
            MapStatus[] mapOutputStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            MergeStatus[] mergeOutputStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (mapOutputStatuses == null || mergeOutputStatuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Don't have map/merge outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedMapStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    MergeStatus[] fetchedMergeStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedMapStatuses == null || fetchedMergeStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        Tuple2 fetchedBytes = (Tuple2)this.askTracker(new GetMapAndMergeResultStatuses(shuffleId), ClassTag$.MODULE$.apply(Tuple2.class));
                        try {
                            fetchedMapStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._1(), conf);
                            fetchedMergeStatuses = (MergeStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._2(), conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(67).append("Unable to deserialize broadcasted map/merge statuses").append(" for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map/merge output locations");
                        this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMapStatuses);
                        boxedUnit = this.mergeStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMergeStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Fetching map/merge output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedMapStatuses, (Object)fetchedMergeStatuses);
                });
            } else {
                tuple2 = new Tuple2((Object)mapOutputStatuses, (Object)mergeOutputStatuses);
            }
        } else {
            MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (statuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                        try {
                            fetchedStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses(fetchedBytes, conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(61).append("Unable to deserialize broadcasted map statuses for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map output locations");
                        boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedStatuses, null);
                });
            } else {
                tuple2 = new Tuple2((Object)statuses, null);
            }
        }
        return tuple2;
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
        this.mergeStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
                this.mergeStatuses().clear();
            }
        }
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        this.conf = conf;
        super(conf);
        this.mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.mergeStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.fetchingLock = new KeyLock();
    }
}

