/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class DistinctCostEstimator
implements ICostEstimate {
    private static final long serialVersionUID = 4784682182584508597L;
    private static final int toSmallForAnalysis = 64;
    private final double largestDistinct;
    private final int nRows;
    private final double sparsity;

    public DistinctCostEstimator(int nRows, CompressionSettings cs, double sparsity) {
        this.largestDistinct = Math.min(4096, Math.max(256, (int)((double)nRows * cs.coCodePercentage)));
        this.nRows = nRows;
        this.sparsity = sparsity;
    }

    @Override
    public double getUncompressedCost(CompressedSizeInfoColGroup g) {
        int nCols = g.getColumns().length;
        return (double)(this.nRows * nCols) * this.sparsity;
    }

    @Override
    public double getCostOfColumnGroup(CompressedSizeInfoColGroup g) {
        if (g == null) {
            return Double.POSITIVE_INFINITY;
        }
        int nVals = Math.max(g.getNumVals(), 64);
        return (double)nVals < this.largestDistinct ? (double)nVals : Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean shouldAnalyze(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        return g1.getNumVals() * g2.getNumVals() < 64;
    }
}

