/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.StatementBlock;

public class DMLProgram {
    public static final String DEFAULT_NAMESPACE = ".defaultNS";
    public static final String BUILTIN_NAMESPACE = ".builtinNS";
    public static final String INTERNAL_NAMESPACE = "_internal";
    private ArrayList<StatementBlock> _blocks = new ArrayList();
    private Map<String, FunctionDictionary<FunctionStatementBlock>> _namespaces = new HashMap<String, FunctionDictionary<FunctionStatementBlock>>();
    private boolean _containsRemoteParfor = false;

    public DMLProgram() {
    }

    public DMLProgram(String namespace) {
        this();
        this.createNamespace(namespace);
    }

    public Map<String, FunctionDictionary<FunctionStatementBlock>> getNamespaces() {
        return this._namespaces;
    }

    public void addStatementBlock(StatementBlock b) {
        this._blocks.add(b);
    }

    public int getNumStatementBlocks() {
        return this._blocks.size();
    }

    public void setContainsRemoteParfor(boolean flag) {
        this._containsRemoteParfor = flag;
    }

    public boolean containsRemoteParfor() {
        return this._containsRemoteParfor;
    }

    public static boolean isInternalNamespace(String namespace) {
        return DEFAULT_NAMESPACE.equals(namespace) || BUILTIN_NAMESPACE.equals(namespace) || INTERNAL_NAMESPACE.equals(namespace);
    }

    public FunctionDictionary<FunctionStatementBlock> createNamespace(String namespace) {
        if (!this._namespaces.containsKey(namespace)) {
            this._namespaces.put(namespace, new FunctionDictionary());
        }
        return this._namespaces.get(namespace);
    }

    public FunctionStatementBlock getFunctionStatementBlock(String fkey) {
        String[] tmp = DMLProgram.splitFunctionKey(fkey);
        return this.getFunctionStatementBlock(tmp[0], tmp[1]);
    }

    public void removeFunctionStatementBlock(String fkey) {
        String[] tmp = DMLProgram.splitFunctionKey(fkey);
        this.removeFunctionStatementBlock(tmp[0], tmp[1]);
    }

    public FunctionStatementBlock getFunctionStatementBlock(String namespaceKey, String functionName) {
        FunctionDictionary<FunctionStatementBlock> dict = this.getNamespaces().get(namespaceKey);
        if (dict == null) {
            return null;
        }
        return dict.getFunction(functionName);
    }

    public void removeFunctionStatementBlock(String namespaceKey, String functionName) {
        FunctionDictionary<FunctionStatementBlock> dict = this.getNamespaces().get(namespaceKey);
        if (dict != null) {
            dict.removeFunction(functionName);
        }
    }

    public Map<String, FunctionStatementBlock> getFunctionStatementBlocks(String namespaceKey) {
        FunctionDictionary<FunctionStatementBlock> dict = this.getNamespaces().get(namespaceKey);
        if (dict == null) {
            throw new LanguageException("ERROR: namespace " + namespaceKey + " is undefined");
        }
        return dict.getFunctions();
    }

    public boolean hasFunctionStatementBlocks() {
        return this._namespaces.values().stream().anyMatch(dict -> !dict.getFunctions().isEmpty());
    }

    public List<FunctionStatementBlock> getFunctionStatementBlocks() {
        ArrayList<FunctionStatementBlock> ret = new ArrayList<FunctionStatementBlock>();
        for (FunctionDictionary<FunctionStatementBlock> dict : this._namespaces.values()) {
            ret.addAll(dict.getFunctions().values());
        }
        return ret;
    }

    public Map<String, FunctionStatementBlock> getNamedNSFunctionStatementBlocks() {
        HashMap<String, FunctionStatementBlock> ret = new HashMap<String, FunctionStatementBlock>();
        for (FunctionDictionary<FunctionStatementBlock> dict : this._namespaces.values()) {
            for (Map.Entry<String, FunctionStatementBlock> e : dict.getFunctions().entrySet()) {
                ret.put(e.getKey(), e.getValue());
            }
        }
        return ret;
    }

    public FunctionDictionary<FunctionStatementBlock> getDefaultFunctionDictionary() {
        return this._namespaces.get(DEFAULT_NAMESPACE);
    }

    public FunctionDictionary<FunctionStatementBlock> getBuiltinFunctionDictionary() {
        return this._namespaces.get(BUILTIN_NAMESPACE);
    }

    public FunctionDictionary<FunctionStatementBlock> getFunctionDictionary(String namespace) {
        return this._namespaces.get(namespace);
    }

    public void addFunctionStatementBlock(String fname, FunctionStatementBlock fsb) {
        this.addFunctionStatementBlock(DEFAULT_NAMESPACE, fname, fsb);
    }

    public void addFunctionStatementBlock(String namespace, String fname, FunctionStatementBlock fsb) {
        FunctionDictionary<FunctionStatementBlock> dict = this.getNamespaces().get(namespace);
        if (dict == null) {
            throw new LanguageException("Namespace does not exist.");
        }
        dict.addFunction(fname, fsb);
    }

    public void copyOriginalFunctions() {
        for (FunctionDictionary<FunctionStatementBlock> dict : this.getNamespaces().values()) {
            dict.copyOriginalFunctions();
        }
    }

    public ArrayList<StatementBlock> getStatementBlocks() {
        return this._blocks;
    }

    public void setStatementBlocks(ArrayList<StatementBlock> passed) {
        this._blocks = passed;
    }

    public StatementBlock getStatementBlock(int i) {
        return this._blocks.get(i);
    }

    public void mergeStatementBlocks() {
        this._blocks = StatementBlock.mergeStatementBlocks(this._blocks);
    }

    public void hoistFunctionCallsFromExpressions() {
        try {
            for (FunctionStatementBlock fsb : this.getFunctionStatementBlocks()) {
                StatementBlock.rHoistFunctionCallsFromExpressions(fsb, this);
            }
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock sb : this._blocks) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(sb, this));
            }
            this._blocks = tmp;
        }
        catch (LanguageException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String namespaceKey : this.getNamespaces().keySet()) {
            sb.append("NAMESPACE = " + namespaceKey + "\n");
            FunctionDictionary<FunctionStatementBlock> dict = this.getNamespaces().get(namespaceKey);
            sb.append("FUNCTIONS = ");
            for (FunctionStatementBlock fsb : dict.getFunctions().values()) {
                sb.append(fsb);
                sb.append(", ");
            }
            sb.append("\n");
            sb.append("********************************** \n");
        }
        sb.append("******** MAIN SCRIPT BODY ******** \n");
        for (StatementBlock b : this._blocks) {
            sb.append(b);
            sb.append("\n");
        }
        sb.append("********************************** \n");
        return sb.toString();
    }

    public static String constructFunctionKey(String fnamespace, String fname) {
        return fnamespace + "::" + fname;
    }

    public static String[] splitFunctionKey(String fkey) {
        return fkey.split("::");
    }
}

