/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j.internal;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.wink.json4j.internal.Token;

public class Tokenizer {
    private Reader reader;
    private int lineNo;
    private int colNo;
    private int lastChar;
    private boolean strict = false;

    public Tokenizer(Reader reader) throws IOException {
        Class<?> readerClass = reader.getClass();
        if (!(StringReader.class.isAssignableFrom(readerClass) || CharArrayReader.class.isAssignableFrom(readerClass) || PushbackReader.class.isAssignableFrom(readerClass) || BufferedReader.class.isAssignableFrom(readerClass))) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.readChar();
    }

    public Tokenizer(Reader reader, boolean strict) throws IOException {
        Class<?> readerClass = reader.getClass();
        if (!(StringReader.class.isAssignableFrom(readerClass) || CharArrayReader.class.isAssignableFrom(readerClass) || PushbackReader.class.isAssignableFrom(readerClass) || BufferedReader.class.isAssignableFrom(readerClass))) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.strict = strict;
        this.readChar();
    }

    public Token next() throws IOException {
        while (this.isWhitespace((char)this.lastChar)) {
            this.readChar();
        }
        switch (this.lastChar) {
            case -1: {
                this.readChar();
                return Token.TokenEOF;
            }
            case 123: {
                this.readChar();
                return Token.TokenBraceL;
            }
            case 125: {
                this.readChar();
                return Token.TokenBraceR;
            }
            case 91: {
                this.readChar();
                return Token.TokenBrackL;
            }
            case 93: {
                this.readChar();
                return Token.TokenBrackR;
            }
            case 58: {
                this.readChar();
                return Token.TokenColon;
            }
            case 44: {
                this.readChar();
                return Token.TokenComma;
            }
            case 34: 
            case 39: {
                String stringValue = this.readString();
                return new Token(stringValue);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Number numberValue = this.readNumber();
                return new Token(numberValue);
            }
            case 102: 
            case 110: 
            case 116: {
                String ident = this.readIdentifier();
                if (ident.equals("null")) {
                    return Token.TokenNull;
                }
                if (ident.equals("true")) {
                    return Token.TokenTrue;
                }
                if (ident.equals("false")) {
                    return Token.TokenFalse;
                }
                if (!this.strict) {
                    return new Token(ident);
                }
                throw new IOException("Unexpected unquoted string literal: [" + ident + "].  Unquoted strings are not allowed in strict mode");
            }
            case 47: {
                if (!this.strict) {
                    this.readComment();
                    return this.next();
                }
                throw new IOException("Unexpected character / encountered " + this.onLineCol() + ".  Comments are not allowed in strict mode");
            }
        }
        if (!this.strict && this.isValidUnquotedChar((char)this.lastChar)) {
            String unquotedStr = this.readIdentifier();
            return new Token(unquotedStr);
        }
        if (this.strict) {
            throw new IOException("Unexpected character '" + (char)this.lastChar + "' " + this.onLineCol() + ".  Unquoted strings are not allowed in strict mode.");
        }
        throw new IOException("Unexpected character '" + (char)this.lastChar + "' " + this.onLineCol());
    }

    private void readComment() throws IOException {
        block7: {
            block6: {
                this.readChar();
                if ((char)this.lastChar != '/') break block6;
                while ((char)this.lastChar != '\n' && this.lastChar != -1) {
                    this.readChar();
                }
                break block7;
            }
            if ((char)this.lastChar != '*') break block7;
            char[] chars = new char[2];
            this.readChar();
            if (this.lastChar == -1) {
                return;
            }
            chars[0] = (char)this.lastChar;
            this.readChar();
            if (this.lastChar != -1) {
                chars[1] = (char)this.lastChar;
            } else {
                return;
            }
            while (chars[0] != '*' || chars[1] != '/') {
                this.readChar();
                if (this.lastChar != -1) {
                    chars[0] = chars[1];
                    chars[1] = (char)this.lastChar;
                    continue;
                }
                return;
            }
        }
    }

    private String readString() throws IOException {
        StringBuffer sb = new StringBuffer();
        int delim = this.lastChar;
        int l = this.lineNo;
        int c = this.colNo;
        this.readChar();
        block16: while (-1 != this.lastChar && delim != this.lastChar) {
            int digitValue;
            int i;
            StringBuffer digitBuffer;
            if (this.lastChar != 92) {
                sb.append((char)this.lastChar);
                this.readChar();
                continue;
            }
            this.readChar();
            switch (this.lastChar) {
                case 98: {
                    this.readChar();
                    sb.append('\b');
                    continue block16;
                }
                case 102: {
                    this.readChar();
                    sb.append('\f');
                    continue block16;
                }
                case 110: {
                    this.readChar();
                    sb.append('\n');
                    continue block16;
                }
                case 114: {
                    this.readChar();
                    sb.append('\r');
                    continue block16;
                }
                case 116: {
                    this.readChar();
                    sb.append('\t');
                    continue block16;
                }
                case 39: {
                    this.readChar();
                    sb.append('\'');
                    continue block16;
                }
                case 34: {
                    this.readChar();
                    sb.append('\"');
                    continue block16;
                }
                case 92: {
                    this.readChar();
                    sb.append('\\');
                    continue block16;
                }
                case 47: {
                    this.readChar();
                    sb.append('/');
                    continue block16;
                }
                case 117: 
                case 120: {
                    digitBuffer = new StringBuffer();
                    int toRead = 2;
                    if (this.lastChar == 117) {
                        toRead = 4;
                    }
                    for (i = 0; i < toRead; ++i) {
                        this.readChar();
                        if (!this.isHexDigit(this.lastChar)) {
                            throw new IOException("non-hex digit " + this.onLineCol());
                        }
                        digitBuffer.append((char)this.lastChar);
                    }
                    this.readChar();
                    try {
                        digitValue = Integer.parseInt(digitBuffer.toString(), 16);
                        sb.append((char)digitValue);
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                }
            }
            if (!this.isOctalDigit(this.lastChar)) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
            digitBuffer = new StringBuffer();
            digitBuffer.append((char)this.lastChar);
            for (i = 0; i < 2; ++i) {
                this.readChar();
                if (!this.isOctalDigit(this.lastChar)) break;
                digitBuffer.append((char)this.lastChar);
            }
            try {
                digitValue = Integer.parseInt(digitBuffer.toString(), 8);
                sb.append((char)digitValue);
            }
            catch (NumberFormatException e) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
        }
        if (-1 == this.lastChar) {
            throw new IOException("String not terminated " + this.onLineCol(l, c));
        }
        this.readChar();
        return sb.toString();
    }

    private Number readNumber() throws IOException {
        StringBuffer sb = new StringBuffer();
        int l = this.lineNo;
        int c = this.colNo;
        boolean isHex = false;
        if (this.lastChar == 45) {
            sb.append((char)this.lastChar);
            this.readChar();
        }
        if (this.lastChar == 48) {
            sb.append((char)this.lastChar);
            this.readChar();
            if (this.lastChar == 120 || this.lastChar == 88) {
                sb.append((char)this.lastChar);
                this.readChar();
                isHex = true;
            }
        }
        if (isHex) {
            while (this.isDigitChar(this.lastChar) || this.isHexDigit(this.lastChar)) {
                sb.append((char)this.lastChar);
                this.readChar();
            }
        } else {
            while (this.isDigitChar(this.lastChar)) {
                sb.append((char)this.lastChar);
                this.readChar();
            }
        }
        String string = sb.toString();
        try {
            if (-1 != string.indexOf(46)) {
                return Double.valueOf(string);
            }
            String sign = "";
            if (string.startsWith("-")) {
                sign = "-";
                string = string.substring(1);
            }
            if (isHex) {
                Long value = Long.valueOf(sign + string.substring(2), 16);
                if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                    return new Integer(value.intValue());
                }
                return value;
            }
            if (string.equals("0")) {
                return new Integer(0);
            }
            if (string.startsWith("0") && string.length() > 1) {
                Long value = Long.valueOf(sign + string.substring(1), 8);
                if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                    return new Integer(value.intValue());
                }
                return value;
            }
            if (string.indexOf("e") != -1 || string.indexOf("E") != -1) {
                return Double.valueOf(sign + string);
            }
            Long value = Long.valueOf(sign + string, 10);
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return new Integer(value.intValue());
            }
            return value;
        }
        catch (NumberFormatException e) {
            IOException iox = new IOException("Invalid number literal " + this.onLineCol(l, c));
            iox.initCause(e);
            throw iox;
        }
    }

    private boolean isHexDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private boolean isOctalDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    private boolean isDigitChar(int c) {
        switch (c) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 88: 
            case 101: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    private String readIdentifier() throws IOException {
        StringBuffer sb = new StringBuffer();
        if (this.strict) {
            while (-1 != this.lastChar && Character.isLetter((char)this.lastChar)) {
                sb.append((char)this.lastChar);
                this.readChar();
            }
        } else {
            while (-1 != this.lastChar && this.isValidUnquotedChar((char)this.lastChar)) {
                sb.append((char)this.lastChar);
                this.readChar();
            }
        }
        return sb.toString();
    }

    private void readChar() throws IOException {
        if (10 == this.lastChar) {
            this.colNo = 0;
            ++this.lineNo;
        }
        this.lastChar = this.reader.read();
        if (-1 == this.lastChar) {
            return;
        }
        ++this.colNo;
    }

    private String onLineCol(int line, int col) {
        return "on line " + line + ", column " + col;
    }

    public String onLineCol() {
        return this.onLineCol(this.lineNo, this.colNo);
    }

    public boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public boolean isValidUnquotedChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '$': 
            case '+': 
            case '-': 
            case '.': 
            case '@': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

