/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class ReblockFEDInstruction
extends UnaryFEDInstruction {
    private int blen;

    private ReblockFEDInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean emptyBlocks, String opcode, String instr) {
        super(FEDInstruction.FEDType.Reblock, op, in, out, opcode, instr);
        this.blen = br;
        this.blen = bc;
    }

    public static ReblockFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals("rblk")) {
            throw new DMLRuntimeException("Incorrect opcode for ReblockFEDInstruction:" + opcode);
        }
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int blen = Integer.parseInt(parts[3]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[4]);
        Operator op = null;
        return new ReblockFEDInstruction(op, in, out, blen, blen, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        CacheableData<?> obj = ec.getCacheableData(this.input1.getName());
        DataCharacteristics mc = ec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = ec.getDataCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), mc.getCols(), this.blen, mc.getNonZeros());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd == null) {
            throw new DMLRuntimeException("Error ReblockFEDInstruction: Metadata not found");
        }
        long id = FederationUtils.getNextFedDataID();
        FederatedRequest[] fr1 = new FederatedRequest[obj.getFedMapping().getSize()];
        int i = 0;
        for (FederatedRange range : obj.getFedMapping().getFederatedRanges()) {
            fr1[i] = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(range.getSize(0), range.getSize(1)), obj.getDataType()});
            ++i;
        }
        FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{obj.getFedMapping().getID()}, Types.ExecType.SPARK, false);
        obj.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
        CacheableData<?> out = ec.getCacheableData(this.output);
        out.setFedMapping(obj.getFedMapping().copyWithNewID(fr2.getID()));
        out.getDataCharacteristics().set(mcOut);
    }
}

