/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import java.util.Map;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatementBlock;

public class IPAPassFlagFunctionsRecompileOnce
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return true;
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        if (!ConfigurationManager.isDynamicRecompilation()) {
            return false;
        }
        try {
            for (Map.Entry<String, FunctionDictionary<FunctionStatementBlock>> e : prog.getNamespaces().entrySet()) {
                for (boolean opt : new boolean[]{true, false}) {
                    Map<String, FunctionStatementBlock> map = e.getValue().getFunctions(opt);
                    if (map == null) continue;
                    for (Map.Entry<String, FunctionStatementBlock> ef : map.entrySet()) {
                        FunctionStatementBlock fsblock = ef.getValue();
                        if (fgraph.isRecursiveFunction(e.getKey(), ef.getKey()) || !this.rFlagFunctionForRecompileOnce(fsblock, false)) continue;
                        fsblock.setRecompileOnce(true);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("IPA: FUNC flagged for recompile-once: " + DMLProgram.constructFunctionKey(e.getKey(), ef.getKey())));
                    }
                }
            }
        }
        catch (LanguageException ex) {
            throw new HopsException(ex);
        }
        return false;
    }

    public boolean rFlagFunctionForRecompileOnce(StatementBlock sb, boolean inLoop) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock c : fstmt.getBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else if (sb instanceof WhileStatementBlock) {
            ret = true;
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            ret |= inLoop && isb.requiresPredicateRecompilation();
            for (StatementBlock c : istmt.getIfBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
            for (StatementBlock c : istmt.getElseBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else {
            ret = sb instanceof ForStatementBlock ? true : (ret |= inLoop && sb.requiresRecompilation());
        }
        return ret;
    }
}

