/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.HttpResponseException;
import org.spark_project.jetty.client.Origin;
import org.spark_project.jetty.client.ProxyConfiguration;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.client.http.HttpConnectionOverHTTP;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpMethod;
import org.spark_project.jetty.http.HttpScheme;
import org.spark_project.jetty.io.ClientConnectionFactory;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.io.ssl.SslClientConnectionFactory;
import org.spark_project.jetty.util.Promise;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.util.ssl.SslContextFactory;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        super(address, secure);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        String scheme = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin(scheme, this.getAddress()).asString());
    }

    public static class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private static final Logger LOG = Log.getLogger(HttpProxyClientConnectionFactory.class);
        private final ClientConnectionFactory connectionFactory;

        public HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public org.spark_project.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            Promise promise = (Promise)context.get("http.connection.promise");
            ProxyPromise proxyPromise = new ProxyPromise(endPoint, promise, context);
            context.put("http.connection.promise", proxyPromise);
            return this.connectionFactory.newConnection(endPoint, context);
        }

        private class ProxyPromise
        implements Promise<Connection> {
            private final EndPoint endPoint;
            private final Promise<Connection> promise;
            private final Map<String, Object> context;

            private ProxyPromise(EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
                this.endPoint = endPoint;
                this.promise = promise;
                this.context = context;
            }

            @Override
            public void succeeded(Connection connection) {
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                if (HttpScheme.HTTPS.is(destination.getScheme())) {
                    SslContextFactory sslContextFactory = destination.getHttpClient().getSslContextFactory();
                    if (sslContextFactory != null) {
                        this.tunnel(destination, connection);
                    } else {
                        String message = String.format("Cannot perform requests over SSL, no %s in %s", SslContextFactory.class.getSimpleName(), HttpClient.class.getSimpleName());
                        this.promise.failed(new IllegalStateException(message));
                    }
                } else {
                    this.promise.succeeded(connection);
                }
            }

            @Override
            public void failed(Throwable x) {
                this.promise.failed(x);
            }

            private void tunnel(HttpDestination destination, Connection connection) {
                String target = destination.getOrigin().getAddress().asString();
                Origin.Address proxyAddress = destination.getConnectAddress();
                HttpClient httpClient = destination.getHttpClient();
                Request connect2 = httpClient.newRequest(proxyAddress.getHost(), proxyAddress.getPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).timeout(httpClient.getConnectTimeout(), TimeUnit.MILLISECONDS);
                connection.send(connect2, new Response.CompleteListener(){

                    @Override
                    public void onComplete(Result result2) {
                        if (result2.isFailed()) {
                            ProxyPromise.this.tunnelFailed(result2.getFailure());
                        } else {
                            Response response = result2.getResponse();
                            if (response.getStatus() == 200) {
                                ProxyPromise.this.tunnelSucceeded();
                            } else {
                                ProxyPromise.this.tunnelFailed(new HttpResponseException("Received " + response + " for " + result2.getRequest(), response));
                            }
                        }
                    }
                });
            }

            private void tunnelSucceeded() {
                try {
                    this.context.put("http.connection.promise", this.promise);
                    HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                    HttpClient client = destination.getHttpClient();
                    SslClientConnectionFactory sslConnectionFactory = new SslClientConnectionFactory(client.getSslContextFactory(), client.getByteBufferPool(), client.getExecutor(), HttpProxyClientConnectionFactory.this.connectionFactory);
                    HttpConnectionOverHTTP oldConnection = (HttpConnectionOverHTTP)this.endPoint.getConnection();
                    org.spark_project.jetty.io.Connection newConnection = sslConnectionFactory.newConnection(this.endPoint, this.context);
                    ClientConnectionFactory.Helper.replaceConnection(oldConnection, newConnection);
                    oldConnection.softClose();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP tunnel established: {} over {}", oldConnection, newConnection);
                    }
                }
                catch (Throwable x) {
                    this.tunnelFailed(x);
                }
            }

            private void tunnelFailed(Throwable failure) {
                this.endPoint.close();
                this.failed(failure);
            }
        }
    }
}

