/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderCompressedSelection
extends ReaderColumnSelection {
    private static final int decompressRowCount = 500;
    private final CompressedMatrixBlock compressedOverlap;
    private MatrixBlock _tmp;
    private int currentBlock;

    protected ReaderCompressedSelection(CompressedMatrixBlock compBlock, int[] colIndices) {
        super(colIndices, compBlock.getNumRows());
        this.compressedOverlap = compBlock;
        this._tmp = new MatrixBlock(500, compBlock.getNumColumns(), false).allocateDenseBlock();
        this.currentBlock = -1;
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        if (this.currentBlock != this._lastRow / 500) {
            this.currentBlock = this._lastRow / 500;
            for (AColGroup g : this.compressedOverlap.getColGroups()) {
                g.decompressToBlockUnSafe(this._tmp, this._lastRow, Math.min(this._lastRow + 500, g.getNumRows()), 0);
            }
        }
        DenseBlock bl = this._tmp.getDenseBlock();
        int offset = this._lastRow % 500;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this.reusableArr[i] = bl.get(offset, this._colIndexes[i]);
            bl.set(offset, this._colIndexes[i], 0.0);
        }
        return this.reusableReturn;
    }
}

