/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByte
extends AOffset {
    private static final int maxV = 255;
    private final byte[] offsets;
    private final int offsetToFirst;

    public OffsetByte(int[] indexes) {
        int endSize = 0;
        int ov = this.offsetToFirst = indexes[0];
        for (int i = 1; i < indexes.length; ++i) {
            int nv = indexes[i];
            endSize += 1 + (nv - ov) / 255;
            ov = nv;
        }
        this.offsets = new byte[endSize];
        ov = this.offsetToFirst;
        int p = 0;
        for (int i = 1; i < indexes.length; ++i) {
            int nv = indexes[i];
            int offsetSize = nv - ov;
            if (offsetSize == 0) {
                throw new DMLCompressionException("Invalid difference between cells");
            }
            int div = offsetSize / 255;
            int mod = offsetSize % 255;
            if (mod == 0) {
                p += div - 1;
                this.offsets[p++] = -1;
            } else {
                p += div;
                this.offsets[p++] = (byte)mod;
            }
            ov = nv;
        }
    }

    private OffsetByte(byte[] offsets, int offsetToFirst) {
        this.offsets = offsets;
        this.offsetToFirst = offsetToFirst;
    }

    @Override
    public IterateByteOffset getIterator() {
        return new IterateByteOffset();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE.BYTE.ordinal());
        out.writeInt(this.offsetToFirst);
        out.writeInt(this.offsets.length);
        for (byte o : this.offsets) {
            out.writeByte(o);
        }
    }

    @Override
    public long getInMemorySize() {
        return OffsetByte.getInMemorySize(this.offsets.length);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this.offsets.length;
    }

    @Override
    public int getSize() {
        int size = 1;
        for (byte b : this.offsets) {
            if (b == 0) continue;
            ++size;
        }
        return size;
    }

    public static long getInMemorySize(int length) {
        long size = 28L;
        return size += MemoryEstimates.byteArrayCost(length);
    }

    public static OffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        for (int i = 0; i < offsetsLength; ++i) {
            offsets[i] = in.readByte();
        }
        return new OffsetByte(offsets, offsetToFirst);
    }

    private class IterateByteOffset
    extends AIterator {
        private IterateByteOffset() {
            this.offset = OffsetByte.this.offsetToFirst;
        }

        @Override
        public void next() {
            if (this.index >= OffsetByte.this.offsets.length) {
                ++this.index;
                ++this.dataIndex;
                return;
            }
            byte v = OffsetByte.this.offsets[this.index++];
            if (v == 0) {
                this.offset += 255;
                this.next();
            } else {
                ++this.dataIndex;
                this.offset += v & 0xFF;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index <= OffsetByte.this.offsets.length;
        }
    }
}

