/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;

public class CumulativeOffsetBinary
extends Lop {
    private Types.AggOp _op;
    private double _initValue = 0.0;
    private boolean _broadcast = false;

    public CumulativeOffsetBinary(Lop data, Lop offsets, Types.DataType dt, Types.ValueType vt, Types.AggOp op, Types.ExecType et) {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        CumulativeOffsetBinary.checkSupportedOperations(op);
        this._op = op;
        this.init(data, offsets, dt, vt, et);
    }

    public CumulativeOffsetBinary(Lop data, Lop offsets, Types.DataType dt, Types.ValueType vt, double init, boolean broadcast, Types.AggOp op, Types.ExecType et) {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        CumulativeOffsetBinary.checkSupportedOperations(op);
        this._op = op;
        this._initValue = init;
        this._broadcast = broadcast;
        this.init(data, offsets, dt, vt, et);
    }

    private void init(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "CumulativeOffsetBinary";
    }

    private static void checkSupportedOperations(Types.AggOp op) {
        if (op != Types.AggOp.SUM && op != Types.AggOp.PROD && op != Types.AggOp.SUM_PROD && op != Types.AggOp.MIN && op != Types.AggOp.MAX) {
            throw new LopsException("Unsupported aggregate operation type: " + (Object)((Object)op));
        }
    }

    private String getOpcode() {
        switch (this._op) {
            case SUM: {
                return "bcumoffk+";
            }
            case PROD: {
                return "bcumoff*";
            }
            case SUM_PROD: {
                return "bcumoff+*";
            }
            case MIN: {
                return "bcumoffmin";
            }
            case MAX: {
                return "bcumoffmax";
            }
        }
        return null;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._initValue);
            sb.append("\u00b0");
            sb.append(this._broadcast);
        }
        return sb.toString();
    }
}

