/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashMap;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class GroupedAggregateM
extends Lop {
    public static final String OPCODE = "mapgroupedagg";
    private HashMap<String, Lop> _inputParams;
    private CacheType _cacheType = null;

    public GroupedAggregateM(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, boolean partitioned, LopProperties.ExecType et) {
        super(Lop.Type.GroupedAggM, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._inputParams = inputParameterLops;
        this._cacheType = partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT;
    }

    private void init(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(inputParameterLops.get("target"));
        inputParameterLops.get("target").addOutput(this);
        this.addInput(inputParameterLops.get("groups"));
        inputParameterLops.get("groups").addOutput(this);
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = MapGroupedAggregate";
    }

    @Override
    public String getInstructions(int input1, int input2, int output) {
        return this.getInstructions(String.valueOf(input1), String.valueOf(input2), String.valueOf(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._inputParams.get("ngroups").prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this._cacheType.toString());
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return this.getExecType() == LopProperties.ExecType.MR;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        int[] nArray;
        if (this.getExecType() == LopProperties.ExecType.MR) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = -1;
        }
        return nArray;
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART;

    }
}

