/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.action.PrincipalAware;
import org.apache.struts2.interceptor.PrincipalProxy;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.action.PortletContextAware;
import org.apache.struts2.portlet.action.PortletPreferencesAware;
import org.apache.struts2.portlet.action.PortletRequestAware;
import org.apache.struts2.portlet.action.PortletResponseAware;
import org.apache.struts2.portlet.interceptor.PortletPrincipalProxy;
import org.apache.struts2.portlet.interceptor.ServletPortletPreferences;

public class PortletAwareInterceptor
extends AbstractInterceptor
implements StrutsStatics {
    private static final long serialVersionUID = 2476509721059587700L;
    private static final Logger LOG = LogManager.getLogger(PortletAwareInterceptor.class);

    public String intercept(ActionInvocation invocation) throws Exception {
        PortletRequest request;
        Object action = invocation.getAction();
        ActionContext context = invocation.getInvocationContext();
        if (action instanceof PortletRequestAware) {
            request = (PortletRequest)context.get(PortletConstants.REQUEST);
            ((PortletRequestAware)action).withPortletRequest(request);
        }
        if (action instanceof PortletResponseAware) {
            PortletResponse response = (PortletResponse)context.get(PortletConstants.RESPONSE);
            ((PortletResponseAware)action).withPortletResponse(response);
        }
        if (action instanceof PrincipalAware) {
            request = (PortletRequest)context.get(PortletConstants.REQUEST);
            ((PrincipalAware)action).withPrincipalProxy((PrincipalProxy)new PortletPrincipalProxy(request));
        }
        if (action instanceof PortletContextAware) {
            PortletContext portletContext = (PortletContext)context.get("struts.portlet.context");
            ((PortletContextAware)action).withPortletContext(portletContext);
        }
        if (action instanceof PortletPreferencesAware) {
            request = (PortletRequest)context.get(PortletConstants.REQUEST);
            if (request == null) {
                LOG.warn("This portlet preferences implementation should only be used during development");
                ((PortletPreferencesAware)action).withPortletPreferences(new ServletPortletPreferences(ActionContext.getContext().getSession()));
            } else {
                ((PortletPreferencesAware)action).withPortletPreferences(request.getPreferences());
            }
        }
        return invocation.invoke();
    }
}

