/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.request.attribute.AttributeExtractor;
import org.apache.tiles.request.collection.CollectionUtil;
import org.apache.tiles.request.collection.MapEntry;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;
import org.apache.tiles.request.collection.RemovableKeySet;

public class ScopeMap
extends ReadOnlyEnumerationMap<Object> {
    private final AttributeExtractor context;

    public ScopeMap(AttributeExtractor context) {
        super(context);
        this.context = context;
    }

    @Override
    public void clear() {
        Enumeration<String> keys = this.context.getKeys();
        while (keys.hasMoreElements()) {
            this.context.removeValue(keys.nextElement());
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new ScopeEntrySet();
    }

    @Override
    public Set<String> keySet() {
        return new RemovableKeySet(this.context);
    }

    @Override
    public Object put(String key, Object value) {
        String strKey = CollectionUtil.key(key);
        Object previous = this.context.getValue(strKey);
        this.context.setValue(strKey, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (String string : map.keySet()) {
            this.context.setValue(string, map.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        String strKey = CollectionUtil.key(key);
        Object previous = this.context.getValue(strKey);
        this.context.removeValue(strKey);
        return previous;
    }

    private class ScopeEntrySet
    extends ReadOnlyEnumerationMap.ReadOnlyEnumerationMapEntrySet {
        private ScopeEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, Object> e) {
            String key = e.getKey();
            Object value = e.getValue();
            Object oldValue = ScopeMap.this.get(key);
            if (oldValue == null || !oldValue.equals(value)) {
                ScopeMap.this.context.setValue(key, value);
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, Object>> c) {
            boolean retValue = false;
            for (Map.Entry<String, Object> entry : c) {
                retValue |= this.add(entry);
            }
            return retValue;
        }

        @Override
        public void clear() {
            ScopeMap.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            String key = (String)entry.getKey();
            Object currentValue = ScopeMap.this.context.getValue(key);
            if (currentValue != null && currentValue.equals(entry.getValue())) {
                ScopeMap.this.context.removeValue(key);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Collection<?> realCollection = c;
            boolean retValue = false;
            for (Map.Entry entry : realCollection) {
                retValue |= this.remove(entry);
            }
            return retValue;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Collection<?> realCollection = c;
            boolean retValue = false;
            LinkedHashSet<String> keysToRemove = new LinkedHashSet<String>();
            Enumeration<String> keys = ScopeMap.this.context.getKeys();
            while (keys.hasMoreElements()) {
                Object value;
                String key = keys.nextElement();
                MapEntry entry = new MapEntry(key, value = ScopeMap.this.context.getValue(key), false);
                if (realCollection.contains(entry)) continue;
                retValue = true;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                ScopeMap.this.context.removeValue(key);
            }
            return retValue;
        }
    }
}

