/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;

public abstract class PlexusTestCase
extends TestCase {
    protected PlexusContainer container;
    private static String basedir;

    protected void setUp() throws Exception {
        basedir = PlexusTestCase.getBasedir();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("basedir", PlexusTestCase.getBasedir());
        boolean hasPlexusHome = context.containsKey("plexus.home");
        if (!hasPlexusHome) {
            File f = PlexusTestCase.getTestFile("target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            context.put("plexus.home", f.getAbsolutePath());
        }
        DefaultContext ctx = new DefaultContext(context);
        this.customizeContext(ctx);
        InputStream configuration = null;
        try {
            configuration = this.getCustomConfiguration();
            if (configuration == null) {
                configuration = this.getConfiguration();
            }
        }
        catch (Exception e) {
            System.out.println("Error with configuration:");
            System.out.println("configuration = " + configuration);
            Assert.fail((String)e.getMessage());
        }
        this.container = this.createContainerInstance(ctx.getContextData(), configuration);
    }

    protected PlexusContainer createContainerInstance(Map context, InputStream configuration) throws PlexusContainerException {
        InputStreamReader reader = null;
        if (configuration != null) {
            reader = new InputStreamReader(configuration);
        }
        return new DefaultPlexusContainer(reader, context);
    }

    private Context getContext() {
        return this.container.getContext();
    }

    protected void customizeContext(Context context) throws Exception {
    }

    protected InputStream getCustomConfiguration() throws Exception {
        return null;
    }

    protected void tearDown() throws Exception {
        this.container.dispose();
        this.container = null;
    }

    protected PlexusContainer getContainer() {
        return this.container;
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String subname) throws Exception {
        String className = ((Object)((Object)this)).getClass().getName();
        String base = className.substring(className.lastIndexOf(".") + 1);
        String config = null;
        config = subname == null || subname.equals("") ? base + ".xml" : base + "-" + subname + ".xml";
        InputStream configStream = this.getResourceAsStream(config);
        return configStream;
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected Object lookup(String componentKey) throws Exception {
        return this.getContainer().lookup(componentKey);
    }

    protected Object lookup(String role, String id) throws Exception {
        return this.getContainer().lookup(role, id);
    }

    protected void release(Object component) throws Exception {
        this.getContainer().release(component);
    }

    public static File getTestFile(String path) {
        return new File(PlexusTestCase.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusTestCase.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusTestCase.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusTestCase.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }
}

